typedef uint64_t MAC;
static inline MAC ether2MAC(const uint8_t *ether);

/*function prototypes: start*/
static inline MAC ether2MAC(const uint8_t * ether);
static uint8_t extract_header_length(uint16_t fc);
int decode_mgmt_frame(const u_char * ptr, uint16_t fc, uint8_t hdrlen);
int decode_data_frame(const u_char * ptr, uint16_t fc);
int decode_ctrl_frame(const u_char * ptr, uint16_t fc);
void Handle_packet(const struct pcap_pkthdr *header, const u_char * packet);
void process_ratiotap_header(uint8_t *buf, int buflen);
static void parse_elements(struct mgmt_body_t *pbody, const u_char *p, int offset, int len);
/*function prototypes: end*/

/* Translate Ethernet address, as seen in struct ether_header, to type MAC. */
static inline MAC ether2MAC(const uint8_t * ether)
{
        return ((((((((((((MAC) (ether[0]))
                         << 8) | ether[1])
                       << 8) | ether[2])
                     << 8) | ether[3])
                   << 8) | ether[4])
                 << 8) | ether[5]);
}

/* Extract header length. */
static uint8_t extract_header_length(uint16_t fc)
{
        switch (FC_TYPE(fc)) {
        case T_MGMT:
                return MGMT_HDRLEN;
        case T_CTRL:
                switch (FC_SUBTYPE(fc)) {
                case CTRL_PS_POLL:
                        return CTRL_PS_POLL_HDRLEN;
                case CTRL_RTS:
                        return CTRL_RTS_HDRLEN;
                case CTRL_CTS:
                        return CTRL_CTS_HDRLEN;
                case CTRL_ACK:
                        return CTRL_ACK_HDRLEN;
                case CTRL_CF_END:
                        return CTRL_END_HDRLEN;
                case CTRL_END_ACK:
                        return CTRL_END_ACK_HDRLEN;
                default:
                        return 0;
                }
        case T_DATA:
                return (FC_TO_DS(fc) && FC_FROM_DS(fc)) ? 30 : 24;
        default:
                return 0;
        }
}

/* In the following three arrays, even though the QoS subtypes are listed, in the rest of the program
 * the QoS subtypes are treated as "OTHER_TYPES". The file "ieee802_11.h" currently doesn't account for
 * the existence of QoS subtypes. The QoS subtypes might need to be accomodated there in the future.
 */
static const char * mgmt_subtype_text[] = {
        "AssocReq",
        "AssocResp",
        "ReAssocReq",
        "ReAssocResp",
        "ProbeReq",
        "ProbeResp",
        "",
        "",
        "Beacon",
        "ATIM",
        "Disassoc",
        "Auth",
        "DeAuth",
        "Action", /*QoS mgmt_subtype*/
        "",
        ""
};

static const char * ctrl_subtype_text[] = {
        "", "", "", "", "", "", "", "",
        "BlockAckReq", /*QoS ctrl_subtype*/
        "BlockAck",    /*QoS ctrl_subtype*/
        "PS-Poll",
        "RTS",
        "CTS",
        "ACK",
        "CF-End",
        "CF-End+CF-Ack"
};

static const char * data_subtype_text[] = {
        "Data",
        "Data+CF-Ack",
        "Data+CF-Poll",
        "Data+CF-Ack+CF-Poll",
        "Null(no_data)",
        "CF-Ack(no_data)",
        "CF-Poll(no_data)",
        "CF-Ack+CF-Poll(no_data)",
        "QoS_Data", /*QoS data_subtypes from here on*/
        "QoS_Data+CF-Ack",
        "QoS_Data+CF-Poll",
        "QoS_Data+CF-Ack+CF-Poll",
        "QoS_Null(no_data)",
        "",
        "QoS_CF-Poll(no_data)",
        "QoS_CF-Ack+CF-Poll(no_data)"
};

typedef struct {
	u_char tag;
	u_char len;
	u_char OUI[3];
} VENDOR_SPEC_HEADER;

typedef struct  {
	u_char ap_id;
	MAC ap_mac_addr;
} MERU_SPEC_INFO;

#define TTEST2(_p, _l) ((const u_char *)&(_p) - p + (_l) <= len) 

/* from ethereal packet-radiotap.c */

//little endian to host byte order (short)
#define pletohs(p)  ((uint16_t) \
                    ((uint16_t)*((const uint8_t *)(p)+1)<<8|  \
                    (uint16_t)*((const uint8_t *)(p)+0)<<0))

//network to host byte order (long)
#define pntohl(p)   ((uint32_t)*((const uint8_t *)(p)+0)<<24|  \
                    (uint32_t)*((const uint8_t *)(p)+1)<<16|  \
                    (uint32_t)*((const uint8_t *)(p)+2)<<8|   \
                    (uint32_t)*((const uint8_t *)(p)+3)<<0)
#define COOK_FRAGMENT_NUMBER(x) ((x) & 0x000F)
#define COOK_SEQUENCE_NUMBER(x) (((x) & 0xFFF0) >> 4)
/* end ethereal code */
