%
% Estimate posture from IMU data
%
clc;
clear;

load public_sensordata.mat
load public_attitude.mat

num_records = length(public_sensor);
avg_acc = zeros(num_records, 3);
avg_msg = zeros(num_records, 3);
R = cell(num_records);
dim = 3;

for i = 1:num_records
    % for each record, take the average of acc and mag
    acc = public_sensor{i}.test_case{1}{2};
    mag = public_sensor{i}.test_case{3}{2};
    
    avg_acc = mean(acc(:,2:4));
    avg_mag = mean(mag(:,2:4));
    
    h = cross(avg_mag, avg_acc);
    h = h./norm(h);    
    a = avg_acc./norm(avg_acc);
    
    m = cross(a, h);
    
    R{i} = zeros(3, 3);
    R{i}(1,:) = h;
    R{i}(2,:) = m;
    R{i}(3,:) = a;
    
    % compute the Euler angles in radian
    %yaw phi
    %roll xi
    %pitch theta
   if (abs(R{i}(3,1)) ~= 1) 
       angles{i} = zeros(1,3);
       theta1 = -asin(R{i}(3,1));
       theta2 = pi - asin(R{i}(3,1));

       xi1 = atan2(R{i}(3,2)/cos(theta1),R{i}(3,3)/cos(theta1));
       xi2 = atan2(R{i}(3,2)/cos(theta2),R{i}(3,3)/cos(theta2));
       
       phi1 = atan2(R{i}(2,1)/cos(theta1), R{i}(1,1)/cos(theta1));
       phi2 = atan2(R{i}(2,1)/cos(theta2), R{i}(1,1)/cos(theta2));
       
       angles{i} = [phi1, xi1, theta1]*180/pi;
   else
       %undeterministic case
       warning('theta = pi/2, infinite solutions exist');
       angles{i} = [NaN, NaN, pi/2];       
   end
end

