function [TP, FP, FN, Precision, Recall] = eval_stat(ground_truth, test)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%STEP COUNTING EVALUATION
% INPUTS:
%   ground_truth - binary 1-D array of step events from the ground truth data
%   test - binary 1-D array of step events from your algorithm
%
% OUPUTS:
%   TP - true positive
%   FP - false positive
%   FN - false negative
%   Precision - TP/(TP+FP)
%   Recall - TP/(TP+FN)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% step frequecy 2HZ, one step=500ms, peak and valley are half-half
% peak time is about 250ms, Accelerometer sampling frequency is about
% 200HZ, the 250ms/5ms = 50, the tolerance of detected step events +-25
% samples
STEP_WINDOW = 50;

%%
%set the window of every step to its step number
extended_steps = ground_truth;
step_num = 1;
step_indices = find(ground_truth==1);
for i=1:numel(step_indices)
    step_index = step_indices(i);
    extended_steps(max(1, step_index-STEP_WINDOW/2):1:min(numel(ground_truth), step_index+STEP_WINDOW/2-1)) = step_num;
    step_num = step_num + 1;
end

%%
%evaluate the results
step_counts = zeros(max(extended_steps)+1,1);
test_step_indices = find(test==1);
for i = 1:numel(test_step_indices)
    test_step_index = test_step_indices(i);
    if 0 == extended_steps(test_step_index)
        step_counts(max(extended_steps)+1) = step_counts(max(extended_steps)+1) + 1;
    else
        step_counts(extended_steps(test_step_index)) = step_counts(extended_steps(test_step_index)) + 1;
    end
end

%%
%get TP, TN etc, calc precison and recall
TP = numel(find(step_counts>0));
FP = sum(step_counts(find(step_counts>1))) - numel(find(step_counts>1)) + step_counts(max(extended_steps)+1);
FN = numel(find(step_counts(1:end-1)==0));
Precision = TP/(TP + FP);
Recall = TP/(TP + FN);
fprintf('-------Reports--------------------------\n')
fprintf('True Positive:%d\n', TP);
fprintf('False Positive:%d\n', FP);
fprintf('False Negative:%d\n', FN);
fprintf('Precision:%f\n', Precision);
fprintf('Recall:%f\n', Recall);
fprintf('-------END------------------------------\n');
