% Author: Rong Zheng, Oct. 20, 2015
%
function rotMatrix = EstimatePoseChangeGyro( gyro, sampleInterval)
% OPUT:  rotMatrix - a rotation matrix
%        flag - 1 if a significant angular change has occurred, 0 otherwise 
% INPUT: gyro -- 3-D gyro reading
%        sampleInterval -- sampling interval
%        thresh -- threshold for significant changes

gyroMag = norm(gyro);

axisX = gyro(1)/gyroMag;
axisY = gyro(2)/gyroMag;
axisZ = gyro(3)/gyroMag;

gyroMag = gyroMag*sampleInterval;
rotMatrix = vrrotvec2mat([axisX, axisY, axisZ, gyroMag]);
