% Author: Rong Zheng, Oct. 20, 2015
%
function theta = fuseTwoAngles(theta1, theta2, w)
% interpolate two vectors by pojecting onto the x-y plane
% theta1, theta2 in the range of [-pi, pi]


if (abs(theta1 - theta2) > pi)
    if (theta1 < 0)
        theta = (2*pi + theta1)*w + theta2*(1-w);
    else
        theta = theta1*w + (2*pi + theta2)*(1-w);
    end
else
    theta = theta1*w + theta2*(1-w);
end

