% Author: Rong Zheng, Oct. 20, 2015
%
function heading = EstimateHeadingAccMag(acc, mag)
% 
% heading direction: represented as the device y in the global frame

h = cross(mag, acc);
h = h./norm(h);
a = acc./norm(acc);

m = cross(a, h);

R = zeros(3, 3);
R(1,:) = h;
R(2,:) = m;
R(3,:) = a;

heading = R*[0 1 0]';
