% By Rong Zheng 2015-10-20
%
function y = OnMapTest(locs, innerEdges, outerEdges)
% Test if points in (lat, long) falls inside the map
% INPUT: 
% 	innerEdges -- a polygon cell array
% 	outerEdger -- a polygon
% 	locs -- # of points x 2 array
%
% OUTPUT: an array of # of points x 1, where each element is defined by,
% 0 - inside, 1 - outside or on the boundary
%
% NOTE: the function assumes that the inner polygons are contained in the outer
% polygon
%
n = length(locs);
bOutsideInner = ones(n, 1);
bInsideOuter = zeros(n, 1);


for i = 1:length(innerEdges)
   bOutsideInner = bOutsideInner & ~inpolygon(locs(:,1), locs(:,2), innerEdges{i}(:,1), innerEdges{i}(:,2));
end
bInsideOuter = inpolygon(locs(:,1), locs(:,2), outerEdges(:,1), outerEdges(:,2));

y = bInsideOuter & bOutsideInner;

