% Author: Rong Zheng, Oct. 20, 2015
%
function v = fuseTwoHeadings(v1, v2, w)
% Interpolate two vectors by pojecting onto the x-y plane
% INPUT: 
%	v1 -- the first heading in a 2x1 array
%	v2 -- the second heading in a 2x1 array
%	w -- weight in [0, 1]
% OUTPUT: weighted heading	

theta1 = atan2(v1(2), v1(1));
theta2 = atan2(v2(2), v2(1));

if (abs(theta1 - theta2) > pi)
    if (theta1 < 0)
        theta = (2*pi + theta1)*w + theta2*(1-w);
    else
        theta = theta1*w + (2*pi + theta2)*(1-w);
    end
else
    theta = theta1*w + theta2*(1-w);
end

v(1) = cos(theta);
v(2) = sin(theta);
v(3) = 0;
