% By XuQiang 2015-10-2
% Verify and visualize the map and marker information
% For visualization, x-axis points east, y-axis points north

%%
clc
clear
load map.mat

% generate background box
bg = [
        min(outer_edge(:,1)) - 10, min(outer_edge(:,2)) - 10;
        min(outer_edge(:,1)) - 10, max(outer_edge(:,2)) + 10;
        max(outer_edge(:,1)) + 10, max(outer_edge(:,2)) + 10;
        max(outer_edge(:,1)) + 10, min(outer_edge(:,2)) - 10;
];


%%
figure;

fill(bg(:,2), bg(:,1), 'k', 'EdgeColor', 'none'); hold on; axis tight;  % Draw black background
fill(outer_edge(:,1), outer_edge(:,2), 'w', 'EdgeColor', 'none');       % Draw outer polygon
fill(inter_edge1(:,1), inter_edge1(:,2), 'k', 'EdgeColor', 'none');     
fill(inter_edge2(:,1), inter_edge2(:,2), 'k', 'EdgeColor', 'none');     %Draw interior polygon (i.e. holes)

plot(marker(:,1), marker(:,2),'gO');                                    %Draw all markers
plot(marker(1,1), marker(1,2), 'r+');                                   %Start from first marker

%Draw marker number
for i = 1:numel(marker(:,1))
    text(marker(i, 1)-0.2, marker(i, 2), num2str(i));
end

title('ITB-2F');