/*
** server.c -- a stream socket server demo using select
*/

#define _XOPEN_SOURCE
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <signal.h>
#include <sys/poll.h>
#include "helper.h"

#ifndef OPEN_MAX
#define OPEN_MAX 256
#endif
#ifndef INFTIM
#define INFTIM          (-1)    /* infinite poll timeout */
#endif

#define MYPORT 3490	// the port users will be connecting to
#define MAX_LINE           (1000)
#define NOTDEF


#define BACKLOG 10	 // how many pending connections queue will hold

int main(void)
{
	int listenfd, connfd, maxfd;  // listen on sock_fd, new connection on new_fd
	struct sockaddr_in my_addr;	// my address information
	struct sockaddr_in cliaddr; // connector's address information
	socklen_t sin_size;
	struct sigaction sa;
	int yes=1, maxi, i, n;
	char buffer[MAX_LINE];
	int nready; 
	struct pollfd		client[OPEN_MAX];


	if ((listenfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		perror("socket");
		exit(1);
	}

	if (setsockopt(listenfd, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof(int)) == -1) {
		perror("setsockopt");
		exit(1);
	}
	
	my_addr.sin_family = AF_INET;		 // host byte order
	my_addr.sin_port = htons(MYPORT);	 // short, network byte order
	my_addr.sin_addr.s_addr = INADDR_ANY; // automatically fill with my IP
	memset(&(my_addr.sin_zero), '\0', 8); // zero the rest of the struct

	if (bind(listenfd, (struct sockaddr *)&my_addr, sizeof(struct sockaddr)) == -1) {
		perror("bind");
		exit(1);
	}

	if (listen(listenfd, BACKLOG) == -1) {
		perror("listen");
		exit(1);
	}

	maxfd = listenfd;			/* initialize */
	maxi = -1;				/* index into client[] array */

	client[0].fd = listenfd;
	client[0].events = POLLRDNORM;

	for (i = 1; i < OPEN_MAX; i++)
		client[i].fd = -1;		/* -1 indicates available entry */
	maxi = 0;					/* max index into client[] array */

	for ( ; ; ) {
		nready = poll(client, maxi+1, INFTIM);

		if (client[0].revents & POLLRDNORM) {	/* new client connection */
			sin_size = sizeof(struct sockaddr_in);
			if ((connfd = accept(listenfd, (struct sockaddr *)&cliaddr, &sin_size)) == -1) {
				perror("accept");
				continue;
			}
#ifdef	NOTDEF
			char hostname[80];
			printf("new client: %s, port %d\n",
					inet_ntop(AF_INET, &cliaddr.sin_addr, hostname, sizeof(hostname)),
					ntohs(cliaddr.sin_port));
#endif

			for (i = 1; i < OPEN_MAX; i++)
				if (client[i].fd < 0) {
					client[i].fd = connfd;	/* save descriptor */
					break;
				}

			if (i == OPEN_MAX)
				perror("too many clients");

			client[i].events = POLLRDNORM;
			if (i > maxi)
				maxi = i;				/* max index in client[] array */

			if (--nready <= 0)
				continue;				/* no more readable descriptors */
		}

		for (i = 1; i <= maxi; i++) {	/* check all clients for data */
			if ( (connfd = client[i].fd) < 0)
				continue;
			if (client[i].revents & (POLLRDNORM | POLLERR)) {
				if ( (n = Readline(connfd, buffer, MAX_LINE)) < 0) {
					if (errno == ECONNRESET) {
						/*4connection reset by client */
#ifdef	NOTDEF
						printf("client[%d] aborted connection\n", i);
#endif
						close(connfd);
						client[i].fd = -1;
					} else
						perror("readline error");
				} else if (n == 0) {
					/*4connection closed by client */
#ifdef	NOTDEF
					printf("client[%d] closed connection\n", i);
#endif
					close(connfd);
					client[i].fd = -1;
				} else
					Writeline(connfd, buffer, n);

				if (--nready <= 0)
					break;				/* no more readable descriptors */
			}
		}
	}

}


