/*
** server.c -- a stream socket server demo using select
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <signal.h>
#include "helper.h"

#define MYPORT 3490	// the port users will be connecting to
#define MAX_LINE           (1000)
#define NOTDEF

#define BACKLOG 10	 // how many pending connections queue will hold


int main(void)
{
	int listenfd, connfd, maxfd;  // listen on sock_fd, new connection on new_fd
	struct sockaddr_in my_addr;	// my address information
	struct sockaddr_in cliaddr; // connector's address information
	socklen_t sin_size;
	struct sigaction sa;
	int yes=1, maxi, i, n;
	char buffer[MAX_LINE];
	fd_set	rset, allset;
	int nready, client[FD_SETSIZE];

	if ((listenfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		perror("socket");
		exit(1);
	}

	if (setsockopt(listenfd, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof(int)) == -1) {
		perror("setsockopt");
		exit(1);
	}
	
	my_addr.sin_family = AF_INET;		 // host byte order
	my_addr.sin_port = htons(MYPORT);	 // short, network byte order
	my_addr.sin_addr.s_addr = INADDR_ANY; // automatically fill with my IP
	memset(&(my_addr.sin_zero), '\0', 8); // zero the rest of the struct

	if (bind(listenfd, (struct sockaddr *)&my_addr, sizeof(struct sockaddr)) == -1) {
		perror("bind");
		exit(1);
	}

	if (listen(listenfd, BACKLOG) == -1) {
		perror("listen");
		exit(1);
	}

	maxfd = listenfd;			/* initialize */
	maxi = -1;				/* index into client[] array */
	for (i = 0; i < FD_SETSIZE; i++)
		client[i] = -1;			/* -1 indicates available entry */

	FD_ZERO(&allset);
	FD_SET(listenfd, &allset);

	for ( ; ; ) {
		rset = allset;		/* structure assignment */
		nready = select(maxfd+1, &rset, NULL, NULL, NULL);

		if (FD_ISSET(listenfd, &rset)) {	/* new client connection */
			sin_size = sizeof(struct sockaddr_in);
			if ((connfd = accept(listenfd, (struct sockaddr *)&cliaddr, &sin_size)) == -1) {
				perror("accept");
				continue;
			}
#ifdef	NOTDEF
			char hostname[80];
			printf("new client: %s, port %d\n",
					inet_ntop(AF_INET, &cliaddr.sin_addr, hostname, sizeof(hostname)),
					ntohs(cliaddr.sin_port));
#endif
			for (i = 0; i < FD_SETSIZE; i++)
				if (client[i] < 0) {
					client[i] = connfd;    /* save descriptor */
					break;
				}

			if (i == FD_SETSIZE)
				perror("too many clients");

			FD_SET(connfd, &allset);	/* add new descriptor to set */
			if (connfd > maxfd)
				maxfd = connfd;			/* for select */
			if (i > maxi)
				maxi = i;	/* max index in client[] array */

			if (--nready <= 0)
				continue;	/* no more readable descriptors */
		}

		for (i = 0; i <= maxi; i++) {	/* check all clients for data */
			if ( (connfd = client[i]) < 0)
				continue;

			if (FD_ISSET(connfd, &rset)) {
				if ( (n = Readline(connfd, buffer, MAX_LINE-1)) == 0) {
					/*4connection closed by client */
#ifdef	NOTDEF
					char hostname[80];
					sin_size = sizeof(struct sockaddr_in);
					getpeername(connfd, (struct sockaddr *)&cliaddr, &sin_size);
					printf("Connection closed by : %s, port %d\n",
							inet_ntop(AF_INET, &cliaddr.sin_addr, hostname, sizeof(hostname)),
							ntohs(cliaddr.sin_port));
#endif
					close(connfd);
					FD_CLR(connfd, &allset);
					client[i] = -1;
				} else
					Writeline(connfd, buffer, n);

				if (--nready <= 0)
					break;	/* no more readable descriptors */
			}
		}
	}
}


