#include "ping.h" 

struct proto    proto_v4 = { proc_v4, send_v4, NULL, NULL, NULL, 0, IPPROTO_ICMP };
int      datalen = 56;           /* data that goes with ICMP echo request */


int main(int argc, char *argv[]) {
	struct sockaddr_in their_addr;	
	struct hostent *he;
	char c;

	while ( (c = getopt(argc, argv, "v")) != -1) {
		switch (c) {
			case 'v':
				verbose++;
				break;

			case '?':
				printf("unrecognized option: %c", c);
				exit(1);
		}
	}

	if (optind != argc-1) {
		perror("usage: ping [ -v ] <hostname>");
		exit(1);
	}

	if ((he=gethostbyname(argv[optind])) == NULL) {  // get the host info 
		perror("gethostbyname");
		exit(1);
	}

	their_addr.sin_family = AF_INET;    // host byte order 
	their_addr.sin_addr = *((struct in_addr *)he->h_addr);
	memset(&(their_addr.sin_zero), '\0', 8);  // zero the rest of the struct 

	pid = getpid() & 0xffff;    /* ICMP ID field is 16 bits */
	signal(SIGALRM, sig_alrm);
	printf("PING (v0.1) %s (%s): %d data bytes\n",
			argv[optind],	
			inet_ntoa(their_addr.sin_addr), datalen);

	pr = &proto_v4;
	pr->sasend = (struct sockaddr *)&their_addr;
	pr->sarecv = calloc(1, sizeof(struct sockaddr_in));
	pr->salen = sizeof(struct sockaddr_in);

	readloop();

	exit(0);

}

void readloop() {
		int             size;
		char            recvbuf[BUFSIZE];
		ssize_t         n;
		struct timeval  tval;

		if ((sockfd = socket(pr->sasend->sa_family, SOCK_RAW, pr->icmpproto)) == -1) {
			perror("socket");
			exit(1);

		}
		setuid(getuid());       /* don't need special permissions any more */
		if (pr->finit)
			(*pr->finit)();

		size = 60 * 1024;       /* OK if setsockopt fails */
		if ((setsockopt(sockfd, SOL_SOCKET, SO_RCVBUF, &size, sizeof(size))) == -1) {
			perror("socket");
			exit(1);

		}

		sig_alrm(SIGALRM);      /* send first packet */

		for ( ; ; ) {
				n = recvfrom(sockfd, &recvbuf, BUFSIZE, 0, pr->sarecv, (int *)&pr->salen);
				if (n < 0) {
						if (errno == EINTR)
								continue;
						else
							perror("recvfrom error");
				}

				gettimeofday(&tval, NULL);
				(*pr->fproc)(recvbuf, n, &tval);
		}

}

void
proc_v4(char *ptr, ssize_t len, struct timeval *tvrecv)
{
	int             hlen1, icmplen;
	double          rtt;
	struct ip       *ip;
	struct icmp     *icmp;
	struct timeval  *tvsend;

	ip = (struct ip *) ptr;     /* start of IP header */
	hlen1 = ip->ip_hl << 2;     /* length of IP header */
	if (ip->ip_p != IPPROTO_ICMP)
		return;             /* not ICMP */

	icmp = (struct icmp *) (ptr + hlen1);   /* start of ICMP header */
	if ( (icmplen = len - hlen1) < 8)
		return;             /* malformed packet */

	if (icmp->icmp_type == ICMP_ECHOREPLY) {
		if (icmp->icmp_id != pid)
			return;         /* not a response to our ECHO_REQUEST */
		if (icmplen < 16)
			return;         /* not enough data to use */

		tvsend = (struct timeval *) icmp->icmp_data;
		tv_sub(tvrecv, tvsend);
		rtt = tvrecv->tv_sec * 1000.0 + tvrecv->tv_usec / 1000.0;

		printf("%d bytes from %s: seq=%u, ttl=%d, rtt=%.3f ms\n",
				icmplen, inet_ntoa(((struct sockaddr_in *)pr->sarecv)->sin_addr),
				icmp->icmp_seq, ip->ip_ttl, rtt);

	} else if (verbose) {
		printf("  %d bytes from %s: type = %d, code = %d\n",
				icmplen, inet_ntoa(((struct sockaddr_in *)pr->sarecv)->sin_addr),
				icmp->icmp_type, icmp->icmp_code);
	}
}

void
send_v4(void)
{
	int         len;
	struct icmp *icmp;

	icmp = (struct icmp *) sendbuf;
	icmp->icmp_type = ICMP_ECHO;
	icmp->icmp_code = 0;
	icmp->icmp_id = pid;
	icmp->icmp_seq = nsent++;
	memset(icmp->icmp_data, 0xa5, datalen); /* fill with pattern */
	gettimeofday((struct timeval *) icmp->icmp_data, NULL);

	len = 8 + datalen;      /* checksum ICMP header and data */
	icmp->icmp_cksum = 0;
	icmp->icmp_cksum = in_cksum((u_short *) icmp, len);

	sendto(sockfd, sendbuf, len, 0, pr->sasend, pr->salen);
}


void
sig_alrm(int signo)
{
	(*pr->fsend)();

	alarm(1);
	return;
}
