#include "route.h"

/**
* Send a request to NETLINK to send the routing table
*/
int request_route(int fd)
{
 	route_request netlink_req;
	struct sockaddr_nl local;
	struct sockaddr_nl peer;   
	struct msghdr msg_info;
	struct iovec iov_info;

	bzero(&local, sizeof(local));
	local.nl_family = AF_NETLINK;
	local.nl_pad = 0;
	local.nl_pid = getpid();
	local.nl_groups = 0;
	if(bind(fd, (struct sockaddr*) &local, sizeof(local)) < 0) {
		printf("Error in sock bind\n");
		exit(1);
	}

	bzero(&peer, sizeof(peer));
	peer.nl_family = AF_NETLINK;
	peer.nl_pad = 0;
	peer.nl_pid = 0;
	peer.nl_groups = 0;

	bzero(&netlink_req, sizeof(netlink_req));

	netlink_req.nlmsg_info.nlmsg_len = NLMSG_LENGTH(sizeof(struct rtmsg));
	netlink_req.nlmsg_info.nlmsg_flags = NLM_F_REQUEST | NLM_F_DUMP;
	netlink_req.nlmsg_info.nlmsg_type = RTM_GETROUTE;

	netlink_req.rtmsg_info.rtm_family = AF_INET;
	netlink_req.rtmsg_info.rtm_table = RT_TABLE_MAIN;

	iov_info.iov_base = (void *) &netlink_req.nlmsg_info;
	iov_info.iov_len = netlink_req.nlmsg_info.nlmsg_len;

	struct msghdr msg = {
		(void*)&peer, sizeof(peer),
		&iov_info,   1,
		NULL,   0,
		0
	};

	if(sendmsg(fd, &msg, 0) < 0) {
		perror("Error in sendmsg\n");
		exit(1);
	}
}

/**
* Read the output sent by NETLINK for the read route table request given
* in function send_route_read_request()
*/
int get_route(int fd, char *buffer)
{
	int rtn;
	int nlmsg_len = 0;

	char *read_ptr = &buffer[0];
	while(1) {
		rtn = recv(fd, read_ptr, 4096, 0);
		if(rtn < 0) {
			perror("Error in recv\n");
			exit(1);
		}

		if(((struct nlmsghdr *)read_ptr)->nlmsg_type == NLMSG_DONE)	{
			break;
		}

		read_ptr = read_ptr + rtn;
		nlmsg_len = nlmsg_len + rtn;
	}
	return nlmsg_len;
}

/**
* Extract each route table entry and print
*/
int show_route(int fd)
{
	char dst_str[128];
	char gw_str[128];
	char ifc_str[128];
	int rtmsg_len, len;
	struct rtattr *rtattr_ptr;
	struct rtmsg *rtmsg_ptr;
	char buffer[8192];
	
	bzero(buffer, 8192);
	request_route(fd);
	len = get_route(fd, &buffer[0]);

	printf("Main route table\n");
	struct nlmsghdr *nlmsg_ptr = (struct nlmsghdr *) buffer;
	for(; NLMSG_OK(nlmsg_ptr, len); nlmsg_ptr = NLMSG_NEXT(nlmsg_ptr, len)) {

		rtmsg_ptr = (struct rtmsg *) NLMSG_DATA(nlmsg_ptr);
		// only main route table is considered
		if(rtmsg_ptr->rtm_table != RT_TABLE_MAIN)
			continue;

		bzero(dst_str, 128);
		bzero(gw_str, 128);
		bzero(ifc_str, 128);

		rtattr_ptr = (struct rtattr *) RTM_RTA(rtmsg_ptr);
		rtmsg_len = RTM_PAYLOAD(nlmsg_ptr);
		for(;RTA_OK(rtattr_ptr, rtmsg_len); rtattr_ptr = RTA_NEXT(rtattr_ptr, rtmsg_len)) {
			switch(rtattr_ptr->rta_type) {
			case RTA_DST:
				inet_ntop(AF_INET, RTA_DATA(rtattr_ptr), dst_str, 128);
				break;
			case RTA_GATEWAY:
				inet_ntop(AF_INET, RTA_DATA(rtattr_ptr), gw_str, 128);
				break;
			case RTA_OIF:
				sprintf(ifc_str, "%d", *((int *) RTA_DATA(rtattr_ptr)));
			default:
				break; 

			}
		}

		if(strlen(dst_str) == 0) {
			printf("default");
		} else {
			printf("%s/%d", dst_str, rtmsg_ptr->rtm_dst_len);
		}

		if(strlen(gw_str) != 0) {
			printf(" via %s", gw_str);
		}

		if(strlen(ifc_str) != 0) {
			printf(" dev %s", ifc_str);
		}
		printf("\n");
	}
}

