
\section{Example Atom Set Configurations}\sectlabel{AtomsetExamples}

\subsection{Preliminaries}

\begin{code}
module AtomsetExamples(aCat_P1,aAll_P1,ra_P1,
                       aCat_P12,aAll_P12,ra_P12,ObjP12(..)
           ,all_B12,ra_B12,bToP12,pToB12,test_for_equivalence_12) where

import RelAlg
import Matrix
import Atomset
import A4

import FiniteMaps
import Sets
\end{code}

\ignore{
%{{{ \subsection{P1}
\subsection{P1}

Note: This section may be replaced by either one of the appendices in
order to provide for other relation algebras!

\medskip
\noindent
The relation algebra considered here as an introduction corresponds to 
the ridiculously simple case of boolean $1\times1$-matrices.    
It is, therefore, made up of the relations 
on a 1-element set.

\begin{code}
aCat_P1 :: ACat () ()
aCat_P1 = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ _ _  _ -> True)
  ,acat_objects = [()]
  ,acat_atomset = const $ const [()]
  ,acat_idmor   = const [()]
  ,acat_comp    = (\ _ _ _  _ _ -> [()])
  }

aAll_P1 :: AAll () ()
aAll_P1 = AAll
  {aall_acat = aCat_P1
  ,aall_converse = (\ _ _  _ -> ())
  }

ra_P1 :: RA () (SetMor () ())
ra_P1 = atomsetRA aAll_P1
\end{code}

There is just one source and target object.
The morphisms thereon are spanned by atoms,
only one atom for the moment.

The empty list {\tt []} of atoms is the zero morphism
and the full list corresponds to the universal morphism.
Transposition is defined to be the identity mapping.

This homogeneous relation algebra corresponds very closely to 
$\Bool=\{\tt True, False\}$ with composition coinciding with {\tt and}.

\bigskip
\noindent
In the appendices, much more difficult definitions 
of always the same principal structure are given.
They all need some extensions in order to 
provide a relation algebra.
These extensions given in the following section
are common to all of them.
%}}}
}%ignore

%{{{ \subsection{P12}
\subsection{P12}

\noindent
This relation algebra 
shows how pairs of elements may be handled together
with their partiality. Let ${\tt P1}$ be a set of elements 
all of which may be instantaneously available or not. 
Then ${\tt P2}$ is formed as the set of pairs, where a
pair may be available with four degrees of partiality, namely
no, left, right, or both components of the pair. A relation between such
pairs may have four atomic ways of propagating partiality: Left component
determines left or right component. 
In the same way, the right component may determine both.
This is reflected by the atoms {\tt At1, At2, At3, At4} of 
the morphism set {\tt Mor(P2, P2)}.

\begin{code}
aCat_P12 :: ACat ObjP12 A4
aCat_P12 = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = isAtom
  ,acat_objects = [P1, P2]
  ,acat_atomset = atomsP12
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = atComp
  }

aAll_P12 :: AAll ObjP12 A4
aAll_P12 = AAll
  {aall_acat = aCat_P12
  ,aall_converse = conv
  }

ra_P12 :: RA ObjP12 (SetMor ObjP12 A4)
ra_P12 = atomsetRA aAll_P12
\end{code}

\begin{code}
data ObjP12 = P1 | P2  deriving (Eq, Ord, Show) 
\end{code}

\begin{code}
atomsP12 :: ObjP12 -> ObjP12 -> [A4]
atomsP12 P2 P2 = [At1, At2, At3, At4]
atomsP12 P1 P1 = [At1]
atomsP12 _  _  = [At1, At2]

isAtom P1 P1 a = a == At1
isAtom P2 P2 a = True
isAtom _ _ At1 = True
isAtom _ _ At2 = True
isAtom _ _ _   = False
\end{code}

It is possible to print an atomset element and the object names.
\begin{code}
atomToChar = \ x -> (case x of At1  -> "1"
                               At2  -> "2"
                               At3  -> "3"
                               At4  -> "4")

objectToChar = \ x -> (case x of P1  -> "P1"
                                 P2  -> "P2")
atomListToChar z = foldr (++) [] (map atomToChar z)
\end{code}
and in addition as \TeX-matrices.
\begin{code}
trenn = (\ x y -> x ++ ", " ++ y)
atomToTeXChar x = "{\\tt " ++ atomToChar x ++ "}"

objectToTeXChar x = "{\\tt " ++ objectToChar x ++ "}"

positions (x, P1, m) = 2
positions (x, P2, m) = 4

atomSetToTeXChar1 z = foldr (++) [] (map atomToChar z)
atomSetToTeXChar  (p, q, m) = (objectToTeXChar p) ++ k' ++ (objectToTeXChar q)
 where k  = atomSetToTeXChar1 m
       k' = "{\\tt [" ++ k ++ concat (replicate (4 - length k) "\\ ") ++ "]}"
\end{code}
%       rest p q = foldr (++) [] (take (positions (p, q, m)) (repeat "\\ "))

The empty list {\tt []}  of atoms denotes the  null morphism
and the respective (!) full list denotes the universal morphism.
\begin{code}
conv :: ObjP12 -> ObjP12 -> A4 -> A4
conv P2 P2 At2 = At3
conv P2 P2 At3 = At2
conv _  _  x   = x

atComp :: ObjP12 -> ObjP12 -> ObjP12 -> A4 -> A4 -> [A4] 

atComp P2 P2 P2 At1 At1 = [At1]
atComp P2 P2 P2 At1 At2 = [At2]
atComp P2 P2 P2 At1 At3 = []
atComp P2 P2 P2 At1 At4 = []

atComp P2 P2 P2 At2 At1 = []
atComp P2 P2 P2 At2 At2 = []
atComp P2 P2 P2 At2 At3 = [At1]
atComp P2 P2 P2 At2 At4 = [At2]

atComp P2 P2 P2 At3 At1 = [At3]
atComp P2 P2 P2 At3 At2 = [At4]
atComp P2 P2 P2 At3 At3 = []
atComp P2 P2 P2 At3 At4 = []

atComp P2 P2 P2 At4 At1 = []
atComp P2 P2 P2 At4 At2 = []
atComp P2 P2 P2 At4 At3 = [At3]
atComp P2 P2 P2 At4 At4 = [At4]

atComp P2 P2 P1 At1 At1 = [At1]
atComp P2 P2 P1 At1 At2 = []
atComp P2 P2 P1 At2 At1 = []
atComp P2 P2 P1 At2 At2 = [At1]

atComp P2 P2 P1 At3 At1 = [At2]
atComp P2 P2 P1 At3 At2 = []
atComp P2 P2 P1 At4 At1 = []
atComp P2 P2 P1 At4 At2 = [At2]

atComp P2 P1 P2 At1 At1 = [At1]
atComp P2 P1 P2 At1 At2 = [At2]
atComp P2 P1 P2 At2 At1 = [At3]
atComp P2 P1 P2 At2 At2 = [At4]

atComp P2 P1 P1 At1 At1 = [At1]
atComp P2 P1 P1 At2 At1 = [At2]

atComp P1 P2 P2 At1 At1 = [At1]
atComp P1 P2 P2 At1 At2 = [At2]
atComp P1 P2 P2 At1 At3 = []
atComp P1 P2 P2 At1 At4 = []

atComp P1 P2 P2 At2 At1 = []
atComp P1 P2 P2 At2 At2 = []
atComp P1 P2 P2 At2 At3 = [At1]
atComp P1 P2 P2 At2 At4 = [At2]

atComp P1 P2 P1 At1 At1 = [At1]
atComp P1 P2 P1 At1 At2 = []
atComp P1 P2 P1 At2 At1 = []
atComp P1 P2 P1 At2 At2 = [At1]

atComp P1 P1 P2 At1 At1 = [At1]
atComp P1 P1 P2 At1 At2 = [At2]

atComp P1 P1 P1 At1 At1 = [At1] 
\end{code}

\bigskip
\noindent
One will easily find out, 
that here transposition and composition is handled 
in the same way as for boolean
$1\times 1-, 1\times 2-, 2\times 2-,$ and $2\times 1-$matrices.
The correspondence is established so as 
to let atom {\tt At}$i$ stand for the matrix with 
just one {\tt True}-entry at position $i$ when 
numbering rowwise from the upper left corner in the usual way.

\begin{code}
ra_B12 = raMat raB [[()],[(),()]]
all_B12 = ra_all ra_B12

bToPobj [_]   = P1
bToPobj [_,_] = P2

pToBobj P1 = [()]
pToBobj P2 = [(),()]

atMat P1 P1 = [[At1]]
atMat P1 P2 = [[At1,At2]]
atMat P2 P1 = [[At1],[At2]]
atMat P2 P2 = [[At1,At2],[At3,At4]]

bToP12 = matBtoAtCat bToPobj atMat
pToB12 = atCatToMatB pToBobj atMat

test_for_equivalence_12 =
       let (t1,t2) = all_equiv_TESTS all_B12 (ra_all ra_P12) bToP12 pToB12
       in printTestResults t1 >> printTestResults t2
\end{code}

Just for information:

\begin{session}
HugsMain> perform ra_TEST_ALL ra_P12    
No results.

(23561800 reductions, 47133886 cells, 225 garbage collections)
HugsMain> perform ra_TEST_ALL ra_B12
No results.

(17790982 reductions, 35745371 cells, 171 garbage collections)
\end{session}

%}}}


%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:
