\subsection{Compass}\subsectlabel{Compass}
\ignore{Stand 14.07.2000}

\noindent
Now we recall the so-called compass algebra. It may be understood
as being generated from compass-like qualifications
represented in atoms as follows

\centerline{\def\pair#1#2{#2 & \mbox{by} & {\tt #1}}%
\def\skip{\multicolumn{3}{c}{}}%
\def\sep{\hskip4em}%
\begin{tabular}{lll@{\sep}lll@{\sep}lll}
\pair{I}{identity}
&
\pair{E}{east}
&
\pair{W}{west}
\\
\skip
&
\pair{N}{north}
&
\pair{S}{south}
\\
\skip
&
\pair{NE}{northeasterly}
&
\pair{SW}{southwesterly}
\\
\skip
&
\pair{NW}{northwesterly}
&
\pair{SE}{southeasterly}
\end{tabular}}

%{{{ \ignore{old table}
\ignore{
{\parindent=4em
     \ \hbox to4cm{identity\hfil by {\tt  I }}

     \ \hbox to4cm{east\hfil by {\tt  E }}\qquad\qquad\hbox to4cm{west\hfil by {\tt  W }}

     \ \hbox to4cm{northeasterly\hfil by {\tt NE}}\qquad\qquad\hbox to4cm{southwesterly \hfil by {\tt SW}} 

     \ \hbox to4cm{north\hfil by {\tt  N }}\qquad\qquad\hbox to4cm{south\hfil by {\tt  S }}

     \ \hbox to4cm{northwesterly\hfil by {\tt NW}}\qquad\qquad\hbox to4cm{southeasterly\hfil by {\tt SE}}
}
}%ignore
%}}}

\noindent
More details may be found in \cite{Vilain-Kautz-1988, Vilain-Kautz-vanBeek-1989, Maddux-1993}.

\begin{code}
module Compass(aCat_Compass,aAll_Compass,ra_Compass,writeAtComp_Compass) where

import RelAlg
import Atomset
import Draw
import FiniteMaps
\end{code}

\begin{code}
data Atomset = I | N | E | S | W | NE | SE | SW | NW deriving (Eq, Ord, Show)  
atoms = [I, N, E, S, W, NE, SE, SW, NW]
\end{code}

\begin{code}
aCat_Compass :: ACat () Atomset
aCat_Compass = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ _ _ _ -> True)
  ,acat_objects = [()]
  ,acat_atomset = (\ _ _ -> atoms)
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = (\ _ _ _ -> atComp)
  }

aAll_Compass :: AAll () Atomset
aAll_Compass = AAll
  {aall_acat = aCat_Compass
  ,aall_converse = (\ _ _ -> conv)
  }

ra_Compass :: RA () (SetMor () Atomset)
ra_Compass = atomsetRA aAll_Compass
\end{code}

\begin{code}
conv :: Atomset -> Atomset
conv I  = I
conv N  = S
conv E  = W
conv S  = N
conv W  = E
conv NE = SW
conv SE = NW
conv SW = NE
conv NW = SE
\end{code}

\ignore{
%{{{ atComp
\begin{code}
atComp :: Atomset -> Atomset -> [Atomset]

atComp I x   = [x]
atComp x   I = [x]
       
atComp E E = [E]
atComp E W = [I, E, W]
atComp E NE = [NE]
atComp E SW = [SW, S, SE]
atComp E N = [NE]
atComp E S = [SE]
atComp E NW = [NE, N, NW]
atComp E SE = [SE]
       
atComp W E = [I, E, W]
atComp W W = [W]
atComp W NE = [NE, N, NW]
atComp W SW = [SW]
atComp W N = [NW]
atComp W S = [SW]
atComp W NW = [NW]
atComp W SE = [SW, S, SE]
       
atComp NE E = [NE]
atComp NE W = [NE, N, NW]
atComp NE NE = [NE]
atComp NE SW = [I, E, W, NE, SW, N, S, NW, SE]
atComp NE N = [NE]
atComp NE S = [E, NE, SE]
atComp NE NW = [NE, N, NW]
atComp NE SE = [E, NE, SE]
       
atComp SW E = [SW, S, SE]
atComp SW W = [SW]
atComp SW NE = [I, E, W, NE, SW, N, S, NW, SE]
atComp SW SW = [SW]
atComp SW N = [W, SW, NW]
atComp SW S = [SW]
atComp SW NW = [W, SW, NW]
atComp SW SE = [SW, S, SE]
       
atComp N E = [NE]
atComp N W = [NW]
atComp N NE = [NE]
atComp N SW = [W, SW, NW]
atComp N N = [N]
atComp N S = [I, N, S]
atComp N NW = [NW]
atComp N SE = [E, NE, SE]
       
atComp S E = [SE]
atComp S W = [SW]
atComp S NE = [E, NE, SE]
atComp S SW = [SW]
atComp S N = [I, N, S]
atComp S S = [S]
atComp S NW = [W, SW, NW]
atComp S SE = [SE]
       
atComp NW E = [NE, N, NW]
atComp NW W = [NW]
atComp NW NE = [NE, N, NW]
atComp NW SW = [W, SW, NW]
atComp NW N = [NW]
atComp NW S = [W, SW, NW]
atComp NW NW = [NW]
atComp NW SE = [I, E, W, NE, SW, N, S, NW, SE]
       
atComp SE E = [SE]
atComp SE W = [SW, S, SE]
atComp SE NE = [E, NE, SE]
atComp SE SW = [SW, S, SE]
atComp SE N = [E, NE, SE]
atComp SE S = [SE]
atComp SE NW = [I, E, W, NE, SW, N, S, NW, SE]
atComp SE SE = [SE]
\end{code}
%}}}
}%ignore

The explicit composition table is contained in the distribution;
%here we present it in a nicer way:
here is a nicer presentation:

\medbreak
\centerline{\includegraphics{Compass_atComp.eps}}

\medbreak
For producing this, we first have to assign every non-identity atom a direction:
\begin{code}
atDir N  = 90
atDir E  = 0
atDir S  = 270
atDir W  = 180
atDir NE = 45
atDir SE = 315
atDir SW = 225
atDir NW = 135
atDir I  = error "atDir I"
\end{code}

The drawing is then defined by
using the tools in the drawing module of \sectref{Draw}:

\begin{code}
arrow = "-5 0 moveto 9 0 lineto 7 -1 moveto 9 0 lineto 7 1 lineto "
writeAtComp_Compass =
  let base = graphicCenterFrameScale 10 10 ++ "0.3 setlinewidth\n"
      atPS I = "newpath -3 -3 moveto -3  3 lineto\n" ++
               "         3  3 lineto  3 -3 lineto closepath stroke\n"
      atPS d = "gsave " ++ show (atDir d) ++ " rotate newpath " ++ arrow
               ++ "stroke grestore\n"
      atLout = Limit (MM 9) (MM 9) Empty
      lout = loutPSAtComp'  base atPS atLout 170
                           (MM 7) (MM 7)
                           None NoLength None NoLength
                           aCat_Compass () () ()
  in mkLoutPic "Compass_atComp" lout
\end{code}


%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:
