
\subsection{Refined Compass Algebra}\subsectlabel{Compass3}

The previous compass algebra may be refined. Here, just one step is added,
indicating how this may be done further. We consider vectors in the plain and
partition these vectors into 13 subsets. Subset $1$ contains just the zero
vector. Subsets $2, 3, 6, 7, 10, 11$ contain precisely the nonvanishing vectors of
the indicated direction, while subsets $4,5,8,9,12,13$ contain all the vectors
from the origin that end properly inside the respective region.

\medskip
\centerline{\scalebox{0.7}{\includegraphics{Compass3-numbers.eps}}}

\smallskip
\centerline{\small Vector orientation in the compass algebra}
\medskip
\noindent
It may be understood
as being generated from compass-like qualifications
represented in atoms as follows:
\ignore{
     \ \hbox to5cm{identity\hfil by {\tt I }}

     \ \hbox to5cm{east\hfil by {\tt E }}\qquad\qquad\hbox to5cm{west\hfil by {\tt W }}

     \ \hbox to5cm{eastnortheasterly\hfil by {\tt ENE }}\qquad\qquad\hbox to5cm{westsouthwesterly\hfil by {\tt WSW }} 

     \ \hbox to5cm{northeast\hfil by {\tt NE }}\qquad\qquad\hbox to5cm{southwest\hfil by {\tt SW }}

     \ \hbox to5cm{northnortheasterly\hfil by {\tt NNE }}\qquad\qquad\hbox to5cm{southsouthwesterly\hfil by {\tt SSW }}

     \ \hbox to5cm{north\hfil by {\tt N}}\qquad\qquad\hbox to5cm{south\hfil by {\tt S}}

     \ \hbox to5cm{northwesterly\hfil by {\tt NW}}\qquad\qquad\hbox to5cm{southeasterly\hfil by {\tt SE}}
}%ignore

\begin{code}
module Compass3(aCat_Compass3,aAll_Compass3,ra_Compass3,writeAtComp_Compass3)
                                                                            where
import RelAlg
import Atomset
import Draw
import FiniteMaps

data Atomset = I | N | E | S | W | NE | SE | SW | NW | ENE | SSW | WSW | NNE
                     deriving (Eq, Ord, Show)  
atoms = [I, N, E, S, W, NE, SE, SW, NW, ENE, SSW, WSW, NNE]
\end{code}

\begin{code}
aCat_Compass3 :: ACat () Atomset
aCat_Compass3 = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ _ _ _ -> True)
  ,acat_objects = [()]
  ,acat_atomset = (\ _ _ -> atoms)
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = (\ _ _ _ -> atComp)
  }

aAll_Compass3 :: AAll () Atomset
aAll_Compass3 = AAll
  {aall_acat = aCat_Compass3
  ,aall_converse = (\ _ _ -> conv)
  }

ra_Compass3 :: RA () (SetMor () Atomset)
ra_Compass3 = atomsetRA aAll_Compass3
\end{code}

\begin{code}
conv :: Atomset -> Atomset
conv I  = I
conv N  = S
conv E  = W
conv S  = N
conv W  = E
conv NE  = SW
conv SE  = NW
conv SW  = NE
conv NW  = SE
conv ENE  = WSW
conv SSW  = NNE
conv WSW  = ENE
conv NNE  = SSW
\end{code}

\ignore{
%{{{ atComp
\begin{code}
atComp :: Atomset -> Atomset -> [Atomset]

atComp I x   = [x]
atComp x   I = [x]
       
atComp E E = [E]
atComp E W = [I, E, W]
atComp E ENE = [ENE]
atComp E WSW = [WSW, SW, SSW, S, SE]
atComp E NE = [ENE]
atComp E SW = [SSW, S, SE]
atComp E NNE  = [ENE, NE, NNE]
atComp E SSW  = [SSW, S, SE]
atComp E N = [ENE, NE, NNE]
atComp E S = [SE]
atComp E NW = [ENE, NE, NNE, N, NW]
atComp E SE = [SE]
atComp W E = [I, E, W]
atComp W W = [W]
atComp W ENE = [ENE, NE, NNE, N, NW]
atComp W WSW = [WSW]
atComp W NE = [NNE, N, NW]
atComp W SW = [WSW]
atComp W NNE  = [NNE, N, NW]
atComp W SSW  = [WSW, SW, SSW]
atComp W N = [NW]
atComp W S = [WSW, SW, SSW]
atComp W NW = [NW]
atComp W SE = [WSW, SW, SSW, S, SE]
atComp ENE E = [ENE]
atComp ENE W = [ENE, NE, NNE, N, NW]
atComp ENE ENE = [ENE]
atComp ENE WSW = [I, E, W, ENE, WSW, NE, SW, NNE, SSW, N, S, NW, SE]
atComp ENE NE = [ENE]
atComp ENE SW = [E, ENE, SSW, S, SE]
atComp ENE NNE  = [ENE, NE, NNE]
atComp ENE SSW  = [E, ENE, SSW, S, SE]
atComp ENE N = [ENE, NE, NNE]
atComp ENE S = [E, ENE, SE]
atComp ENE NW = [ENE, NE, NNE, N, NW]
atComp ENE SE = [E, ENE, SE]
atComp WSW E = [WSW, SW, SSW, S, SE]
atComp WSW W = [WSW]
atComp WSW ENE = [I, E, W, ENE, WSW, NE, SW, NNE, SSW, N, S, NW, SE]
atComp WSW WSW = [WSW]
atComp WSW NE = [W, WSW, NNE, N, NW]
atComp WSW SW = [WSW]
atComp WSW NNE  = [W, WSW, NNE, N, NW]
atComp WSW SSW  = [WSW, SW, SSW]
atComp WSW N = [W, WSW, NW]
atComp WSW S = [WSW, SW, SSW]
atComp WSW NW = [W, WSW, NW]
atComp WSW SE = [WSW, SW, SSW, S, SE]
atComp NE E = [ENE]
atComp NE W = [NNE, N, NW]
atComp NE ENE = [ENE]
atComp NE WSW = [W, WSW, NNE, N, NW]
atComp NE NE = [NE]
atComp NE SW = [I, NE, SW]
atComp NE NNE  = [NNE]
atComp NE SSW  = [E, ENE, SSW, S, SE]
atComp NE N = [NNE]
atComp NE S = [E, ENE, SE]
atComp NE NW = [NNE, N, NW]
atComp NE SE = [E, ENE, SE]
atComp SW E = [SSW, S, SE]
atComp SW W = [WSW]
atComp SW ENE = [E, ENE, SSW, S, SE]
atComp SW WSW = [WSW]
atComp SW NE = [I, NE, SW]
atComp SW SW = [SW]
atComp SW NNE  = [W, WSW, NNE, N, NW]
atComp SW SSW  = [SSW]
atComp SW N = [W, WSW, NW]
atComp SW S = [SSW]
atComp SW NW = [W, WSW, NW]
atComp SW SE = [SSW, S, SE]
atComp NNE E = [ENE, NE, NNE]
atComp NNE W = [NNE, N, NW]
atComp NNE ENE = [ENE, NE, NNE]
atComp NNE WSW = [W, WSW, NNE, N, NW]
atComp NNE NE = [NNE]
atComp NNE SW = [W, WSW, NNE, N, NW]
atComp NNE NNE  = [NNE]
atComp NNE SSW  = [I, E, W, ENE, WSW, NE, SW, NNE, SSW, N, S, NW, SE]
atComp NNE N = [NNE]
atComp NNE S = [E, ENE, NE, NNE, SE]
atComp NNE NW = [NNE, N, NW]
atComp NNE SE = [E, ENE, NE, NNE, SE]
atComp SSW E = [SSW, S, SE]
atComp SSW W = [WSW, SW, SSW]
atComp SSW ENE = [E, ENE, SSW, S, SE]
atComp SSW WSW = [WSW, SW, SSW]
atComp SSW NE = [E, ENE, SSW, S, SE]
atComp SSW SW = [SSW]
atComp SSW NNE  = [I, E, W, ENE, WSW, NE, SW, NNE, SSW, N, S, NW, SE]
atComp SSW SSW  = [SSW]
atComp SSW N = [W, WSW, SW, SSW, NW]
atComp SSW S = [SSW]
atComp SSW NW = [W, WSW, SW, SSW, NW]
atComp SSW SE = [SSW, S, SE]
atComp N E  = [ENE, NE, NNE]
atComp N W  = [NW]
atComp N ENE  = [ENE, NE, NNE]
atComp N WSW  = [W, WSW, NW]
atComp N NE  = [NNE]
atComp N SW  = [W, WSW, NW]
atComp N NNE  = [NNE]
atComp N SSW  = [W, WSW, SW, SSW, NW]
atComp N N = [N]
atComp N S = [I, N, S]
atComp N NW = [NW]
atComp N SE = [E, ENE, NE, NNE, SE]
atComp S E  = [SE]
atComp S W  = [WSW, SW, SSW]
atComp S ENE  = [E, ENE, SE]
atComp S WSW  = [WSW, SW, SSW]
atComp S NE  = [E, ENE, SE]
atComp S SW  = [SSW]
atComp S NNE  = [E, ENE, NE, NNE, SE]
atComp S SSW  = [SSW]
atComp S N = [I, N, S]
atComp S S = [S]
atComp S NW = [W, WSW, SW, SSW, NW]
atComp S SE = [SE]
atComp NW E  = [ENE, NE, NNE, N, NW]
atComp NW W  = [NW]
atComp NW ENE  = [ENE, NE, NNE, N, NW]
atComp NW WSW  = [W, WSW, NW]
atComp NW NE  = [NNE, N, NW]
atComp NW SW  = [W, WSW, NW]
atComp NW NNE  = [NNE, N, NW]
atComp NW SSW  = [W, WSW, SW, SSW, NW]
atComp NW N = [NW]
atComp NW S = [W, WSW, SW, SSW, NW]
atComp NW NW = [NW]
atComp NW SE = [I, E, W, ENE, WSW, NE, SW, NNE, SSW, N, S, NW, SE]
atComp SE E   = [SE]
atComp SE W   = [WSW, SW, SSW, S, SE]
atComp SE ENE = [E, ENE, SE]
atComp SE WSW = [WSW, SW, SSW, S, SE]
atComp SE NE  = [E, ENE, SE]
atComp SE SW  = [SSW, S, SE]
atComp SE NNE = [E, ENE, NE, NNE, SE]
atComp SE SSW = [SSW, S, SE]
atComp SE N   = [E, ENE, NE, NNE, SE]
atComp SE S   = [SE]
atComp SE NW  = [I, E, W, ENE, WSW, NE, SW, NNE, SSW, N, S, NW, SE]
atComp SE SE  = [SE]
\end{code}
%}}}
}%ignore

As in the last example,
we only show a graphical presentation of the composition table:

\medskip
\centerline{\includegraphics{Compass3_atComp.eps}}

\ignore{
\medskip
\begin{code}
atDir E = 0
atDir W = 180
atDir ENE = 22.5
atDir WSW = 202.5
atDir NE = 45
atDir SW = 225
atDir NNE = 67.5
atDir SSW = 247.5
atDir N = 90
atDir S = 270
atDir NW = 135
atDir SE = 315
atDir I = error "atDir I"

arrow = "-5 0 moveto 9 0 lineto 7 -1 moveto 9 0 lineto 7 1 lineto "
writeAtComp_Compass3 =
  let base = graphicCenterFrameScale 10 10 ++ "0.3 setlinewidth\n"
      atPS I = "newpath -3 -3 moveto -3 3 lineto 3 3 lineto 3 -3 lineto closepath stroke\n"
      atPS d = "gsave " ++ show (atDir d) ++ " rotate newpath " ++ arrow
               ++ "stroke grestore\n"
      atLout = Limit (MM 9) (MM 9) Empty
      lout = loutPSAtComp' base atPS atLout 170
                          (MM 7) (MM 7)
                          None NoLength None NoLength
                          aCat_Compass3 () () ()
  in mkLoutPic "Compass3_atComp" lout
\end{code}
}%ignore


%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:

