\section{Prelude Extensions}\applabel{ExtPrel}

\begin{code}
module ExtPrel where
\end{code}

\index{prodF@{\texttt{prodF*}}}%
\index{cprodFF@{\texttt{cprodFF*}}}%
\begin{code}
prodF f g (x,y) = (f x, g y)

prodFF f g (x1,x2) (y1,y2)  = (f x1 y1, g x2 y2)

cprodFF h f g (x1,x2) (y1,y2)  = h (f x1 y1, g x2 y2)

prodFFF f g (x1,x2) (y1,y2) (z1,z2)  = (f x1 y1 z1, g x2 y2 z2)

cprodFFF h f g (x1,x2) (y1,y2) (z1,z2)  = h (f x1 y1 z1, g x2 y2 z2)

prodPP2 p (x1,y1) (x2,y2) = p y1 y2
\end{code}

\index{tupd_3_1@{\texttt{tupd\_3\_1}}}%
\begin{code}
tupd_3_1 f (x, y, z) = (f x, y, z)
\end{code}

\index{cTrue@{\texttt{cTrue}}}%
\index{ccTrue@{\texttt{ccTrue}}}%
\index{cFalse@{\texttt{cFalse}}}%
\index{ccFalse@{\texttt{ccFalse}}}%
\begin{code}
cTrue x = True
cFalse x = False
ccTrue x y = True
ccFalse x y = False
\end{code}

\index{listProd@{\texttt{listProd}}}%
\begin{code}
listProd (as,bs) = [(a,b) | a <- as, b <- bs]
\end{code}

\index{power@{\texttt{power}}}%
\begin{code}
power :: [a] -> [[a]]
power l = power' id l []
 where
  power' f [] = ((f []):)
  power' f (x:xs) = power' f xs . power' (f . (x:)) xs
\end{code}

\index{FctS@{\texttt{FctS}}}%
\index{FctsS@{\texttt{FctsS}}}%
\index{totFct@{\texttt{totFct}}}%
\begin{code}
type FctS a b = [(a,b)] -> [(a,b)]
type FctsS a b = FctS a b -> [[(a,b)]] -> [[(a,b)]]

totFct :: [a] -> [b] -> [[(a,b)]]
-- totFct (dom :: [a]) (ran :: [b]) =
totFct dom ran =
 foldr h (\ f -> ((f []) :)) dom id []
  where
    -- h :: a -> FctsS a b -> FctsS a b
    h x mkfs = foldr k (const id) ran
      where -- k :: b -> FctsS a b -> FctsS a b
            k y mkfs' f = mkfs (f . ((x,y):)) . mkfs' f
\end{code}


\index{pairAnd@{\texttt{pairAnd}}}%
\begin{code}
pairAnd = uncurry (&&)
\end{code}

\index{insertSet@{\texttt{insertSet}}}%
\index{listEqAsSet@{\texttt{listEqAsSet}}}%
\begin{code}
insertSet :: Ord a => a -> [a] -> [a]
insertSet x []         =  [x]
insertSet x ys@(y:ys') =  case compare x y of
                                GT -> y : insertSet x ys'
                                EQ -> ys
                                _  -> x : ys

listEqAsSet :: Ord a => [a] -> [a] -> Bool
listEqAsSet xs ys = foldr insertSet [] xs == foldr insertSet [] ys
\end{code}

\index{listShowsSep@{\texttt{listShowsSep}}}%
\index{listShows@{\texttt{listShows}}}%
\begin{code}
listShowsSep shows c = h
  where h [] = id
        h [x] = shows x
        h (x:xs) = shows x . (c :) . h xs

listShows shows xs = ('[' :) . listShowsSep shows ',' xs . (']' :)
\end{code}

\index{foldl'@{\texttt{foldl'}}}%
\index{length'@{\texttt{length'}}}%
\index{rcurry@{\texttt{rcurry}}}%
\begin{code}
foldl'           :: (a -> b -> a) -> a -> [b] -> a
foldl' f a []     = a
foldl' f a (x:xs) = (foldl' f $! f a x) xs

length' :: Integral i => [a] -> i
length' = foldl' (\ n _ -> n + 1) 0

rcurry :: ((a,b) -> c) -> b -> a -> c
rcurry f = flip (curry f)
\end{code}

\index{unfold@{\texttt{unfold}}}%
\begin{code}
unfold :: (a -> (b,a)) -> a -> [b]
unfold f x = let (r,y) = f x in r : unfold f y
\end{code}

\index{STFun@{\texttt{STFun}}}%
\index{applySTFun@{\texttt{applySTFun}}}%
\begin{code}
newtype STFun s a = STFun (s -> (s,a))
applySTFun (STFun f) = f

instance Functor (STFun s) where
  fmap f (STFun g) = STFun (\s -> let (s', a) = g s
                                  in  (s', f a))

instance Monad (STFun s) where
  return x = STFun (\s -> (s,x))
  (STFun f) >>= g  = STFun (\s -> let (s',a) = f s
                                      STFun g' = g a
                                  in g' s')
\end{code}

\index{untilFix@{\texttt{untilFix}}}%
\begin{code}
untilFix f x = let x' = f x in if x' == x then x else untilFix f x'
\end{code}

\ignore{
%{{{ instance Eq, Ord (a,b,c,d,e,f)
\begin{pseudocode}
instance (Eq a, Eq b, Eq c, Eq d, Eq e, Eq f) => Eq (a,b,c,d,e,f) where
  (a,b,c,d,e,f) == (u,v,w,x,y,z)  =
    a == u && b == v && c == w  && d == x && e == y && f == z

instance (Ord a, Ord b, Ord c, Ord d, Ord e, Ord f) => Ord (a,b,c,d,e,f) where
  (a,b,c,d,e,f) `compare` (u,v,w,x,y,z)  =
    case a `compare` u of
    LT -> LT
    GT -> GT
    EQ ->
     case b `compare` v of
     LT -> LT
     GT -> GT
     EQ ->
      case c `compare` w of
      LT -> LT
      GT -> GT
      EQ ->
       case d `compare` x of
       LT -> LT
       GT -> GT
       EQ ->
        case e `compare` y of
        LT -> LT
        GT -> GT
        EQ -> f `compare` z
\end{pseudocode}
%}}}
}%ignore


%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end: 

