\section{An Interval Algebra}\sectlabel{Interval}
\ignore{Stand 12.07.2000}

\noindent
The following algebra
\cite{Allen-1981, Allen-Koomen-1983, vanBenthem-1983, Malik-Binford-1983, Allen-1983}
is well-known to specialists.
A description may be found in the AMAST 1993 invited talk of Roger Maddux
\cite{Maddux-1993}.

\begin{code}
module Interval(aCat_Interval,aAll_Interval,ra_Interval) where

import RelAlg
import Atomset
import FiniteMaps
\end{code}


For the interpretation of the algebra ${\cal IA}$ 
consider nonempty intervals on the real axis.
They may be described by a pair of two different real numbers
which we assume to be in ascending order.
The first gives the starting time of the interval and 
the second the ending time. For simplicity, we assume only intervals
$(x,y]$,
i.e., left-open and right-closed.

On any given set of such intervals, we now consider the following
relations together with their converses, if this is a different relation.
Let the first interval be given by the pair
$(x, x']$ and the second by $(y, y']$.



\hbox{\hbox to1cm{\hfil $1'$\hfil}  $\equiv$
      \hbox to4cm{\hfil$x=y$ and $x'=y'$\hfil}  $\equiv$ ``identity of intervals''\hfil}


\hbox{\hbox to1cm{\hfil $p$\hfil}
      $\equiv$
      \hbox to4cm{\hfil$x'<y$\hfil}  
      \hbox{$\equiv$ 
      ``first interval stricly precedes the second'' \hfil}}

\hbox{\hbox to1cm{\hfil $d$\hfil}
      $\equiv$
      \hbox to4cm{\hfil$y<x<x'<y'$\hfil}
      $\equiv$
      ``first interval is bi-strictly contained in the second''\hfil}

\hbox{\hbox to1cm{\hfil $o$\hfil}
      $\equiv$
      \hbox to4cm{\hfil$x<y<x'<y'$\hfil}
      $\equiv$
      ``first interval is partly overlapped by the second''\hfil}

\hbox{\hbox to1cm{\hfil $m$\hfil}
      $\equiv$
      \hbox to4cm{\hfil$x<x'=y<y'$\hfil}
      $\equiv$
      ``first interval touches the second from the left''\hfil}

\hbox{\hbox to1cm{\hfil $s$\hfil}
      $\equiv$
      \hbox to4cm{\hfil$x=y<x'<y'$\hfil}
      $\equiv$
      ``first interval is strict initial part of the second''\hfil}

\hbox{\hbox to1cm{\hfil $f$\hfil}
      $\equiv$
      \hbox to4cm{\hfil$y<x<x'=y'$\hfil}
      $\equiv$
      ``first interval is strict terminal part of the second''\hfil}


\noindent
The interrelationship is then investigated
by constructing a homogeneous relation algebra
from a set of thirteen atoms induced by the above relations,
using the following names:
\BD
{\def\by{\quad\mbox{for}\quad}%
\def\sep{\hskip3em}%
\def\skip{\multicolumn{2}{c}{}}%
\begin{array}{l@{\by}l@{\sep}l@{\by}l@{\sep}l@{\by}l@{\sep}l@{\by}l@{\sep}l@{\by}l}
{\tt I} & 1'
&
{\tt P } & p
&
{\tt Pc} & \rtrans{p}
&
{\tt M } & m
&
{\tt Mc} & \rtrans{m}
\\
\skip &
{\tt  D} & d
&
{\tt Dc} & \rtrans{d}
&
{\tt S } & s
&
{\tt Sc} & \rtrans{s}
\\
\skip &
{\tt O} & o
&
{\tt Oc} & \rtrans{o}
&
{\tt F} & f
&
{\tt Fc} & \rtrans{f}
\end{array}}
\ED
%{{{ \ignore{old table}
\ignore{
     \ \hbox to2.2cm{1'\hfil by {\tt I }}

     \ \hbox to2.2cm{$p$\hfil by {\tt P }}\qquad\hbox to2.2cm{$p\sp\cup$\hfil by {\tt Pc }}
     \qquad\hbox to2.2cm{$m$\hfil by {\tt M}}\qquad\hbox to2.2cm{$m\sp\cup$\hfil by {\tt Mc}}

     \ \hbox to2.2cm{$d$\hfil by {\tt D }}\qquad\hbox to2.2cm{$d\sp\cup$\hfil by {\tt Dc }} 
     \qquad\hbox to2.2cm{$s$\hfil by {\tt S}}\qquad\hbox to2.2cm{$s\sp\cup$\hfil by {\tt Sc}}

     \ \hbox to2.2cm{$o$\hfil by {\tt O }}\qquad\hbox to2.2cm{$o\sp\cup$\hfil by {\tt Oc }}
     \qquad\hbox to2.2cm{$f$\hfil by {\tt F}}\qquad\hbox to2.2cm{$f\sp\cup$\hfil by {\tt Fc}}
}%ignore
%}}}
%
\begin{code}
data Atomset = I | P | Pc | D | Dc | O | Oc | M | Mc | S | Sc | F | Fc
                     deriving (Eq, Ord, Show) 
atoms = [I, P, Pc, D, Dc, O, Oc, M, Mc, S, Sc, F, Fc]
\end{code}

\begin{code}
aCat_Interval :: ACat () Atomset
aCat_Interval = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ _ _ _ -> True)
  ,acat_objects = [()]
  ,acat_atomset = (\ _ _ -> atoms)
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = (\ _ _ _ -> atComp)
  }

aAll_Interval :: AAll () Atomset
aAll_Interval = AAll
  {aall_acat = aCat_Interval
  ,aall_converse = (\ _ _ -> conv)
  }

ra_Interval :: RA () (SetMor () Atomset)
ra_Interval = atomsetRA aAll_Interval
\end{code}


\begin{code}
conv :: Atomset -> Atomset
conv I  = I
conv P  = Pc
conv Pc = P 
conv D  = Dc 
conv Dc = D 
conv O  = Oc 
conv Oc = O
conv M  = Mc 
conv Mc = M 
conv S  = Sc
conv Sc = S 
conv F  = Fc 
conv Fc = F
\end{code}

\begin{code}
atComp :: Atomset -> Atomset -> [Atomset]

atComp I x  = [x]
atComp x I  = [x]
       
atComp P P  = [P]
atComp P Pc = [I, P, Pc, D, Dc, O, Oc, M, Mc, S, Sc, F, Fc]
atComp P D  = [P, D, O, M, S]
atComp P Dc = [P]
atComp P O  = [P]
atComp P Oc = [P, D, O, M, S]
atComp P M  = [P]
atComp P Mc = [P, D, O, M, S]
atComp P S  = [P]
atComp P Sc = [P]
atComp P F  = [P, D, O, M, S]
atComp P Fc = [P]
       
atComp Pc P = [I, P, Pc, D, Dc, O, Oc, M, Mc, S, Sc, F, Fc]
atComp Pc Pc = [Pc]
atComp Pc D  = [Pc, D, Oc, Mc, F]
atComp Pc Dc = [Pc]
atComp Pc O  = [Pc, D, Oc, Mc, F]
atComp Pc Oc = [Pc]
atComp Pc M  = [Pc, D, Oc, Mc, F]
atComp Pc Mc = [Pc]
atComp Pc S  = [Pc, D, Oc, Mc, F]
atComp Pc Sc = [Pc]
atComp Pc F  = [Pc]
atComp Pc Fc = [Pc]
       
atComp D  P  = [P]
atComp D  Pc = [Pc]
atComp D  D  = [D]
atComp D  Dc = [I, P, Pc, D, Dc, O, Oc, M, Mc, S, Sc, F, Fc]
atComp D  O  = [P, D, O, M, S]
atComp D  Oc = [Pc, D, Oc, Mc, F]
atComp D  M  = [P]
atComp D  Mc = [Pc]
atComp D  S  = [D]
atComp D  Sc = [Pc, D, Oc, Mc, F]
atComp D  F  = [D]
atComp D  Fc = [P, D, O, M, S]
       
atComp Dc P  = [P, Dc, O, M, Fc]
atComp Dc Pc = [Pc, Dc, Oc, Mc, Sc]
atComp Dc D  = [I, D, Dc, O, Oc, S, Sc, F, Fc]
atComp Dc Dc = [Dc]
atComp Dc O  = [Dc, O, Fc]
atComp Dc Oc = [Dc, Oc, Sc]
atComp Dc M  = [Dc, O, Fc]
atComp Dc Mc = [Dc, Oc, Sc]
atComp Dc S  = [Dc, O, Fc]
atComp Dc Sc = [Dc]
atComp Dc F  = [Dc, Oc, Sc]
atComp Dc Fc = [Dc]
       
atComp O  P  = [P]
atComp O  Pc = [Pc, Dc, Oc, Mc, Sc]
atComp O  D  = [D, O, S]
atComp O  Dc = [P, Dc, O, M, Fc]
atComp O  O  = [P, O, M]
atComp O  Oc = [I, D, Dc, O, Oc, S, Sc, F, Fc]
atComp O  M  = [P]
atComp O  Mc = [Dc, Oc, Sc]
atComp O  S  = [O]
atComp O  Sc = [Dc, O, Fc]
atComp O  F  = [D, O, S]
atComp O  Fc = [P, O, M]
       
atComp Oc P  = [P, Dc, O, M, Fc]
atComp Oc Pc = [Pc]
atComp Oc D  = [D, Oc, F]
atComp Oc Dc = [Pc, Dc, Oc, Mc, Sc]
atComp Oc O  = [I, D, Dc, O, Oc, S, Sc, F, Fc]
atComp Oc Oc = [Pc, Oc, Mc]
atComp Oc M  = [Dc, O, Fc]
atComp Oc Mc = [Pc]
atComp Oc S  = [D, Oc, F]
atComp Oc Sc = [Pc, Oc, Mc]
atComp Oc F  = [Oc]
atComp Oc Fc = [Dc, Oc, Sc]
       
atComp M  P  = [P]
atComp M  Pc = [Pc, Dc, Oc, Mc, Sc]
atComp M  D  = [D, O, S]
atComp M  Dc = [P]
atComp M  O  = [P]
atComp M  Oc = [D, O, S]
atComp M  M  = [P]
atComp M  Mc = [I, F, Fc]
atComp M  S  = [M]
atComp M  Sc = [M]
atComp M  F  = [D, O, S]
atComp M  Fc = [P]
       
atComp Mc P  = [P, Dc, O, M, Fc]
atComp Mc Pc = [Pc]
atComp Mc D  = [D, Oc, F]
atComp Mc Dc = [Pc]
atComp Mc O  = [D, Oc, F]
atComp Mc Oc = [Pc]
atComp Mc M  = [I, S, Sc]
atComp Mc Mc = [Pc]
atComp Mc S  = [D, Oc, F]
atComp Mc Sc = [Pc]
atComp Mc F  = [Mc]
atComp Mc Fc = [Mc]
       
atComp S  P  = [P]
atComp S  Pc = [Pc]
atComp S  D  = [D]
atComp S  Dc = [P, Dc, O, M, Fc]
atComp S  O  = [P, O, M]
atComp S  Oc = [D, Oc, F]
atComp S  M  = [P]
atComp S  Mc = [Mc]
atComp S  S  = [S]
atComp S  Sc = [I, S, Sc]
atComp S  F  = [D]
atComp S  Fc = [P, O, M]
       
atComp Sc P  = [P, Dc, O, M, Fc]
atComp Sc Pc = [Pc]
atComp Sc D  = [D, Oc, F]
atComp Sc Dc = [Dc]
atComp Sc O  = [Dc, O, Fc]
atComp Sc Oc = [Oc]
atComp Sc M  = [Dc, O, Fc]
atComp Sc Mc = [Mc]
atComp Sc S  = [I, S, Sc]
atComp Sc Sc = [Sc]
atComp Sc F  = [Oc]
atComp Sc Fc = [Dc]
       
atComp F  P  = [P]
atComp F  Pc = [Pc]
atComp F  D  = [D]
atComp F  Dc = [Pc, Dc, Oc, Mc, Sc]
atComp F  O  = [D, O, S]
atComp F  Oc = [Pc, Oc, Mc]
atComp F  M  = [M]
atComp F  Mc = [Pc]
atComp F  S  = [D]
atComp F  Sc = [Pc, Oc, Mc]
atComp F  F  = [F]
atComp F  Fc = [I, F, Fc]
       
atComp Fc P  = [P]
atComp Fc Pc = [Pc, Dc, Oc, Mc, Sc]
atComp Fc D  = [D, O, S]
atComp Fc Dc = [Dc]
atComp Fc O  = [O]
atComp Fc Oc = [Dc, Oc, Sc]
atComp Fc M  = [M]
atComp Fc Mc = [Dc, Oc, Sc]
atComp Fc S  = [O]
atComp Fc Sc = [Dc]
atComp Fc F  = [I, F, Fc]
atComp Fc Fc = [Fc]
\end{code}

%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:


