\section{LRNnoc}

\noindent
The relation algebra considered here is intended to show how
truly parallel nonstrict behaviour 
may be modelled by relation algebras, too.
We already have accepted to consider the one-element set $\mathbb{B}\sp0$ 
as a boolean algebra.
Having done this, we will find out that here the 
one-element morphism set {\tt Mor(L, R)} with an element 
that should be called {\it noc} (for: not connected) is an adequate 
modelling of the corresponding property in net situations.
\begin{code}
module LRNnoc(aCat_LRNnoc,aAll_LRNnoc,ra_LRNnoc) where

import RelAlg
import Atomset
import A2
import Matrix

import FiniteMaps
import Sets

data Obj = L | R | N  deriving (Eq, Ord, Show) 
objseq = [L, R, N] 
\end{code}

\noindent
There is one atom to indicate relationship on {\tt L} or on {\tt R}. 
In the same way, there are two atoms for relationships on {\tt N},
which is intended to model the parallel product of {\tt L} and {\tt R}.
There are, however, no atoms provided
for relations between {\tt L} and {\tt R}.
\begin{code}

atoms :: Obj -> Obj -> [A2]
atoms N N = [At1, At2]
atoms R L = []
atoms L R = []
atoms _ _ = [At1]

\end{code}


\begin{code}
aCat_LRNnoc :: ACat Obj A2
aCat_LRNnoc = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ s t a -> a `elem` atoms s t)
  ,acat_objects = objseq
  ,acat_atomset = atoms
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = atComp
  }

aAll_LRNnoc :: AAll Obj A2
aAll_LRNnoc = AAll
  {aall_acat = aCat_LRNnoc
  ,aall_converse = const $ const id
  }

ra_LRNnoc :: RA Obj (SetMor Obj A2)
ra_LRNnoc = atomsetRA aAll_LRNnoc
\end{code}

\begin{code}
atComp :: Obj -> Obj -> Obj -> A2 -> A2 -> [A2]

atComp L _ R  _   _  = []
atComp R _ L  _   _  = []

atComp N R N At1 At1 = [At2]
atComp N N N At2 At2 = [At2]

atComp N N R At2 At1 = [At1]
atComp R N N At1 At2 = [At1]

atComp N N N At2 At1 = []
atComp N N N At1 At2 = []
atComp N N L At2 At1 = []
atComp N N R At1 At1 = []
atComp L N N At1 At2 = []
atComp R N N At1 At1 = []

atComp _ _ _ At1 At1 = [At1]
\end{code}

\noindent
One will observe that there is no
possibility to propagate anything from {\tt L} to {\tt R},
not even via {\tt N}.
So this models work on two components of a pair,
that is executed completely independently.
Work on the first component done by {\tt L} cannot influence
the second component of the pair.

From the evaluation of the expression

\begin{session}
printAllTestResults $ all_mapTest $ ra_all ra_LRNnoc
\end{session}

we see that the only two non-identical mappings
in this relation algebra are

\begin{center}
\verb|SetMor ({At1},L,N)|
\ \ and \ \  \verb|SetMor ({At1},R,N)|.
\end{center}

\ignore{
\medskip
As in \verb|NUW| (\sectref{NonUniform}),
all objects are products of themselves,
with universal relations as projections:

\begin{session}
Main> ded_NonemptyProducts (ra_ded ra_LRNnoc)
[(L,L,L,SetMor ({At1},L,L),SetMor ({At1},L,L))
,(R,R,R,SetMor ({At1},R,R),SetMor ({At1},R,R))
,(N,N,N,SetMor ({At1, At2},N,N),SetMor ({At1, At2},N,N))
]
\end{session}

All these products are sharp:

\begin{session}
Main> let d = ra_ded ra_LRNnoc
      in mapM_ (\ p -> perform (unsharp p) d) (ded_NonemptyProducts d)
No results.
No results.
No results.
\end{session}
}%ignore


%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:

