\section{Maddux}\sectlabel{Maddux}

\ignore{Stand 13.10.97 von Michael Winter}
\noindent
This algebra originates from a discussion of the second named author with
Roger Maddux on the occasion of the 1991 Stefan Banach Semester 
on Algebraic Logic in Warsaw. They discussed the possibility of 
existence of a relation algebra for which the sharpness equation fails to hold.
On a workshop in Rio de Janeiro in 1995,
Roger Maddux explained the idea for the following heterogeneous relation 
algebra with
5 objects {\tt A, B, C, D, E} \cite{Maddux-1995}.

\smallskip
\ignore{
\centerline{\scalebox{0.1}{\includegraphics{Maddux.eps}}}
\medskip
\centerline{\small The underlying graph of the category}

\medskip
The morphism sets are defined to have 
16, 2 or --- in all the cases not explicitly given --- 4
morphisms.
}%ignore
\centerline{\scalebox{0.5}{\includegraphics{Maddux-mors.eps}}}
\medskip
\centerline{\small The underlying graph of the category}

\medskip
The morphism sets are defined to have 
16 (for the bold lines), 2 (for the dotted line) or
--- in all other cases --- 4 morphisms.

For this heterogeneous relation algebra,
one will find out that the top object is --- as indicated ---
the direct product of those of the second level.
The morphisms between these, however, are very restricted in number.
As one may see using the Haskell programs,
the relation algebra given in detail below
shows that only
$$(\pi\rcmp P\rcmp\piT \reland \rho\rcmp R\rcmp\rhoT)\rcmp
  (\pi\rcmp Q\rcmp\piT \reland \rho\rcmp S\rcmp\rhoT)\;
\vcenter{\hbox to1cm{\hfil$\rsubs$\hfil}\hbox to1cm{\hfil$\neq$\hfil}}\;
\pi \rcmp P\rcmp Q\rcmp\piT \reland \rho\rcmp R\rcmp S\rhoT$$

A computer-aided proof that this is indeed such an algebra, 
and that it is unsharp was finally given by Michael Winter.
He developed an explicit atom composition table
that is included in the distribution as module \verb|MadduxOrig|.
The proof is also possible by the present program.

\begin{code}
module Maddux(aCat_Maddux,aAll_Maddux,ra_Maddux) where

import RelAlg
import Atomset
import A4

import FiniteMaps
import Properties
\end{code}

\begin{code}
data MadduxObj = A | B | C | D | E  deriving (Eq, Ord, Show, Read) 
objseq = [A, B, C, D, E]
\end{code}

\begin{code}
aCat_Maddux :: ACat MadduxObj A4
aCat_Maddux = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ s t m -> m `elem` atoms s t)
  ,acat_objects = objseq
  ,acat_atomset = atoms
  ,acat_idmor   = (\ s -> [At1]) -- acat_idmor_defaultM ac
  ,acat_comp    = atComp
  }

aAll_Maddux :: AAll MadduxObj A4
aAll_Maddux = AAll
  {aall_acat = aCat_Maddux
  ,aall_converse = conv
  }

conv _ _ a = a

ra_Maddux :: RA MadduxObj (SetMor MadduxObj A4)
ra_Maddux = atomsetRA aAll_Maddux
\end{code}

\begin{code}
atoms :: MadduxObj -> MadduxObj -> [A4]
atoms A B = [At1, At2]
atoms A C = [At1, At2]
atoms A _ = allatoms
atoms B A = [At1, At2]
atoms C A = [At1, At2]
atoms _ A = allatoms
atoms B C = [At1]
atoms C B = [At1]
atoms _ _ = [At1, At2]

allatoms = [At1, At2, At3, At4]
\end{code}

In \cite{Maddux-1995}, composition is defined via forbidden cycles,
and we directly carry over that definition
into our notation,
using \verb|negTableAtComp| from \subsectref{Cycles}:

\begin{code}
atComp = negTableAtComp atoms (allCycles conv forbidden)

forbidden =
     objs (A,A,A) [(At2,At2,At3), (At2,At2,At4), (At2,At3,At3), (At3,At3,At4)]
  ++ objs (A,A,B) [(At2,At1,At2), (At3,At1,At1), (At4,At1,At1)]
  ++ objs (A,B,B) [(At1,At2,At1)]
  ++ objs (A,A,C) [(At2,At1,At1), (At3,At1,At2), (At4,At1,At1)]
  ++ objs (A,C,C) [(At1,At2,At1)]
  ++ objs (A,A,D) atsAAD
  ++ objs (A,B,D) ats017
  ++ objs (A,C,D) ats027
  ++ objs (A,A,E) atsAAD
  ++ objs (A,B,E) ats017
  ++ objs (A,C,E) ats027
  ++ objs (A,D,E) [(At1,At1,At1)]
  ++ [((s,s,t),(At1,a,b)) | s <- objseq , t <- objseq,
                            a <- atoms s t, b <- atoms s t, a /= b]
 where
  objs os = map (\ ats -> (os,ats))
  comb at as1 as2 = [(at,a,b) | a <- as1, b <- as2]
  atsAAD = comb At2 [At1,At2] [At3,At4] ++
           comb At3 [At1,At3] [At2,At4]
  ats017 = [(At1,At1,At3), (At1,At1,At4), (At1,At2,At1), (At1,At2,At2)]
  ats027 = [(At1,At1,At2), (At1,At1,At4), (At1,At2,At1), (At1,At2,At3)]
\end{code}

The list of products has exactly one element:

\begin{session}
Main> ded_NonemptyProducts (ra_ded ra_Maddux)
[(B,C,A,SetMor ({At1},A,B),SetMor ({At1},A,C))]
\end{session}

From the evaluation of the expression

\begin{session}
printAllTestResults $ distrAll_funTest $ ra_distrAll ra_Maddux
\end{session}

we see that the projections are the only two non-trivial functions
in this relation algebra.

There are two constellations (related via conversion symmetry)
that show that this product is unsharp:

%{{{ unsharp
\begin{session}
Main> let d = ra_ded ra_Maddux in 
        performAll (ded_unsharp (head (ded_NonemptyProducts d))) d
=== Test Start ===
unsharpness example
 Objects:
  D
  E
 Morphisms:
  SetMor ({At1},D,B)
  SetMor ({At1},D,C)
  SetMor ({At1},B,E)
  SetMor ({At1},C,E)
  SetMor ({At2},D,E)
  SetMor ({At1, At2},D,E)
unsharpness example
 Objects:
  E
  D
 Morphisms:
  SetMor ({At1},E,B)
  SetMor ({At1},E,C)
  SetMor ({At1},B,D)
  SetMor ({At1},C,D)
  SetMor ({At2},E,D)
  SetMor ({At1, At2},E,D)
=== Test End   ===
\end{session}
%}}}


\ignore{
%{{{ aallMat aAll_Maddux matObjs_Maddux
With the following code snippet (which is not part of this module)
we construct a matrix relation algebra with all single objects and
object pairs as objects,
and then look for all products therein:

\begin{session}
matObjs_Maddux = do a <- objseq
                    [a] : do b <- objseq
                             [[a,b]]

matDed_Maddux = atomsetDed $ aallMat aAll_Maddux matObjs_Maddux

main = putStr $ unlines $ map show $ ded_NonemptyProducts matDed_Maddux
\end{session}

The first result is printed immediately;
after two hours and 31 minutes the search finishes with the following
(manually beautified) results:

%{{{ products
\begin{session}
([B],[C]  ,[A]  , SetMor ({(0,0,At1)           },[A]  ,[B]  )
                , SetMor ({(0,0,At1)           },[A]  ,[C]  ) )
([B],[C,C],[A,A], SetMor ({(0,0,At1), (1,0,At1)},[A,A],[B]  )
                , SetMor ({(0,1,At1), (1,0,At1)},[A,A],[C,C]) )
([B],[C,C],[A,A], SetMor ({(0,0,At1), (1,0,At1)},[A,A],[B]  )
                , SetMor ({(0,0,At1), (1,1,At1)},[A,A],[C,C]) )
([B,B],[C],[A,A], SetMor ({(0,1,At1), (1,0,At1)},[A,A],[B,B])
                , SetMor ({(0,0,At1), (1,0,At1)},[A,A],[C]  ) )
([B,B],[C],[A,A], SetMor ({(0,0,At1), (1,1,At1)},[A,A],[B,B])
                , SetMor ({(0,0,At1), (1,0,At1)},[A,A],[C]  ) )
\end{session}
%}}}

Here, the second product is equal to the third up to permutation,
and the forth corresponds to the fifth.

With the following additional definitions we test for
unsharpness configurations in the two interesting products:

\begin{session}
products_Maddux2 :: [Product [MadduxObj] (SetMor [MadduxObj] (Int,Int,A4))]
products_Maddux2 = map read
  ["([B],[C,C],[A,A],SetMor ({(0,0,At1), (1,0,At1)},[A,A],[B])" ++
                   ",SetMor ({(0,0,At1), (1,1,At1)},[A,A],[C,C]))"
  ,"([B,B],[C],[A,A],SetMor ({(0,0,At1), (1,1,At1)},[A,A],[B,B])" ++
                   ",SetMor ({(0,0,At1), (1,0,At1)},[A,A],[C]))"
  ]

main = let d = matDed_Maddux
       in mapM_ (\ p -> performAll (unsharp p) d) products_Maddux2
\end{session}

After over ninety hours,
%the exploration finishes after coming up with
\verb|perform| comes up with
three configurations for each product:
%(\verb|performAll| still running \unfinished)

%{{{ maddux2unsharp
\begin{session}
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,1,At1)},[A,D],[C,C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(1,1,At1)},[C,C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,1,At1)},[A,D],[C,C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(1,0,At2), (1,1,At1)},[C,C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,1,At1)},[A,D],[C,C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(1,0,At1), (1,1,At1)},[C,C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,1,At1)},[A,D],[B,B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(1,1,At1)},[B,B],[A,E])
  SetMor ({(0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,1,At1)},[A,D],[B,B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(1,1,At1)},[B,B],[A,E])
  SetMor ({(0,0,At2), (0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,1,At1)},[A,D],[B,B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(1,1,At1)},[B,B],[A,E])
  SetMor ({(0,0,At1), (0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
\end{session}
%}}}

For the embedded product

\begin{session}
([B],[C],[A],SetMor ({(0,0,At1)},[A],[B]),SetMor ({(0,0,At1)},[A],[C]))
\end{session}

the first three results are found in six minutes:

%{{{ maddux2unsharp1
\begin{session}
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(0,0,At2), (0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(0,0,At1), (0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
\end{session}
%}}}

All 32764 results take about an hour.
%}}}
}%ignore


%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:
