\section{Maddux}\sectlabel{Maddux}

\ignore{Stand 13.10.97 von Michael Winter}
\noindent
This algebra originates from a discussion of the second named author with
Roger Maddux on the occasion of the 1991 Stefan Banach Semester 
on Algebraic Logic in Warsaw. They discussed the possibility of 
existence of a relation algebra for which the sharpness equation fails to hold.
On a workshop in Rio de Janeiro in 1995,
Roger Maddux explained the idea for the following heterogeneous relation 
algebra with
5 objects {\tt A, B, C, D, E} \cite{Maddux-1995}.

\smallskip
\ignore{
\centerline{\scalebox{0.1}{\includegraphics{Maddux.eps}}}
\medskip
\centerline{\small The underlying graph of the category}

\medskip
The morphism sets are defined to have 
16, 2 or --- in all the cases not explicitly given --- 4
morphisms.
}%ignore
\centerline{\scalebox{0.5}{\includegraphics{Maddux-mors.eps}}}
\medskip
\centerline{\small The underlying graph of the category}

\medskip
The morphism sets are defined to have 
16 (for the bold lines), 2 (for the dotted line) or
--- in all other cases --- 4 morphisms.

For this heterogeneous relation algebra,
one will find out that the top object is --- as indicated ---
the direct product of those of the second level.
The morphisms between these, however, are very restricted in number.
As one may see using the Haskell programs,
the relation algebra given in detail below
shows that only
$$(\pi\rcmp P\rcmp\piT \reland \rho\rcmp R\rcmp\rhoT)\rcmp
  (\pi\rcmp Q\rcmp\piT \reland \rho\rcmp S\rcmp\rhoT)\;
\vcenter{\hbox to1cm{\hfil$\rsubs$\hfil}\hbox to1cm{\hfil$\neq$\hfil}}\;
\pi \rcmp P\rcmp Q\rcmp\piT \reland \rho\rcmp R\rcmp S\rhoT$$

A computer-aided proof that this is indeed such an algebra, 
and that it is unsharp was finally given by Michael Winter.
He developed the tables. The proof is also possible by the present
program.

\begin{code}
module Main where
--module MadduxOrig(aCat_Maddux,aAll_Maddux,ra_Maddux) where

import RelAlg
import Atomset
import A4

import FiniteMaps
import Properties

import ExtPrel
import qualified Maddux

objpairs = zip objseq (acat_objects Maddux.aCat_Maddux)

testMO = ffold $ do
  (x1,x2) <- objpairs
  (y1,y2) <- objpairs
  f <- acat_atomset aCat_Maddux x1 y1
  (z1,z2) <- objpairs
  g <- acat_atomset aCat_Maddux y1 z1
  let as1 = atComp x1 y1 z1 f g
  let as2 = acat_comp Maddux.aCat_Maddux x2 y2 z2 f g
  [test (as1 `listEqAsSet` as2) [x1,y1,z1] (f:g:as1++as2) "different composition"]

testMA = ffold $ do
  (x1,x2) <- objpairs
  (y1,y2) <- objpairs
  let as1 = acat_atomset aCat_Maddux x1 y1
  let as2 = acat_atomset Maddux.aCat_Maddux x2 y2
  [test (as1 `listEqAsSet` as2) [x1,y1] (as1++as2) "different atomsets"]

main = writeFile "madduxdiffs" $ ffold (map showsInstance (testMO [])) ""
\end{code}

\begin{code}
data MadduxObj = A | B | C | D | E  deriving (Eq, Ord, Show, Read) 
objseq = [A, B, C, D, E]
\end{code}

\begin{code}
aCat_Maddux :: ACat MadduxObj A4
aCat_Maddux = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ s t m -> m `elem` atoms s t)
  ,acat_objects = objseq
  ,acat_atomset = atoms
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = atComp
  }

aAll_Maddux :: AAll MadduxObj A4
aAll_Maddux = AAll
  {aall_acat = aCat_Maddux
  ,aall_converse = const $ const id
  }

ra_Maddux :: RA MadduxObj (SetMor MadduxObj A4)
ra_Maddux = atomsetRA aAll_Maddux
\end{code}

\begin{code}

atoms :: MadduxObj -> MadduxObj -> [A4]
atoms A B = [At1, At2]
atoms A C = [At1, At2]
atoms A _ = [At1, At2, At3, At4]
atoms B A = [At1, At2]
atoms C A = [At1, At2]
atoms _ A = [At1, At2, At3, At4]
atoms B C = [At1]
atoms C B = [At1]
atoms _ _ = [At1, At2]

\end{code}

\noindent
Composition is defined using atoms.
Certain patterns occurring in the composition tables are reused
several times and therefore presented separately;
the convention behind their names is illustrated
by taking {\tt pattern441} as an example:
this function codes composition table number 1 with 4 by 4 atoms%
\footnote{The overly detailed decomposition of these tables
is due to a computer of rather limited size at the time of
developing these tables.}

%{{{ pattern4*
\begin{code}
pattern441 :: A4 -> A4 -> [A4]
pattern441 At1 x   = [x]
pattern441 At2 At1 = [At2]
pattern441 At2 At2 = [At1, At2]
pattern441 At2 At3 = [At4]
pattern441 At2 At4 = [At3, At4]
pattern441 At3 At1 = [At3]
pattern441 At3 At2 = [At4]
pattern441 At3 At3 = [At1, At3]
pattern441 At3 At4 = [At2, At4]
pattern441 At4 At1 = [At4]
pattern441 At4 At2 = [At3, At4]
pattern441 At4 At3 = [At2, At4]
pattern441 At4 At4 = [At1, At2, At3, At4]

pattern442 :: A4 -> A4 -> [A4]
pattern442 At1 At1 = [At1]
pattern442 At1 At2 = [At2]
pattern442 At1 At3 = [At3]
pattern442 At1 At4 = [At4]
pattern442 At2 At1 = [At1, At2]
pattern442 At2 At2 = [At1, At2]
pattern442 At2 At3 = [At3, At4]
pattern442 At2 At4 = [At3, At4]
pattern442 At3 At1 = [At1, At3]
pattern442 At3 At2 = [At2, At4]
pattern442 At3 At3 = [At1, At3]
pattern442 At3 At4 = [At2, At4]
pattern442 At4 At1 = [At1, At2, At3, At4]
pattern442 At4 At2 = [At1, At2, At3, At4]
pattern442 At4 At3 = [At1, At2, At3, At4]
pattern442 At4 At4 = [At1, At2, At3, At4]

pattern443 :: A4 -> A4 -> [A4]
pattern443 At1 At1 = [At1, At2, At3, At4]
pattern443 At1 At2 = [At2, At4]
pattern443 At1 At3 = [At3, At4]
pattern443 At1 At4 = [At4]
pattern443 At2 At1 = [At2, At4]
pattern443 At2 At2 = [At1, At2, At3, At4]
pattern443 At2 At3 = [At4]
pattern443 At2 At4 = [At3, At4]
pattern443 At3 At1 = [At3, At4]
pattern443 At3 At2 = [At4]
pattern443 At3 At3 = [At1, At2, At3, At4]
pattern443 At3 At4 = [At2, At4]
pattern443 At4 At1 = [At4]
pattern443 At4 At2 = [At3, At4]
pattern443 At4 At3 = [At2, At4]
pattern443 At4 At4 = [At1, At2, At3, At4]

pattern444 :: A4 -> A4 -> [A4] -- {1,2,3,4} -> {1,2,3,4} -> {1,2}
pattern444 x y | x == y     =  [At1, At2]
               | otherwise  =  [At2]

pattern445 :: A4 -> A4 -> [A4] -- {1,2,3,4} -> {1,2,3,4} -> {1,2}
pattern445 At1 At1 = [At2]
pattern445 _   _   = [At1, At2]

pattern446 :: A4 -> A4 -> [A4] -- {1,2,3,4} -> {1,2,3,4} -> {1,2}
pattern446 = pattern444
\end{code}

\begin{code}
pattern421 :: A4 -> A4 -> [A4] -- {1,2,3,4} -> {1,2} -> {1,2}
pattern421 At1 At1 = [At1]
pattern421 At1 At2 = [At2]
pattern421 At2 At1 = [At1]
pattern421 At2 At2 = [At2]
pattern421 At3 At1 = [At2]
pattern421 At3 At2 = [At1, At2]
pattern421 At4 At1 = [At2]
pattern421 At4 At2 = [At1, At2]

pattern422 :: A4 -> A4 -> [A4]
pattern422 At1 At1 = [At1]
pattern422 At1 At2 = [At2]
pattern422 At2 At1 = [At2]
pattern422 At2 At2 = [At1, At2]
pattern422 At3 At1 = [At1]
pattern422 At3 At2 = [At2]
pattern422 At4 At1 = [At2]
pattern422 At4 At2 = [At1, At2]

pattern423 :: A4 -> A4 -> [A4]
pattern423 At1 At1 = [At1, At2]
pattern423 At1 At2 = [At2]
pattern423 At2 At1 = [At1, At2]
pattern423 At2 At2 = [At2]
pattern423 At3 At1 = [At2]
pattern423 At3 At2 = [At1, At2]
pattern423 At4 At1 = [At2]
pattern423 At4 At2 = [At1, At2]

pattern424 :: A4 -> A4 -> [A4]
pattern424 At1 At1 = [At1, At2]
pattern424 At1 At2 = [At2]
pattern424 At2 At1 = [At2]
pattern424 At2 At2 = [At1, At2]
pattern424 At3 At1 = [At1, At2]
pattern424 At3 At2 = [At2]
pattern424 At4 At1 = [At2]
pattern424 At4 At2 = [At1, At2]

pattern425 :: A4 -> A4 -> [A4] -- {1,2,3,4} -> {1,2} -> {1,2,3,4}
pattern425 x At1 = [x]
pattern425 _ At2 = [At1, At2, At3, At4]

pattern426 :: A4 -> A4 -> [A4] -- {1,2,3,4} -> {1,2} -> {1,2,3,4}
pattern426 At1 At1 = [     At2, At3, At4]
pattern426 At1 At2 = [At1, At2, At3, At4]
pattern426 At2 _   = [At1, At2, At3, At4]
pattern426 At3 _   = [At1, At2, At3, At4]
pattern426 At4 _   = [At1, At2, At3, At4]
\end{code}
%}}}

%{{{ pattern22*
\begin{code}
pattern221 :: A4 -> A4 -> [A4]
pattern221 At1 At1 = [At1, At2]
pattern221 At1 At2 = [At3, At4]
pattern221 At2 At1 = [At3, At4]
pattern221 At2 At2 = [At1, At2, At3, At4]

pattern222 :: A4 -> A4 -> [A4]
pattern222 At1 At1 = [At1]
pattern222 At1 At2 = [At2]
pattern222 At2 At1 = [At2]
pattern222 At2 At2 = [At1, At2]

pattern223 :: A4 -> A4 -> [A4] -- {1,2} -> {1,2} -> {1,2,3,4}
pattern223 At1 At1 = [At1, At2]
pattern223 At1 At2 = [At3, At4]
pattern223 At2 _   = [At1, At2, At3, At4]

pattern224 :: A4 -> A4 -> [A4]
pattern224 At1 At1 = [At1, At3]
pattern224 At1 At2 = [At2, At4]
pattern224 At2 At1 = [At2, At4]
pattern224 At2 At2 = [At1, At2, At3, At4]

pattern225 ::  A4 -> A4 -> [A4] -- {1,2} -> {1,2} -> {1,2,3,4}
pattern225 At1 At1 = [At1, At3]
pattern225 At1 At2 = [At2, At4]
pattern225 At2 _   = [At1, At2, At3, At4]

pattern227 :: A4 -> A4 -> [A4] -- {1,2} -> {1,2} -> {1,2}
pattern227 At1 x = [x]
pattern227 At2 _ = [At1, At2]

pattern228 :: A4 -> A4 -> [A4]
pattern228 At1 At1 = [At1, At2]
pattern228 At1 At2 = [At2]
pattern228 At2 At1 = [At2]
pattern228 At2 At2 = [At1, At2]

pattern229 :: A4 -> A4 -> [A4]
pattern229 At1 At1 = [At1]
pattern229 At1 At2 = [At1, At2]
pattern229 At2 At1 = [At2]
pattern229 At2 At2 = [At1, At2]
\end{code}
%}}}

%{{{ pattern24*
\begin{code}
pattern241 :: A4 -> A4 -> [A4] -- {1.2} -> {1,2,3,4} -> {1,2}
pattern241 At1 At1 = [At1]
pattern241 At1 At2 = [At1]
pattern241 At1 At3 = [At2]
pattern241 At1 At4 = [At2]
pattern241 At2 _   = [At1, At2]

pattern242 :: A4 -> A4 -> [A4] -- {1.2} -> {1,2,3,4} -> {1,2}
pattern242 At1 At1 = [At1]
pattern242 At1 At2 = [At2]
pattern242 At1 At3 = [At1]
pattern242 At1 At4 = [At2]
pattern242 At2 _   = [At1, At2]
\end{code}
%}}}

\noindent
Putting this together, composition on atoms is defined as follows
(we split the definition into five seperate functions
 for small versions of Hugs): 

%\begin{twocolumn}
\begin{code}
atCompA :: MadduxObj -> MadduxObj -> A4 -> A4 -> [A4]
atCompA A A n m = pattern441 n m
atCompA A B n m = pattern421 n m
atCompA A C n m = pattern422 n m
atCompA A D n m = pattern442 n m
atCompA A E n m = pattern442 n m

atCompA B A n m = pattern221 n m
atCompA B B n m = pattern222 n m
atCompA B C n m = [At1, At2]
atCompA B D n m = pattern223 n m
atCompA B E n m = pattern223 n m

atCompA C A n m = pattern224 n m
atCompA C B n m = [At1, At2]
atCompA C C n m = pattern222 n m
atCompA C D n m = pattern225 n m
atCompA C E n m = pattern225 n m

atCompA D A n m = pattern443 n m
atCompA D B n m = pattern423 n m
atCompA D C n m = pattern424 n m
atCompA D D n m = pattern425 n m
atCompA D E n m = pattern426 n m

atCompA E A n m = pattern443 n m
atCompA E B n m = pattern423 n m
atCompA E C n m = pattern424 n m
atCompA E D n m = pattern426 n m
atCompA E E n m = pattern425 n m
\end{code}

\begin{code}
atCompB :: MadduxObj -> MadduxObj -> A4 -> A4 -> [A4]
atCompB A A n m = atCompA A B m n  
atCompB A B n m = pattern222 n m 
atCompB A C n m = [At1]
atCompB A D n m = pattern241 n m 
atCompB A E n m = pattern241 n m 

atCompB B A n m = atCompA B B m n  
atCompB B B n m = pattern222 n m 
atCompB B C n m = [At1]
atCompB B D n m = pattern227 n m 
atCompB B E n m = pattern227 n m 

atCompB C A n m = atCompA C B m n  
atCompB C B At1 At1 = [At1, At2]
atCompB C C n m = [At1]
atCompB C D n m = [At1, At2]
atCompB C E n m = [At1, At2]

atCompB D A n m = atCompA D B m n  
atCompB D B n m = pattern228 n m 
atCompB D C n m = [At1]
atCompB D D n m = pattern229 n m 
atCompB D E n m = [At1, At2]

atCompB E A n m = atCompA E B m n  
atCompB E B n m = pattern228 n m 
atCompB E C n m = [At1]
atCompB E D n m = [At1, At2]
atCompB E E n m = pattern229 n m 
\end{code}

\begin{code}
atCompC :: MadduxObj -> MadduxObj -> A4 -> A4 -> [A4]
atCompC A A n m = atCompA A C m n  
atCompC A B n m = atCompB A C m n  
atCompC A C n m = pattern222 n m 
atCompC A D n m = pattern242 n m 

atCompC A E n m = pattern242 n m 
atCompC B A n m = atCompA B C m n  
atCompC B B n m = atCompB B C m n  
atCompC B C At1 At1 = [At1, At2]
atCompC B D n m = [At1, At2]
atCompC B E n m = [At1, At2]

atCompC C A n m = atCompA C C m n  
atCompC C B n m = atCompB C C m n  
atCompC C C n m = pattern222 n m 
atCompC C D n m = pattern227 n m 
atCompC C E n m = pattern227 n m 

atCompC D A n m = atCompA D C m n  
atCompC D B n m = atCompB D C m n  
atCompC D C n m = pattern228 n m 
atCompC D D n m = pattern229 n m 
atCompC D E n m = [At1, At2]

atCompC E A n m = atCompA E C m n  
atCompC E B n m = atCompB E C m n  
atCompC E C n m = pattern228 n m 
atCompC E D n m = [At1, At2]
atCompC E E n m = pattern229 n m 
\end{code}

\begin{code}
atCompD :: MadduxObj -> MadduxObj -> A4 -> A4 -> [A4]
atCompD A A n m = atCompA A D m n  
atCompD A B n m = atCompB A D m n  
atCompD A C n m = atCompC A D m n  
atCompD A D n m = pattern444 n m 
atCompD A E n m = pattern445 n m 

atCompD B A n m = atCompA B D m n  
atCompD B B n m = atCompB B D m n  
atCompD B C n m = atCompC B D m n  
atCompD B D n m = pattern228 n m 
atCompD B E n m = [At1, At2]

atCompD C A n m = atCompA C D m n  
atCompD C B n m = atCompB C D m n  
atCompD C C n m = atCompC C D m n  
atCompD C D n m = pattern228 n m 
atCompD C E n m = [At1, At2]

atCompD D A n m = atCompA D D m n  
atCompD D B n m = atCompB D D m n  
atCompD D C n m = atCompC D D m n  
atCompD D D n m = pattern222 n m 
atCompD D E n m = pattern227 n m 

atCompD E A n m = atCompA E D m n  
atCompD E B n m = atCompB E D m n  
atCompD E C n m = atCompC E D m n  
atCompD E D n m = pattern228 n m 
atCompD E E n m = pattern229 n m 
\end{code}

\begin{code}
atCompE :: MadduxObj -> MadduxObj -> A4 -> A4 -> [A4]
atCompE A A n m = atCompA A E m n  
atCompE A B n m = atCompB A E m n  
atCompE A C n m = atCompC A E m n  
atCompE A D n m = atCompD A E m n  
atCompE A E n m = pattern446 n m 

atCompE B A n m = atCompA B E m n  
atCompE B B n m = atCompB B E m n  
atCompE B C n m = atCompC B E m n  
atCompE B D n m = atCompD B E m n  
atCompE B E n m = pattern228 n m 

atCompE C A n m = atCompA C E m n  
atCompE C B n m = atCompB C E m n  
atCompE C C n m = atCompC C E m n  
atCompE C D n m = atCompD C E m n  
atCompE C E n m = pattern228 n m 

atCompE D A n m = atCompA D E m n  
atCompE D B n m = atCompB D E m n  
atCompE D C n m = atCompC D E m n  
atCompE D D n m = atCompD D E m n  
atCompE D E n m = pattern228 n m 

atCompE E A n m = atCompA E E m n  
atCompE E B n m = atCompB E E m n  
atCompE E C n m = atCompC E E m n  
atCompE E D n m = atCompD E E m n  
atCompE E E n m = pattern222 n m 
\end{code}

\begin{code}
atComp :: MadduxObj -> MadduxObj -> MadduxObj -> A4 -> A4 -> [A4]
atComp A x y a b = atCompA x y a b
atComp B x y a b = atCompB x y a b
atComp C x y a b = atCompC x y a b
atComp D x y a b = atCompD x y a b
atComp E x y a b = atCompE x y a b
\end{code}
%\end{twocolumn}

The list of products has exactly one element:

\begin{session}
Main> ded_NonemptyProducts (ra_ded ra_Maddux)
[(B,C,A,SetMor ({At1},A,B),SetMor ({At1},A,C))]
\end{session}

From the evaluation of the expression

\begin{session}
printAllTestResults $ distrAll_funTest $ ra_distrAll ra_Maddux
\end{session}

we see that the projections are the only two non-trivial functions
in this relation algebra.

There are two constellations (related via conversion symmetry)
that show that this product is unsharp:

%{{{ unsharp
\begin{session}
Main> let d = ra_ded ra_Maddux in 
        performAll (unsharp (head (ded_NonemptyProducts d))) d
=== Test Start ===
unsharpness example
 Objects:
  D
  E
 Morphisms:
  SetMor ({At1},D,B)
  SetMor ({At1},D,C)
  SetMor ({At1},B,E)
  SetMor ({At1},C,E)
  SetMor ({At2},D,E)
  SetMor ({At1, At2},D,E)
unsharpness example
 Objects:
  E
  D
 Morphisms:
  SetMor ({At1},E,B)
  SetMor ({At1},E,C)
  SetMor ({At1},B,D)
  SetMor ({At1},C,D)
  SetMor ({At2},E,D)
  SetMor ({At1, At2},E,D)
=== Test End   ===
\end{session}
%}}}


\ignore{
%{{{ aallMat aAll_Maddux matObjs_Maddux
With the following code snippet (which is not part of this module)
we construct a matrix relation algebra with all single objects and
object pairs as objects,
and then look for all products therein:

\begin{session}
matObjs_Maddux = do a <- objseq
                    [a] : do b <- objseq
                             [[a,b]]

matDed_Maddux = atomsetDed $ aallMat aAll_Maddux matObjs_Maddux

main = putStr $ unlines $ map show $ ded_NonemptyProducts matDed_Maddux
\end{session}

The first result is printed immediately;
after two hours and 31 minutes the search finishes with the following
(manually beautified) results:

%{{{ products
\begin{session}
([B],[C]  ,[A]  , SetMor ({(0,0,At1)           },[A]  ,[B]  )
                , SetMor ({(0,0,At1)           },[A]  ,[C]  ) )
([B],[C,C],[A,A], SetMor ({(0,0,At1), (1,0,At1)},[A,A],[B]  )
                , SetMor ({(0,1,At1), (1,0,At1)},[A,A],[C,C]) )
([B],[C,C],[A,A], SetMor ({(0,0,At1), (1,0,At1)},[A,A],[B]  )
                , SetMor ({(0,0,At1), (1,1,At1)},[A,A],[C,C]) )
([B,B],[C],[A,A], SetMor ({(0,1,At1), (1,0,At1)},[A,A],[B,B])
                , SetMor ({(0,0,At1), (1,0,At1)},[A,A],[C]  ) )
([B,B],[C],[A,A], SetMor ({(0,0,At1), (1,1,At1)},[A,A],[B,B])
                , SetMor ({(0,0,At1), (1,0,At1)},[A,A],[C]  ) )
\end{session}
%}}}

Here, the second product is equal to the third up to permutation,
and the forth corresponds to the fifth.

With the following additional definitions we test for
unsharpness configurations in the two interesting products:

\begin{session}
products_Maddux2 :: [Product [MadduxObj] (SetMor [MadduxObj] (Int,Int,A4))]
products_Maddux2 = map read
  ["([B],[C,C],[A,A],SetMor ({(0,0,At1), (1,0,At1)},[A,A],[B])" ++
                   ",SetMor ({(0,0,At1), (1,1,At1)},[A,A],[C,C]))"
  ,"([B,B],[C],[A,A],SetMor ({(0,0,At1), (1,1,At1)},[A,A],[B,B])" ++
                   ",SetMor ({(0,0,At1), (1,0,At1)},[A,A],[C]))"
  ]

main = let d = matDed_Maddux
       in mapM_ (\ p -> performAll (unsharp p) d) products_Maddux2
\end{session}

After over ninety hours,
%the exploration finishes after coming up with
\verb|perform| comes up with
three configurations for each product:
%(\verb|performAll| still running \unfinished)

%{{{ maddux2unsharp
\begin{session}
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,1,At1)},[A,D],[C,C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(1,1,At1)},[C,C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,1,At1)},[A,D],[C,C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(1,0,At2), (1,1,At1)},[C,C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,1,At1)},[A,D],[C,C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(1,0,At1), (1,1,At1)},[C,C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,1,At1)},[A,D],[B,B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(1,1,At1)},[B,B],[A,E])
  SetMor ({(0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,1,At1)},[A,D],[B,B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(1,1,At1)},[B,B],[A,E])
  SetMor ({(0,0,At2), (0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,1,At1)},[A,D],[B,B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(1,1,At1)},[B,B],[A,E])
  SetMor ({(0,0,At1), (0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
\end{session}
%}}}

For the embedded product

\begin{session}
([B],[C],[A],SetMor ({(0,0,At1)},[A],[B]),SetMor ({(0,0,At1)},[A],[C]))
\end{session}

the first three results are found in six minutes:

%{{{ maddux2unsharp1
\begin{session}
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(0,0,At2), (0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
unsharpness example
 Objects:
  [A,D]
  [A,E]
 Morphisms:
  SetMor ({(1,0,At1)},[A,D],[B])
  SetMor ({(1,0,At1)},[A,D],[C])
  SetMor ({(0,1,At1)},[B],[A,E])
  SetMor ({(0,0,At1), (0,1,At1)},[C],[A,E])
  SetMor ({(1,1,At2)},[A,D],[A,E])
  SetMor ({(1,1,At1), (1,1,At2)},[A,D],[A,E])
\end{session}
%}}}

All 32764 results take about an hour.
%}}}
}%ignore


%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:
