\section{Test Program}

\begin{code}
module Main where

import RATH

import RATHexamples

-- all atomset algebras:
-- P1 P12 P012 P0123 McKenzie Maddux NUW MereoN1 MereoC1 MereoG
--Interval LRNnoc Compass Compass3

main = acat_TESTALL

acat_TESTALL = do
        putStrLn "P1:"
        perform acat_TEST aCat_P1
        putStrLn "P12:"
        perform acat_TEST aCat_P12
        putStrLn "P012:"
        perform acat_TEST aCat_P012
        putStrLn "P0123:"
        perform acat_TEST aCat_P0123
        putStrLn "McKenzie:"
        perform acat_TEST aCat_McKenzie
        putStrLn "Maddux:"
        perform acat_TEST aCat_Maddux
        putStrLn "NUW:"
        perform acat_TEST aCat_NUW
        putStrLn "MereoN1:"
        perform acat_TEST aCat_MereoN1
        putStrLn "MereoC1:"
        perform acat_TEST aCat_MereoC1
        putStrLn "MereoG:"
        perform acat_TEST aCat_MereoG
        putStrLn "Interval:"
        perform acat_TEST aCat_Interval
        putStrLn "LRNnoc:"
        perform acat_TEST aCat_LRNnoc
        putStrLn "Compass:"
        perform acat_TEST aCat_Compass
        putStrLn "Compass:"
        perform acat_TEST aCat_Compass3


aall_TESTALL = do
        putStrLn "P1:"
        perform aall_TEST aAll_P1
        putStrLn "P12:"
        perform aall_TEST aAll_P12
        putStrLn "P012:"
        perform aall_TEST aAll_P012
        putStrLn "P0123:"
        perform aall_TEST aAll_P0123
        putStrLn "McKenzie:"
        perform aall_TEST aAll_McKenzie
        putStrLn "Maddux:"
        perform aall_TEST aAll_Maddux
        putStrLn "NUW:"
        perform aall_TEST aAll_NUW
        putStrLn "MereoN1:"
        perform aall_TEST aAll_MereoN1
        putStrLn "MereoC1:"
        perform aall_TEST aAll_MereoC1
        putStrLn "MereoG:"
        perform aall_TEST aAll_MereoG
        putStrLn "Interval:"
        perform aall_TEST aAll_Interval
        putStrLn "LRNnoc:"
        perform aall_TEST aAll_LRNnoc
        putStrLn "Compass:"
        perform aall_TEST aAll_Compass

units_ALL = do
        putStrLn ("P1: " ++ show (all_units $ atomsetAll aAll_P1))
        putStrLn ("P12: " ++ show (all_units $ atomsetAll aAll_P12))
        putStrLn ("P012: " ++ show (all_units $ atomsetAll aAll_P012))
        putStrLn ("P0123: " ++ show (all_units $ atomsetAll aAll_P0123))
        putStrLn ("McKenzie: " ++ show (all_units $ atomsetAll aAll_McKenzie))
        putStrLn ("Maddux: " ++ show (all_units $ atomsetAll aAll_Maddux))
        putStrLn ("NUW: " ++ show (all_units $ atomsetAll aAll_NUW))
        putStrLn ("MereoN1: " ++ show (all_units $ atomsetAll aAll_MereoN1))
        putStrLn ("MereoC1: " ++ show (all_units $ atomsetAll aAll_MereoC1))
        putStrLn ("MereoG: " ++ show (all_units $ atomsetAll aAll_MereoG))
        putStrLn ("Interval: " ++ show (all_units $ atomsetAll aAll_Interval))
        putStrLn ("LRNnoc: " ++ show (all_units $ atomsetAll aAll_LRNnoc))
        putStrLn ("Compass: " ++ show (all_units $ atomsetAll aAll_Compass))

aall_Products aall = ded_NonemptyProducts $ atomsetDed aall

atomset_PRODUCTS = do
        putStr (unlines ("P1:" : map show (aall_Products aAll_P1)))
        putStr (unlines ("P12:" : map show (aall_Products aAll_P12)))
        putStr (unlines ("P012:" : map show (aall_Products aAll_P012)))
        putStr (unlines ("P0123:" : map show (aall_Products aAll_P0123)))
        putStr (unlines ("McKenzie:" : map show (aall_Products aAll_McKenzie)))
        putStr (unlines ("Maddux:" : map show (aall_Products aAll_Maddux)))
        putStr (unlines ("NUW:" : map show (aall_Products aAll_NUW)))
        putStr (unlines ("MereoN1:" : map show (aall_Products aAll_MereoN1)))
        putStr (unlines ("MereoC1:" : map show (aall_Products aAll_MereoC1)))
        putStr (unlines ("MereoG:" : map show (aall_Products aAll_MereoG)))
        putStr (unlines ("Interval:" : map show (aall_Products aAll_Interval)))
        putStr (unlines ("LRNnoc:" : map show (aall_Products aAll_LRNnoc)))
        putStr (unlines ("Compass:" : map show (aall_Products aAll_Compass)))

all_RA_TEST_ALL = do
        putStrLn "ra1:"
        perform ra_TEST_ALL (ra1 () ())
        putStrLn "ra2:"
        perform ra_TEST_ALL (ra2 42 "Bottom" "Identity")
        putStrLn "raB:"
        perform ra_TEST_ALL raB
        putStrLn "raN2:"
        perform ra_TEST_ALL (raN () 1)
        putStrLn "raN3:"
        perform ra_TEST_ALL (raN () 2)
        putStrLn "P1:"
        perform ra_TEST_ALL ra_P1
        putStrLn "P12:"
        perform ra_TEST_ALL ra_P12
        putStrLn "McKenzie:"
        perform ra_TEST_ALL ra_McKenzie
        putStrLn "NUW:"
        perform ra_TEST_ALL ra_NUW
        putStrLn "MereoN1:"
        perform ra_TEST_ALL ra_MereoN1
        putStrLn "MereoC1:"
        perform ra_TEST_ALL ra_MereoC1
        putStrLn "MereoG:"
        perform ra_TEST_ALL ra_MereoG
        putStrLn "Interval:"
        perform ra_TEST_ALL ra_Interval
        putStrLn "LRNnoc:"
        perform ra_TEST_ALL ra_LRNnoc
        putStrLn "P012:"
        perform ra_TEST_ALL ra_P012
        putStrLn "Compass:"
        perform ra_TEST_ALL ra_Compass
        putStrLn "Maddux:"
        perform ra_TEST_ALL ra_Maddux
        putStrLn "P0123:"
        perform ra_TEST_ALL ra_P0123

-- main = all_RA_TEST_ALL


-- main = perform cat_TEST $
--        ra_cat ra_P012                                 -- 0.290s
--        catMat distrAllB [[],[()]]                     -- 0.010s
--        catMat distrAllB o012                          -- 0.410s
--        catMat distrAllB o0123                         -- 4h45m56.950s
--        catMat (ra_distrAll ra_P012) [[P0],[P1,P1],[P2]]    -- 6.940s
--        catMat (ra_distrAll ra_P012) [[P0],[P1],[P1,P1],[P2]] -- 8.770s

-- main = perform all_TEST $
--        ra_all ra_P012                                 -- 0.320s
--        allMat distrAllB o012                          -- 0.440s
--        allMat distrAllB o0123                         --
--        allMat (ra_distrAll ra_P012) [[P0],[P1,P1],[P2]]     -- 4.460s
--        allMat (ra_distrAll ra_P012) [[P0],[P1],[P1,P1],[P2]]   -- 4.780s
--        allMat (ra_distrAll ra_P012) [[P0],[P1],[P1,P1],[P2],[P1,P2]] --

--main = test_for_equivalence_0123

inits l = [] : case l of [] -> [];  (x:xs) -> map (x:) (inits xs)

trivs n = inits (replicate n ())

o012 = trivs 2
o0123 = trivs 3
o01234 = trivs 4

-- main = perform cat_TEST $ atomsetCat $ acatMat acatB o012  -- 0.350s
-- main = perform all_TEST $ atomsetAll $ aallMat aallB o012  -- 0.500s

--main = perform acat_TEST aCat_P012 -- 0.020s
--main = perform aall_TEST aAll_P012 -- 0.000s
--main = perform acat_TEST $ acatMat aCat_P012 [[P0],[P1],[P1,P1],[P2]] -- 0.030s
--main = perform aall_TEST $ aallMat aAll_P012 [[P0],[P1],[P1,P1],[P2]] -- 0.010s

-- main = perform acat_TEST $ acatMat acatB o012      -- 0.000s
-- main = perform aall_TEST $ aallMat aallB o012      -- 0.000s
-- main = perform acat_TEST $ acatMat acatB o0123     -- 0.100s
-- main = perform aall_TEST $ aallMat aallB o0123     -- 0.030s
-- main = perform acat_TEST $ acatMat acatB o01234    -- 0.990s
-- main = perform aall_TEST $ aallMat aallB o01234    -- 0.220s
-- main = perform acat_TEST $ acatMat acatB $ trivs 5 -- 6.610s
-- main = perform aall_TEST $ aallMat aallB $ trivs 5 -- 1.210s
-- main = perform acat_TEST $ acatMat acatB $ trivs 6 -- 34.030s
-- main = perform aall_TEST $ aallMat aallB $ trivs 6 -- 5.150s

-- main = perform cat_TEST $ atomsetCat $
--        acatMat aCat_P012 [[P0],[P1],[P1,P1],[P2]] -- 5.490s

-- main = perform all_TEST $ atomsetAll $
--        aallMat aAll_P012 [[P0],[P1],[P1,P1],[P2]] -- 3.640s

-- main = perform ra_TEST_ALL $ atomsetRA $
--        aallMat aAll_P012 [[P0],[P1],[P1,P1],[P2]] -- 8.670s

-- main = perform ra_TEST_ALL $ ra_McKenzie -- 0.740s

-- main = perform acat_TEST aCat_Maddux   -- 0.200s 
-- main = perform aall_TEST aAll_Maddux   -- 0.030s
-- main = perform ra_TEST_ALL $ ra_Maddux -- 19.600s

matObjs_Maddux = let objseq = acat_objects aCat_Maddux in
                 do a <- objseq
                    [a] : do b <- objseq
                             [[a,b]]

matDed_Maddux = atomsetDed $ aallMat aAll_Maddux matObjs_Maddux

--matDed_Maddux_NEProds = ded_NonemptyProducts matDed_Maddux

--main = putStr $ unlines $ map show $ ded_NonemptyProducts matDed_Maddux


\end{code}



