\section{The McKenzie Relation Algebra}\sectlabel{McKenzie}

A nice non-representable relation algebra is the McKenzie algebra
\cite{McKenzie-1970}.
The following explanation is simply recalled from 
\cite{Schmidt-Stroehlein-1989,Schmidt-Stroehlein-1993}.

\smallskip
\centerline{\scalebox{0.1}{\includegraphics{McKenzieBOT.eps}}}

\medskip
\centerline{\small Boolean lattice structure of the McKenzie algebra}

\medskip
\noindent
There are four atoms which might be called generators, namely $\RId{}, a,
b, c$; they are the upper neighbors of $\RO{}$.
\ignore{(In the drawing above, you find
 ``I'' in the place of $\RId{}$,
 ``O'' in the place of $\RO{}$, and
 ``L'' in the place of $\RL{}$.)}
Each of the 16 elements can be expressed as a subset of these four,
so that a boolean lattice is established giving a four-dimensional cube.
So $\RO{}$ corresponds to the union of none and $\RL{}$ to the union of all of them, 
$a$ to the union of just one, and so forth.
For instance, $\relnot{a}$ means that all but $a$ are united.

Transposition and composition is defined by giving the set 
$$
    \rtrans{\RId{}}=\RId{},
  \quad
    \rtrans{a}=c,
  \quad
    \rtrans{b}=b,
  \quad
    \rtrans{c}=a,
  \quad
    a\sp2=a,
  \quad
    b\sp2=\relnot{b},
  \quad
    c\sp2=c,
$$
$$
    a\rcmp c=c\rcmp a=\RL{},
  \quad
    a\rcmp b=b\rcmp a=a\relor b,
  \quad
    c\rcmp b=b\rcmp c=c\relor b
$$
of basic compositions, from which the rest of compositions can be elaborated by distributivity.

Assume now that there exists a representation for the elements of this relation algebra
in a set of 16 Boolean $n\times n$-matrices. 
We will prove that this assumption leads to a contradiction, 
so that such a representation cannot exist.
As $a$ satisfies $a\sp2=a\rsubs\relnot{\RId{}}$ and $a\reland \rtrans{a} =a\reland c=\RO{}$, it
corresponds to a transitive and irreflexive matrix 
which is therefore a strict-ordering.
By definition, $c$ is the converse of $a$, 
so that $b$ gives the relationship of incomparability
with respect to this strict-ordering $a$
since $\relnot{b}=\RId{}\relor a\relor c$.
From $a\rcmp \rtrans{a}=\RL{}$ it follows that any pair of elements
has a common upper bound which is different from both of them. On the other hand,
$\relnot{b}=b\sp2$ demands that any pair of comparable elements has some element 
to which they are both incomparable.

\bigskip
{\def\put#1 #2 #3 {\vbox to0pt{\kern-#3\scale
    \hbox{\kern\shift\kern#2\scale#1}\vss}\nointerlineskip}

\newdimen\scale
\newdimen\shift
\vbox{%
%\def\fuenfe{\scaledpicture 8.22cm by 6.2cm (fuenfe scaled 500)}
%\def\fuenfe{\scalebox{0.5}{\includegraphics{McKenzieBeweis.eps}}}
\def\fuenfe{\scalebox{0.6}{\includegraphics{McKenzie-non-concrete.eps}}}
$$\hbox to\hsize{\hfil\fuenfe\hfil}$$
\vskip-0.5cm
\shift=1true cm
\scale=1true cm
\put $\strut e_1$ 5.7 0.55
\put $\strut e_2$ 8.2 0.55
\put $\strut e_3$ 6.9 4.1
\put $\strut e_4$ 9.35 2.8
\put $\strut e_5$ 4.6 2.8
\hbox{}\vskip.2cm
\centerline {\small Case analysis}
}%ende vbox
}%end\def\put

\medskip
\noindent
Now we switch to the usual notation $<$ for the strict-ordering $a$.
This is the crucial step.
We are no longer satisfied with just composition tables as before,
but are looking for some set together with a strict-ordering satisfying the properties
just mentioned.
Since $b\not=\RO{}$, there exist at least two incomparable elements $e_1,e_2$ 
in the set.
They have some common upper bound $e_3$ with 
$e_1< e_3, e_2< e_3$, so that elements $e_4, e_5$ must exist
with all the pairs $(e_1,e_5),\allowbreak(e_3,e_5),
\allowbreak(e_2,e_4),\allowbreak(e_3,e_4)$ incomparable.
However, from consecutive incomparability we may then conclude that
$(e_2,e_5), (e_1,e_4), (e_4,e_5)$ are comparable pairs of elements.
Now a case analysis leads to a contradiction:
First we have that $e_1< e_4, e_2< e_5$, 
since $e_4,e_5$ must not be less than $e_3$.
Then $e_4\not=e_5$ since, by assumption, $e_1, e_2$ are incomparable 
which would contradict
$(e_1,e_5), (e_2,e_4)$ (with $e_4=e_5$) being incomparable.
In this situation there is no possibility to 
decide whether $e_4< e_5$ or $e_5< e_4$, without introducing  
the forbidden relationships
$e_1< e_5$ or 
$e_2< e_4$ by transitivity.

\medskip
The translation of the algebraic description of the McKenzie algebra
into
Haskell is completely straightforward:

\begin{code}
module McKenzie(aCat_McKenzie,aAll_McKenzie,ra_McKenzie) where

import RelAlg
import Atomset
\end{code}

%\noindent
%The McKenzie relation algebra is the most wellknown nonrepresentable
%relation algebra. It is included here only for demonstration purposes.

\begin{code}
aCat_McKenzie :: ACat () Atom
aCat_McKenzie = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ _ _  _ -> True)
  ,acat_objects = [()]
  ,acat_atomset = const $ const [I, A, B, C]
  ,acat_idmor   = const [I]
  ,acat_comp    = (\ _ _ _  -> comp)
  }

aAll_McKenzie :: AAll () Atom
aAll_McKenzie = AAll
  {aall_acat = aCat_McKenzie
  ,aall_converse = (\ _ _ -> conv)
  }

ra_McKenzie :: RA () (SetMor () Atom)
ra_McKenzie = atomsetRA aAll_McKenzie
\end{code}

\begin{code}
data Atom = I | A | B | C   deriving (Eq, Show, Ord)
\end{code}

\begin{code}
conv I = I
conv A = C
conv C = A
conv B = B
\end{code}

\begin{code}
comp I x = [x]
comp x I = [x]
comp A A = [A]
comp A B = [A, B]
comp B A = [A, B]
comp A C = [I, A, B, C]
comp C A = [I, A, B, C]
comp B C = [B, C]
comp C B = [B, C]
comp B B = [I, A, C]
comp C C = [C]
\end{code}

%\noindent
%It is quite an elementary proof, reproduced in \cite{Schmidt-Stroehlein-1993}, 
%showing that the element $a$ cannot
%be conceived as a relation on whatever a set.


%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:
