\subsection{C1}

The first approach to  mereology will now be refined by taking
into account also that there may be {\it external contact} (ec)
between two items. So a fifth atom is added.
Much of the composition tables stays the same. 
One may say that a row and a column have to be added.

\begin{code}
module MereoC1(aCat_MereoC1,aAll_MereoC1,ra_MereoC1) where

import RelAlg
import Atomset
import Matrix

import FiniteMaps
import Sets
\end{code}
\ignore{Stand 22.09.98}

\noindent
The are five atoms are represented as follows:

     \ \ {1'\ \ by {\tt  I}},
     \ \ {p\ \ by {\tt  P}},
     \ \ {p\#\ \ by {\tt PH}},
     \ \ {ec\ \ by {\tt EC}},\ \  and
     \ \ {dc\ \ by {\tt DC}}.

\begin{code}
data Atomset = I | P | PH | EC | DC  deriving (Eq, Ord, Show) 
atoms :: [Atomset]
atoms = [I, P, PH, EC, DC]
\end{code}

\begin{code}
aCat_MereoC1 :: ACat () Atomset
aCat_MereoC1 = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ _ _ _ -> True)
  ,acat_objects = [()]
  ,acat_atomset = (\ _ _ -> atoms)
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = (\ _ _ _ -> atComp)
  }

aAll_MereoC1 :: AAll () Atomset
aAll_MereoC1 = AAll
  {aall_acat = aCat_MereoC1
  ,aall_converse = (\ _ _ -> conv)
  }

ra_MereoC1 :: RA () (SetMor () Atomset)
ra_MereoC1 = atomsetRA aAll_MereoC1
\end{code}

\begin{code}
conv :: Atomset -> Atomset
conv P  = PH
conv PH = P 
conv x  = x
\end{code}

%{{{ atComp
\begin{code}
atComp :: Atomset -> Atomset -> [Atomset]

atComp I  I  = [I]
atComp I  P  = [P]
atComp I  PH = [PH]
atComp I  EC = [EC]
atComp I  DC = [DC]
       	  
atComp P  I  = [P]
atComp P  P  = [P]
atComp P  PH = [I, P, PH]
atComp P  EC = [EC, DC]
atComp P  DC = [DC]
       
atComp PH I  = [PH]
atComp PH P  = [I, P, PH]
atComp PH PH = [PH]
atComp PH EC = [EC]
atComp PH DC = [EC, DC]
       
atComp EC I  = [EC]
atComp EC P  = [EC]
atComp EC PH = [EC, DC]
atComp EC EC = [I, P, PH]
atComp EC DC = [PH]
       
atComp DC I  = [DC]
atComp DC P  = [EC, DC]
atComp DC PH = [DC]
atComp DC EC = [P]
atComp DC DC = [I, P, PH]
\end{code}
%}}}



%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:

