\subsection{G}

This is a third example of mereology.
It is claimed by D\"untsch (cf.~\cite{Duentsch-1998}) that, whenever
a relational model for spatial reasoning is considered,
then --- under some other conditions --- this algebra will be present.
The interpretation of the algebra ${\cal G}$ is that we start with
the concept

\hbox{\hbox to1cm{\hfil $P$\hfil}  \phantom{$\equiv$}
      \hbox to2.5cm{\hfil}  $\equiv$ ``is proper part of''\hfil}

\noindent 
and its converse $\rtrans{P}$ and then consider 

\hbox{\hbox to1cm{\hfil $O$\hfil}
      $\equiv$
      \hbox to2.5cm{\hfil$\RELand{\RELcmp{\rtrans{P}}{P}}{\relnot{1'}}$\hfil}  
      \hbox{$\equiv$ 
      ``being non-identical and properly overlapping'' \hfil}}

\hbox{\hbox to1cm{\hfil \#\hfil}
      $\equiv$
      \hbox to2.5cm{\hfil$\relnot{\RELor{\RELor{P}{\rtrans{P}}}{1'}}$\hfil}
      $\equiv$
      ``being incomparable wrt.~the (reflexive) is-part-of ordering''\hfil}

\hbox{\hbox to1cm{\hfil $T$\hfil}
      $\equiv$
      \hbox to2.5cm{\hfil$\RELand{\RELcmp{P}{\rtrans{P}}}{\relnot{1'}}$\hfil}
      $\equiv$
      ``being non-identical and commonly being properly topped''\hfil}

\noindent
The concept of $O$ is then subdivided into $P, \rtrans{P}, ON, OD$
and amended by $DN, DD$:


\hbox{\hbox to1cm{\hfil $ON$\hfil}
      $\equiv$
      \hbox to2.5cm{\hfil$\RELand{\RELand{O}{\#}}{T}$\hfil}  
%      \hbox{$\equiv$ 
%      ``{\unfinished}'' \hfil}
}

\hbox{\hbox to1cm{\hfil $OD$\hfil}
      $\equiv$
      \hbox to2.5cm{\hfil$\RELand{\RELand{O}{\#}}{\relnot{T}}$\hfil}  
%      \hbox{$\equiv$ 
%      ``{\unfinished}'' \hfil}
}

\hbox{\hbox to1cm{\hfil $DN$\hfil}
      $\equiv$
      \hbox to2.5cm{\hfil$\RELand{\relnot{O}}{T}$\hfil}  
%      \hbox{$\equiv$ 
%      ``{\unfinished}'' \hfil}
}

\hbox{\hbox to1cm{\hfil $DD$\hfil}
      $\equiv$
      \hbox to2.5cm{\hfil$\relnot{\RELor{\RELor{O}{T}}{1'}}$\hfil}  
%      \hbox{$\equiv$ 
%      ``{\unfinished}'' \hfil}
}

\noindent
The interrelationship is then investigated taking the above as seven
atoms,
representing them in the following way:

\begin{tabular}{l@{\ }l@{\ }l@{\hskip3em}l@{\ by\ }l@{\hskip3em}l@{\ by\ }l@{\hskip3em}l@{\ by\ }l}
1' & by & {\tt  I}
&
$P$ & {\tt  P}
&
$ON$ & {\tt ON}
&
$DN$ & {\tt DN}
\\
&&&
$\rtrans{P}$ & {\tt PH}
&
$OD$ & {\tt OD}
&
$DD$ & {\tt DD}
\end{tabular}
\begin{code}
module MereoG(aCat_MereoG,aAll_MereoG,ra_MereoG,assert_G_TEST) where

import RelAlg
import Atomset
import Matrix

import FiniteMaps
import Sets
\end{code}
\ignore{Stand 08.07.2000}

\noindent

\begin{code}
data Atomset = I | P | PH | ON | OD | DN | DD  deriving (Eq, Ord, Show)
atoms = [I, P, PH, ON, OD, DN, DD]
\end{code}

\begin{code}
aCat_MereoG :: ACat () Atomset
aCat_MereoG = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ _ _ _ -> True)
  ,acat_objects = [()]
  ,acat_atomset = (\ _ _ -> atoms)
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = (\ _ _ _ -> atComp)
  }

aAll_MereoG :: AAll () Atomset
aAll_MereoG = AAll
  {aall_acat = aCat_MereoG
  ,aall_converse = (\ _ _ -> conv)
  }

ra_MereoG :: RA () (SetMor () Atomset)
ra_MereoG = atomsetRA aAll_MereoG

conv :: Atomset -> Atomset
conv P  = PH
conv PH = P 
conv x  = x
\end{code}

%{{{ atComp
\begin{code}
atComp :: Atomset -> Atomset -> [Atomset]

atComp I  x  = [x]
atComp x  I  = [x]
       
atComp P  P  = [P]
atComp P  PH = [I, P, PH, ON, DN]
atComp P  ON = [P, ON, DN]
atComp P  OD = [P, ON, OD, DN, DD]
atComp P  DN = [DN]
atComp P  DD = [DN]
       
atComp PH P  = [I, P, PH, ON, OD]
atComp PH PH = [PH]
atComp PH ON = [PH, ON, OD]
atComp PH OD = [OD]
atComp PH DN = [PH, ON, OD, DN, DD]
atComp PH DD = [OD]
       
atComp ON P  = [P, ON, OD]
atComp ON PH = [PH, ON, DN]
atComp ON ON = [I, P, PH, ON, OD, DN, DD]
atComp ON OD = [P, ON, OD]
atComp ON DN = [PH, ON, DN]
atComp ON DD = [ON]
       
atComp OD P  = [OD]
atComp OD PH = [PH, ON, OD, DN, DD]
atComp OD ON = [PH, ON, OD]
atComp OD OD = [I, P, PH, ON, OD]
atComp OD DN = [PH]
atComp OD DD = [PH]
       
atComp DN P  = [P, ON, OD, DN, DD]
atComp DN PH = [DN]
atComp DN ON = [P, ON, DN]
atComp DN OD = [P]
atComp DN DN = [I, P, PH, ON, DN]
atComp DN DD = [P]
       
atComp DD P  = [OD]
atComp DD PH = [DN]
atComp DD ON = [ON]
atComp DD OD = [P]
atComp DD DN = [PH]
atComp DD DD = [I]
\end{code}
%}}}

We now write some code to test the formulae of the introduction to this section:

\begin{code}
gMor atoms = mkSetMor () () atoms

rI  = gMor [I ]
rP  = gMor [P ]
rPH = gMor [PH]
rON = gMor [ON]
rOD = gMor [OD]
rDN = gMor [DN]
rDD = gMor [DD]

(&&&) = ra_meet ra_MereoG
(^^^) = ra_comp ra_MereoG
compl = ra_compl ra_MereoG
(|||) = ra_join ra_MereoG

rO = (rPH ^^^ rP) &&& compl rI
rH = compl (rP ||| rPH ||| rI)
rT = (rP ^^^ rPH) &&& compl rI

assert_G_TEST :: [([Char],[()],[SetMor () Atomset])] 
                    -> [([Char],[()],[SetMor () Atomset])]
assert_G_TEST =
  let rOmH = rO &&& rH
  in test (rON == (rOmH &&& rT)) [] [rON,rOmH &&& rT] "ON inconsistent" .
     let r = rOmH &&& compl rT in
     test (rOD == r) [] [rOD,r]  "OD inconsistent" .
     let r = compl rO &&& rT in
     test (rDN == r) [] [rDN,r] "DN inconsistent" . 
     let r = compl (rO ||| (rT ||| rI)) in
     test (rDD == r) [] [rDD,r] "DD inconsistent" .
     test False [] [rO] "this is ``O'':" .
     test False [] [rH] "this is ``#'':" .
     test False [] [rT] "this is ``T'':"
\end{code}
%
The result is as expected:
%
\begin{session}
Main> printAllTestResults assert_G_TEST
=== Test Start ===
this is ``O'':
Morphism: SetMor ({P, PH, ON, OD},(),())
this is ``#'':
Morphism: SetMor ({ON, OD, DN, DD},(),())
this is ``T'':
Morphism: SetMor ({P, PH, ON, DN},(),())
=== Test End   ===
\end{session}


%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:
