\subsection{N1}

The basic mereological qualifications to start with are
just four, namely
identity, {\it is-part-of}, and its converse as well as 
{\it disconnected}.
And there is just one object {\tt ()} in the base category of
the relation algebra N1,
resulting in a homogeneous relation algebra.

\noindent
We denote

     \ \hbox to2cm{1'\hfil by {\tt I}}

     \ \hbox to2cm{p\hfil by {\tt P}}

     \ \hbox to2cm{p\#\hfil by {\tt PH}} and

     \ \hbox to2cm{dc\hfil by {\tt DC}}

\noindent
to obtain correspondence with \cite{Duentsch-1998}.

\begin{code}
module MereoN1(aCat_MereoN1,aAll_MereoN1,ra_MereoN1) where

import RelAlg
import Atomset
import Matrix

import FiniteMaps
import Sets
\end{code}

\begin{code}
data Atomset = I | P | PH | DC   deriving (Eq, Ord, Show) 
atoms :: [Atomset]
atoms = [I, P, PH, DC]

aCat_MereoN1 :: ACat () Atomset
aCat_MereoN1 = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ _ _ _ -> True)
  ,acat_objects = [()]
  ,acat_atomset = (\ _ _ -> atoms)
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = (\ _ _ _ -> atComp)
  }

aAll_MereoN1 :: AAll () Atomset
aAll_MereoN1 = AAll
  {aall_acat = aCat_MereoN1
  ,aall_converse = (\ _ _ -> conv)
  }

ra_MereoN1 :: RA () (SetMor () Atomset)
ra_MereoN1 = atomsetRA aAll_MereoN1
\end{code}

\begin{code}
conv :: Atomset -> Atomset
conv P  = PH
conv PH = P 
conv x  = x
\end{code}

\begin{code}
atComp :: Atomset -> Atomset -> [Atomset]

atComp I  I  = [I]
atComp I  P  = [P]
atComp I  PH = [PH]
atComp I  DC = [DC]
       	  
atComp P  I  = [P]
atComp P  P  = [P]
atComp P  PH = atoms
atComp P  DC = [DC]
       
atComp PH I  = [PH]
atComp PH P  = [I, P, PH]
atComp PH PH = [PH]
atComp PH DC = [PH, DC]
       
atComp DC I  = [DC]
atComp DC P  = [P, DC]
atComp DC PH = [DC]
atComp DC DC = atoms
\end{code}



%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:
