\section{Non-Uniform Relation Algebras}\sectlabel{NonUniform}

One of the unexpected properties of relation algebras
we are going to provide examples for is non-uniformity.
It may happen that the composition of two universal relations
results in a non-universal relation.

\begin{code}
module NonUniform(aCat_NUW,aAll_NUW,ra_NUW
                 ,nuRA_0,shows_nuRA_0,nuRA_1,nuRA_1',shows_nuRA_1') where

import RelAlg
import Atomset
import A2
import Matrix

import Properties
import Product
import SubAlg

import FiniteMaps
import Sets
\end{code}
\ignore{Stand 29.06.98}

A simple example of a non-uniform relation algebra is the following:

\index{nuRA_*@{\texttt{nuRA\_*}}}%
\begin{code}
nuRA_0 = raMat raB [[],[()]]
\end{code}

This can be checked with:

\begin{center}
\verb|performAll ded_uniform_TEST (ra_ded nuRA_0)|
\end{center}

A direct definition of this can be displayed by calling
the following function,
evaluating e.g. ``\verb|putStr $ shows_nuRA_0 ""|'':

\index{shows_nuRA_*@{\texttt{shows\_nuRA\_*}}}%
\begin{code}
shows_nuRA_0 = let
    showsObj = (\i s -> "Obj" ++ i ++ s) . show . length . unVec;
    showsAtom a = ("At1"++);
    da = ra_distrAll nuRA_0
 in showsARA' "NU" id showsObj showsAtom (distrAll_aall da)
\end{code}

This example, however, includes a trivial homset
(i.e., with $\RO{} = \RL{}$).

\noindent
An example without trivial homsets may, for example be found in
Michael Winter's PhD thesis \cite[p. 24]{Winter-1998}.
It is a heterogeneous
relation algebra \emph{with non-trivial homsets}
with two objects:

\begin{code}
data Obj = A | B   deriving (Eq, Ord, Show)  
objseq = [A, B] 
\end{code}

Composition is designed so as to yield

\centerline{{\tt comp (A, B, [At1]) (B, A, [At1]) = (A, A,[At1])},}

which is properly contained in {\tt (A, A, [At1, At2])},
thus providing an example for
\BD
    \RL{\objA,\objB} \rcmp \RL{\objB,\objA}
  \neq
    \RL{\objA,\objA}
\enskip.
\ED
This relation algebra actually is a sub-algebra
of the product relation algebra of \verb|nuRA_0|
of the non-uniform relation algebra mentioned in \subsectref{uniform}
(that algebra features a trivial homset)
with itself, i.e., of the relation algebra

\begin{code}
nuRA_1 = raProd nuRA_0 nuRA_0
\end{code}

This sub-algebra eschews the object \texttt{(Vec [],Vec [])}
which has a trivial automorphism lattice,
but still exhibits non-uniformity;
as sub-algebra it is defined in the following way:

\begin{code}
nuRA_1' = let
   a' = (vec [()],vec [()])
   b' = (vec [()],vec [])
   sub = SubCat (listToSet [a',b']) zeroFM
 in sub_ra (cat_homset_close (ra_cat nuRA_1) sub) nuRA_1
\end{code}
Invoking the following (exported) function,
e.g. with ``\verb|putStr $ showsW1 ""|'',
prints a definition that is equivalent
to the manually generated definition below:

\begin{code}
shows_nuRA_1' = let
   so (x,y) = case unVec y of [] -> ("B" ++); _ -> ("A" ++)
   sa (x,y) = let ([l],_,_) = unMatMor x
              in case l of [True] -> ("At1" ++); _ -> ("At2" ++)
 in showsARA' "NuRA1a" id so sa (distrAll_aall (ra_distrAll nuRA_1'))
\end{code}

Here now the original definition:

\begin{code}
atoms :: Obj -> Obj -> [A2]
atoms A A = [At1, At2]
atoms _ _ = [At1]
\end{code}

\begin{code}
aCat_NUW :: ACat Obj A2
aCat_NUW = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ s t a -> a `elem` atoms s t)
  ,acat_objects = objseq
  ,acat_atomset = atoms
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = atComp
  }

aAll_NUW :: AAll Obj A2
aAll_NUW = AAll
  {aall_acat = aCat_NUW
  ,aall_converse = transpTab
  }

ra_NUW :: RA Obj (SetMor Obj A2)
ra_NUW = atomsetRA aAll_NUW
\end{code}


\ignore{
\noindent
It is possible to print an atomset element and the object names.
\begin{code}

atomToChar = \ x -> (case x of At1  -> "1"
                               At2  -> "2")

\end{code}
\begin{code}

objectToChar = \ x -> (case x of A  -> "A"
                                 B  -> "B")
atomSetToChar z = foldr (++) [] (map atomToChar z)

\end{code}
}%ignore
\begin{code}
transpTab :: Obj -> Obj -> A2 -> A2
transpTab _ _ x  = x
\end{code}
\begin{code}
atComp :: Obj -> Obj -> Obj -> A2 -> A2 -> [A2]

atComp A A A At1 At1 = [At1]
atComp A A A At2 At1 = []
atComp A A A At1 At2 = []
atComp A A A At2 At2 = [At2]

atComp A A B At1 At1 = [At1]
atComp A A B At2 At1 = []

atComp B A A At1 At1 = [At1]
atComp B A A At1 At2 = []

atComp B A B At1 At1 = [At1]

atComp A B A At1 At1 = [At1]

atComp _ _ _ At1 At1 = [At1]
\end{code}

%{{{ \ignore{both objects are products of themselves}
\ignore{
Interestingly, in this relation algebra,
both objects are products of themselves,
with universal relations as projections:

\begin{session}
Main> ded_NonemptyProducts (ra_ded ra_Winter)
[(A,A,A,SetMor ({At1, At2},A,A),SetMor ({At1, At2},A,A))
,(B,B,B,SetMor ({At1     },B,B),SetMor ({At1     },B,B))
]
\end{session}

Both these products are sharp.
}%ignore
%}}}

The object \verb|A| is a unit.


%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end: 


