
\subsection{P012}

%\subsection{Preliminaries}

\begin{code}
module P012(aCat_P012,aAll_P012,ra_P012
           ,all_B012,ra_B012,bToP012,pToB012,test_for_equivalence_012) where

import RelAlg
import Atomset
import A4
import Matrix

import FiniteMaps
import Sets
\end{code}

Let now {\tt P0, P1, P2}  be the objects of a category
and think of the powersets of  0, 1, or 2 atoms, respectively.
(Note that, as $\Bool\sp1, \Bool\sp2, \Bool\sp3, \dots$ are boolean lattices,
it will here be allowed, 
to consider the one-element set $\Bool\sp0$ as a boolean lattice, too.)

\begin{code}
data Obj = P0 | P1 | P2    deriving (Eq, Ord, Show) 
objseq = [P0, P1, P2] 
\end{code}
By source and target objects it is determined,
which atoms span the morphism set.

\begin{code}
aCat_P012 :: ACat Obj A4
aCat_P012 = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = isAtom
  ,acat_objects = objseq
  ,acat_atomset = atoms
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = atComp
  }

aAll_P012 :: AAll Obj A4
aAll_P012 = AAll
  {aall_acat = aCat_P012
  ,aall_converse = transpTab
  }

ra_P012 :: RA Obj (SetMor Obj A4)
ra_P012 = atomsetRA aAll_P012
\end{code}

\begin{code}
atoms :: Obj -> Obj -> [A4]
atoms P0 _  = []
atoms _  P0 = []
atoms P1 P1 = [At1]
atoms P2 P2 = [At1, At2, At3, At4]
atoms _  _  = [At1, At2]

isAtom :: Obj -> Obj -> A4 -> Bool
isAtom P0 _  _ = False
isAtom _  P0 _ = False
isAtom P1 P1 a = a == At1
isAtom P2 P2 _ = True
isAtom _  _  a = a == At1 || a == At2
\end{code}
\ignore{
\noindent
It is possible to print an atomset element and the object names.
\begin{code}
atomToChar = \ x -> (case x of At1  -> "1"
                               At2  -> "2"
                               At3  -> "3"
                               At4  -> "4")
\end{code}

\begin{code}
objectToChar = \ x -> (case x of P0  -> "P0"
                                 P1  -> "P1"
                                 P2  -> "P2")
atomSetToChar z = foldr (++) [] (map atomToChar z)
\end{code}
and in addition as \TeX-matrices.
\begin{code}
trenn = (\ x y -> x ++ ", " ++ y)
atomToTeXChar = \ x -> (case x of  At1  -> "{\\tt 1}"
                                   At2  -> "{\\tt 2}" 
                                   At3  -> "{\\tt 3}" 
                                   At4  -> "{\\tt 4}")
\end{code}

\begin{code}
objectToTeXChar = \ x -> (case x of P0  -> "{\\tt P0}"
                                    P1  -> "{\\tt P1}"
                                    P2  -> "{\\tt P2}")
\end{code}

\begin{code}
positions (x, y, m) |  (x == P0) && (y == P0)  = 1
                    |  (x == P0) && (y == P1)  = 2
                    |  (x == P1) && (y == P0)  = 2
                    |  (x == P1) && (y == P1)  = 2
                    |  (x == P2) && (y == P0)  = 1
                    |  (x == P0) && (y == P2)  = 4
                    |  (x == P2) && (y == P1)  = 2
                    |  (x == P1) && (y == P2)  = 4
                    |  (x == P1) && (y == P2)  = 4

\end{code}

\begin{code}
atomSetToTeXChar1 z = foldr (++) [] (map atomToChar z)
atomSetToTeXChar  (p, q, m) 
  | length k == 0 = (objectToTeXChar p) ++ "{\\tt [\\ \\ \\ \\ ]}" 
                                        ++ (objectToTeXChar q)
  | length k == 1 = (objectToTeXChar p) ++ "{\\tt [" ++ k ++ "\\ \\ \\ ]}"  
                                        ++ (objectToTeXChar q)
  | length k == 2 = (objectToTeXChar p) ++ "{\\tt [" ++ k ++ "\\ \\ ]}"  
                                        ++ (objectToTeXChar q)
  | length k == 3 = (objectToTeXChar p) ++ "{\\tt [" ++ k ++ "\\  ]}"  
                                        ++ (objectToTeXChar q)
  | length k == 4 = (objectToTeXChar p) ++ "{\\tt [" ++ k ++ "]}"  
                                        ++ (objectToTeXChar q)
 where k        = atomSetToTeXChar1 m
       rest p q = foldr (++) [] (take (positions (p, q, m)) (repeat "\\ "))
\end{code}
}%ignore
\noindent
The empty list {\tt []} of atoms will represent the 0-morphism 
while the respective (!)\ full list represents the 1-morphism.
\begin{code}
transpTab :: Obj -> Obj -> A4 -> A4
transpTab P2 P2 At2 = At3
transpTab P2 P2 At3 = At2
transpTab _  _  x   = x
\end{code}
\noindent
The transposition and composition tables are best understood,
when remembering matrices with positions numbered from the upper left
consecutively over the rows. So, e.g., position 4
in the {\tt P2} by {\tt P2} matrix identifies coefficient $(2,2)$. 
Multiplying in this case coefficient $(2,2)$ from the left
side to 
$(2,1)$ or $(2,2)$, contributes to the result with $(2,1)$ or $(2,2)$,
respectively.
\begin{code}
atComp :: Obj -> Obj -> Obj -> A4 -> A4 -> [A4]

atComp P0 _  _  _   _   = []
atComp _  _  P0 _   _   = []
atComp _  P0 _  _   _   = []

atComp _  _  _  At1 At1 = [At1]
atComp P2 P2 P2 At1 At2 = [At2]
atComp P2 P2 P2 At4 At3 = [At3]
atComp P2 P2 P2 At4 At4 = [At4]

atComp P2 P2 P2 At2 At3 = [At1]
atComp P2 P2 P2 At2 At4 = [At2]
atComp P2 P2 P2 At3 At1 = [At3]
atComp P2 P2 P2 At3 At2 = [At4]

atComp P2 P2 P1 At3 At1 = [At2]
atComp P2 P2 P1 At2 At2 = [At1]
atComp P2 P2 P1 At4 At2 = [At2]

atComp P1 P2 P2 At1 At2 = [At2]
atComp P1 P2 P2 At2 At3 = [At1]
atComp P1 P2 P2 At2 At4 = [At2]

atComp P2 P1 P2 At1 At2 = [At2]
atComp P2 P1 P2 At2 At1 = [At3]
atComp P2 P1 P2 At2 At2 = [At4]

atComp P1 P2 P1 At2 At2 = [At1]

atComp P1 P1 P2 At1 At2 = [At2]

atComp P2 P1 P1 At2 At1 = [At2]

atComp _  _  _  _   _   = []
\end{code}

\begin{code}
ra_B012 = raMat raB [[],[()],[(),()]]
all_B012 = ra_all ra_B012

bToPobj []    = P0
bToPobj [_]   = P1
bToPobj [_,_] = P2

pToBobj P0 = []
pToBobj P1 = [()]
pToBobj P2 = [(),()]

atMat P0 _  = []
atMat P1 P0 = [[]]
atMat P1 P1 = [[At1]]
atMat P1 P2 = [[At1,At2]]
atMat P2 P0 = [[],[]]
atMat P2 P1 = [[At1],[At2]]
atMat P2 P2 = [[At1,At2],[At3,At4]]

bToP012 = matBtoAtCat bToPobj atMat
pToB012 = atCatToMatB pToBobj atMat

test_for_equivalence_012 =
       let (t1,t2) = all_equiv_TESTS all_B012 (ra_all ra_P012) bToP012 pToB012
       in printTestResults t1 >> printTestResults t2
\end{code}

%%\bigskip
%%\noindent
%%It should be kept in mind that this section gives just one example.
%%In the Appendix, other interesting examples are given.
%%When loading the HUGS project, they may easily be taken
%%as a substitute for what has been written in this section.
%%Their structure is very similar so as to let the programs
%%in the sections to follow
%%work with them correctly.
%%In particular, when using {\tt P\_0\_1\_2\_3} instead, one will have the 
%%corresponding version for powersets on
%%$0, 1, 2, 3$-element set.



%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:
