
\subsection{P0123}

\begin{code}
module P0123(aCat_P0123,aAll_P0123,ra_P0123
           ,all_B0123,ra_B0123,bToP0123,pToB0123,test_for_equivalence_0123) where

import RelAlg
import Atomset
import A9
import Matrix

import FiniteMaps
import Sets
\end{code}

\noindent
The relation algebra considered here is a simple extension of that of 
Appendix 7
in as far as it also includes the powerset of 3 elements.
\begin{code}
data Obj = P0 | P1 | P2 | P3  deriving (Eq, Ord, Show) 
objseq = [P0, P1, P2, P3] 
\end{code}
\noindent
There are three source- and target-objects.
The morphisms between these are spanned by at most nine atoms.

\begin{code}
aCat_P0123 :: ACat Obj A9
aCat_P0123 = ac where
 ac = ACat
  {acat_isObj   = const True
  ,acat_isAtom  = (\ s t a -> a `elem` atoms s t)
  ,acat_objects = objseq
  ,acat_atomset = atoms
  ,acat_idmor   = acat_idmor_defaultM ac
  ,acat_comp    = atComp
  }

aAll_P0123 :: AAll Obj A9
aAll_P0123 = AAll
  {aall_acat = aCat_P0123
  ,aall_converse = conv
  }

ra_P0123 :: RA Obj (SetMor Obj A9)
ra_P0123 = atomsetRA aAll_P0123
\end{code}

\begin{code}
atoms :: Obj -> Obj -> [A9]
atoms P0 _  = []
atoms _  P0 = []

\end{code}
\begin{code}

atoms P1 P1 = [At1]
atoms P1 P2 = [At1, At2]
atoms P2 P1 = [At1, At2]
atoms P2 P2 = [At1, At2, At3, At4]

\end{code}
\begin{code}

atoms P3 P1 = [At1, At2, At3]
atoms P1 P3 = [At1, At2, At3]
atoms P3 P2 = [At1, At2, At3, At4, At5, At6]
atoms P2 P3 = [At1, At2, At3, At4, At5, At6]
atoms P3 P3 = [At1, At2, At3, At4, At5, At6, At7, At8, At9]

\end{code}

\begin{code}
conv :: Obj -> Obj -> A9 -> A9
conv P2 P2 At2 = At3
conv P2 P2 At3 = At2
conv P3 P2 At2 = At4
conv P3 P2 At3 = At2
conv P3 P2 At4 = At5
conv P3 P2 At5 = At3

conv P2 P3 At2 = At3
conv P2 P3 At3 = At5
conv P2 P3 At4 = At2
conv P2 P3 At5 = At4

conv P3 P3 At2 = At4
conv P3 P3 At3 = At7
conv P3 P3 At4 = At2
conv P3 P3 At6 = At8
conv P3 P3 At7 = At3
conv P3 P3 At8 = At6
conv _  _  x   = x
\end{code}

\begin{code}
atComp :: Obj -> Obj -> Obj -> A9 -> A9 -> [A9]
\end{code}

\begin{code}
atComp P0 _  _  _   _   = []
atComp _  _  P0 _   _   = []
atComp _  P0 _  _   _   = []

\end{code}

\begin{code}
atComp _  _  _  At1 At1 = [At1]
atComp P1 P2 P1 At2 At2 = [At1]
atComp P1 P2 P1 _   _   = []
atComp P1 P1 P2 At1 x   = [x]
\end{code}

\begin{code}
atComp P2 P1 P1 x   At1 = [x]
atComp P2 P1 P2 At1 At2 = [At2]
atComp P2 P1 P2 At2 At1 = [At3]
atComp P2 P1 P2 At2 At2 = [At4]
\end{code}

\begin{code}
atComp P2 P2 P1 At3 At1 = [At2]
atComp P2 P2 P1 At2 At2 = [At1]
atComp P2 P2 P1 At4 At2 = [At2]

atComp P1 P2 P2 At1 At2 = [At2]
atComp P1 P2 P2 At2 At3 = [At1]
atComp P1 P2 P2 At2 At4 = [At2]

atComp P2 P2 P2 At1 At2 = [At2]
atComp P2 P2 P2 At2 At3 = [At1]
atComp P2 P2 P2 At2 At4 = [At2]

atComp P2 P2 P2 At3 At1 = [At3]
atComp P2 P2 P2 At3 At2 = [At4]
atComp P2 P2 P2 At4 At3 = [At3]
atComp P2 P2 P2 At4 At4 = [At4]

atComp P3 P1 P1 x   At1 = [x]
atComp P3 P1 P2 At1 At2 = [At2]
atComp P3 P1 P2 At2 At1 = [At3]
atComp P3 P1 P2 At2 At2 = [At4]
atComp P3 P1 P2 At3 At1 = [At5]
atComp P3 P1 P2 At3 At2 = [At6]

atComp P3 P1 P3 At1 At2 = [At2]
atComp P3 P1 P3 At1 At3 = [At3]
atComp P3 P1 P3 At2 At1 = [At4]

atComp P3 P1 P3 At2 At2 = [At5]
atComp P3 P1 P3 At2 At3 = [At6]
atComp P3 P1 P3 At3 At1 = [At7]
atComp P3 P1 P3 At3 At2 = [At8]
atComp P3 P1 P3 At3 At3 = [At9]

atComp P3 P2 P1 At2 At2 = [At1]
atComp P3 P2 P1 At3 At1 = [At2]
atComp P3 P2 P1 At4 At2 = [At2]
atComp P3 P2 P1 At5 At1 = [At3]
atComp P3 P2 P1 At6 At2 = [At3]

atComp P3 P2 P2 At1 At2 = [At2]
atComp P3 P2 P2 At2 At3 = [At1]
atComp P3 P2 P2 At2 At4 = [At2]
atComp P3 P2 P2 At3 At1 = [At3]
atComp P3 P2 P2 At3 At2 = [At4]
atComp P3 P2 P2 At4 At3 = [At3]
atComp P3 P2 P2 At4 At4 = [At4]
atComp P3 P2 P2 At5 At1 = [At5]
atComp P3 P2 P2 At5 At2 = [At6]
atComp P3 P2 P2 At6 At3 = [At5]
atComp P3 P2 P2 At6 At4 = [At6]

atComp P3 P3 P1 At2 At2 = [At1]
atComp P3 P3 P1 At3 At3 = [At1]
atComp P3 P3 P1 At4 At1 = [At2]
atComp P3 P3 P1 At5 At2 = [At2]
atComp P3 P3 P1 At6 At3 = [At2]
atComp P3 P3 P1 At7 At1 = [At3]
atComp P3 P3 P1 At8 At2 = [At3]
atComp P3 P3 P1 At9 At3 = [At3]

atComp P3 P3 P2 At1 At2 = [At2]
atComp P3 P3 P2 At2 At3 = [At1]
atComp P3 P3 P2 At2 At4 = [At2]
atComp P3 P3 P2 At3 At5 = [At1]
atComp P3 P3 P2 At3 At6 = [At2]
atComp P3 P3 P2 At4 At1 = [At3]
atComp P3 P3 P2 At4 At2 = [At4]
atComp P3 P3 P2 At5 At3 = [At3]

atComp P3 P3 P2 At5 At4 = [At4]
atComp P3 P3 P2 At6 At5 = [At3]
atComp P3 P3 P2 At6 At6 = [At4]
atComp P3 P3 P2 At7 At1 = [At5]
atComp P3 P3 P2 At7 At2 = [At6]
atComp P3 P3 P2 At8 At3 = [At5]
atComp P3 P3 P2 At8 At4 = [At6]
atComp P3 P3 P2 At9 At5 = [At5]
atComp P3 P3 P2 At9 At6 = [At6]

atComp P3 P2 P3 At1 At2 = [At2]
atComp P3 P2 P3 At1 At3 = [At3]
atComp P3 P2 P3 At2 At4 = [At1]
atComp P3 P2 P3 At2 At5 = [At2]
atComp P3 P2 P3 At2 At6 = [At3]
atComp P3 P2 P3 At3 At1 = [At4]
atComp P3 P2 P3 At3 At2 = [At5]
atComp P3 P2 P3 At3 At3 = [At6]

atComp P3 P2 P3 At4 At4 = [At4]
atComp P3 P2 P3 At4 At5 = [At5]
atComp P3 P2 P3 At4 At6 = [At6]
atComp P3 P2 P3 At5 At1 = [At7]
atComp P3 P2 P3 At5 At2 = [At8]
atComp P3 P2 P3 At5 At3 = [At9]
atComp P3 P2 P3 At6 At4 = [At7]
atComp P3 P2 P3 At6 At5 = [At8]
atComp P3 P2 P3 At6 At6 = [At9]

atComp P3 P3 P3 At1 At2 = [At2]
atComp P3 P3 P3 At1 At3 = [At3]
atComp P3 P3 P3 At2 At4 = [At1]
atComp P3 P3 P3 At2 At5 = [At2]
atComp P3 P3 P3 At2 At6 = [At3]

atComp P3 P3 P3 At3 At7 = [At1]
atComp P3 P3 P3 At3 At8 = [At2]
atComp P3 P3 P3 At3 At9 = [At3]

atComp P3 P3 P3 At4 At1 = [At4]
atComp P3 P3 P3 At4 At2 = [At5]
atComp P3 P3 P3 At4 At3 = [At6]

atComp P3 P3 P3 At5 At4 = [At4]
atComp P3 P3 P3 At5 At5 = [At5]
atComp P3 P3 P3 At5 At6 = [At6]

atComp P3 P3 P3 At6 At7 = [At4]
atComp P3 P3 P3 At6 At8 = [At5]
atComp P3 P3 P3 At6 At9 = [At6]

atComp P3 P3 P3 At7 At1 = [At7]
atComp P3 P3 P3 At7 At2 = [At8]
atComp P3 P3 P3 At7 At3 = [At9]

atComp P3 P3 P3 At8 At4 = [At7]
atComp P3 P3 P3 At8 At5 = [At8]
atComp P3 P3 P3 At8 At6 = [At9]

atComp P3 P3 P3 At9 At7 = [At7]
atComp P3 P3 P3 At9 At8 = [At8]
atComp P3 P3 P3 At9 At9 = [At9]

atComp P1 P3 P1 At2 At2 = [At1]
atComp P1 P3 P1 At3 At3 = [At1]

atComp P1 P3 P2 At1 At2 = [At2]
atComp P1 P3 P2 At2 At3 = [At1]
atComp P1 P3 P2 At2 At4 = [At2]
atComp P1 P3 P2 At3 At5 = [At1]
atComp P1 P3 P2 At3 At6 = [At2]

atComp P1 P3 P3 At1 At2 = [At2]
atComp P1 P3 P3 At1 At3 = [At3]
atComp P1 P3 P3 At2 At4 = [At1]
atComp P1 P3 P3 At2 At5 = [At2]
atComp P1 P3 P3 At2 At6 = [At3]
atComp P1 P3 P3 At3 At7 = [At1]
atComp P1 P3 P3 At3 At8 = [At2]
atComp P1 P3 P3 At3 At9 = [At3]

atComp P2 P3 P1 At2 At2 = [At1]
atComp P2 P3 P1 At3 At3 = [At1]
atComp P2 P3 P1 At4 At1 = [At2]
atComp P2 P3 P1 At5 At2 = [At2]
atComp P2 P3 P1 At6 At3 = [At2]

atComp P2 P3 P2 At1 At2 = [At2]
atComp P2 P3 P2 At2 At3 = [At1]
atComp P2 P3 P2 At2 At4 = [At2]
atComp P2 P3 P2 At3 At5 = [At1]
atComp P2 P3 P2 At3 At6 = [At2]

atComp P2 P3 P2 At4 At1 = [At3]
atComp P2 P3 P2 At4 At2 = [At4]
atComp P2 P3 P2 At5 At3 = [At3]
atComp P2 P3 P2 At5 At4 = [At4]
atComp P2 P3 P2 At6 At5 = [At3]
atComp P2 P3 P2 At6 At6 = [At4]

atComp P2 P3 P3 At1 At2 = [At2]
atComp P2 P3 P3 At1 At3 = [At3]
atComp P2 P3 P3 At2 At4 = [At1]
atComp P2 P3 P3 At2 At5 = [At2]
atComp P2 P3 P3 At2 At6 = [At3]
atComp P2 P3 P3 At3 At7 = [At1]
atComp P2 P3 P3 At3 At8 = [At2]
atComp P2 P3 P3 At3 At9 = [At3]

atComp P2 P3 P3 At4 At1 = [At4]
atComp P2 P3 P3 At4 At2 = [At5]
atComp P2 P3 P3 At4 At3 = [At6]
atComp P2 P3 P3 At5 At4 = [At4]
atComp P2 P3 P3 At5 At5 = [At5]
atComp P2 P3 P3 At5 At6 = [At6]
atComp P2 P3 P3 At6 At7 = [At4]
atComp P2 P3 P3 At6 At8 = [At5]
atComp P2 P3 P3 At6 At9 = [At6]

atComp P1 P1 P3 At1 x   = [x]

atComp P2 P1 P3 At1 At2 = [At2]
atComp P2 P1 P3 At1 At3 = [At3]
atComp P2 P1 P3 At2 At1 = [At4]
atComp P2 P1 P3 At2 At2 = [At5]
atComp P2 P1 P3 At2 At3 = [At6]

atComp P1 P2 P3 At1 At2 = [At2]
atComp P1 P2 P3 At1 At3 = [At3]
atComp P1 P2 P3 At2 At4 = [At1]
atComp P1 P2 P3 At2 At5 = [At2]
atComp P1 P2 P3 At2 At6 = [At3]

atComp P2 P2 P3 At1 At2 = [At2]
atComp P2 P2 P3 At1 At3 = [At3]
atComp P2 P2 P3 At2 At4 = [At1]
atComp P2 P2 P3 At2 At5 = [At2]
atComp P2 P2 P3 At2 At6 = [At3]
atComp P2 P2 P3 At3 At1 = [At4]
atComp P2 P2 P3 At3 At2 = [At5]
atComp P2 P2 P3 At3 At3 = [At6]
atComp P2 P2 P3 At4 At4 = [At4]
atComp P2 P2 P3 At4 At5 = [At5]
atComp P2 P2 P3 At4 At6 = [At6]

atComp _  _  _  _   _   = []
\end{code}

\begin{code}
ra_B0123 = raMat raB [[],[()],[(),()],[(),(),()]]
all_B0123 = ra_all ra_B0123

bToPobj []      = P0
bToPobj [_]     = P1
bToPobj [_,_]   = P2
bToPobj [_,_,_] = P3

pToBobj P0 = []
pToBobj P1 = [()]
pToBobj P2 = [(),()]
pToBobj P3 = [(),(),()]

atMat P0 _  = []
atMat P1 P0 = [[]]
atMat P1 P1 = [[At1]]
atMat P1 P2 = [[At1,At2]]
atMat P1 P3 = [[At1,At2,At3]]
atMat P2 P0 = [[],[]]
atMat P2 P1 = [[At1],[At2]]
atMat P2 P2 = [[At1,At2],[At3,At4]]
atMat P2 P3 = [[At1,At2,At3],[At4,At5,At6]]
atMat P3 P0 = [[],[],[]]
atMat P3 P1 = [[At1],[At2],[At3]]
atMat P3 P2 = [[At1,At2],[At3,At4],[At5,At6]]
atMat P3 P3 = [[At1,At2,At3],[At4,At5,At6],[At7,At8,At9]]

bToP0123 = matBtoAtCat bToPobj atMat
pToB0123 = atCatToMatB pToBobj atMat

test_for_equivalence_0123 =
     all_equiv_perform all_B0123 (ra_all ra_P0123) bToP0123 pToB0123
\end{code}



%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end:
