\section{Product Algebras}

The construction of product algebras\index{product algebras},
where all operations are defined component-wise,
is completely straightforward,
only requiring an appropriate set of pair lifting functions
(\verb|prodF|, \verb|prodFF|, \verb|cprodFF|, \verb|prodFFF|, \verb|cprodFFF|)
all defined in \sectref{ExtPrel}.
We therefore do not need to comment on the individual steps of the construction.

\begin{code}
module Product where

import ExtPrel
import RelAlg
\end{code}

\index{catProd@{\texttt{catProd}}}%
\begin{code}
catProd :: Cat obj1 mor1 -> Cat obj2 mor2 -> Cat (obj1,obj2) (mor1,mor2)
catProd c1 c2 = Cat
  {cat_isObj   = pairAnd  . prodF    (cat_isObj   c1)   (cat_isObj   c2)
  ,cat_isMor   = pairAnd  `cprodFFF` (cat_isMor   c1) $ (cat_isMor   c2)
  ,cat_objects = listProd            (cat_objects c1,    cat_objects c2)
  ,cat_homset  = listProd `cprodFF`  (cat_homset  c1) $ (cat_homset  c2)
  ,cat_source  =            prodF    (cat_source  c1)   (cat_source  c2)
  ,cat_target  =            prodF    (cat_target  c1)   (cat_target  c2)
  ,cat_idmor   =            prodF    (cat_idmor   c1)   (cat_idmor   c2)
  ,cat_comp    =            prodFF   (cat_comp    c1)   (cat_comp    c2)
  }
\end{code}

\index{allProd@{\texttt{allProd}}}%
\begin{code}
allProd :: All obj1 mor1 -> All obj2 mor2 -> All (obj1,obj2) (mor1,mor2)
allProd c1 c2 = All
  {all_cat      = catProd (all_cat c1) (all_cat c2)
  ,all_converse =           prodF   (all_converse c1)   (all_converse c2)
  ,all_meet     =           prodFF  (all_meet     c1)   (all_meet     c2)
  ,all_incl     = pairAnd `cprodFF` (all_incl     c1) $ (all_incl     c2)
  }
\end{code}

\index{distrAllProd@{\texttt{distrAllProd}}}%
\begin{code}
distrAllProd :: DistrAll obj1 mor1 -> DistrAll obj2 mor2 ->
                DistrAll (obj1,obj2) (mor1,mor2)
distrAllProd c1 c2 = let mkAts1 b = map (\a -> (a,b))
                         mkAts2 b = map (\a -> (b,a))
 in DistrAll
  {distrAll_all     = allProd (distrAll_all c1) (distrAll_all c2)
  ,distrAll_bottom  = prodFF (distrAll_bottom  c1) (distrAll_bottom  c2)
  ,distrAll_join    = prodFF (distrAll_join    c1) (distrAll_join    c2)
  ,distrAll_atomset = (\ (s1,s2) (t1,t2) ->
        mkAts1 (distrAll_bottom c2 s2 t2) (distrAll_atomset c1 s1 t1)
     ++ mkAts2 (distrAll_bottom c1 s1 t1) (distrAll_atomset c2 s2 t2))
  ,distrAll_atoms   = (\ (f1,f2) ->
        mkAts1 (distrAll_bot    c2 f2   ) (distrAll_atoms   c1 f1   )
     ++ mkAts2 (distrAll_bot    c1 f1   ) (distrAll_atoms   c2 f2   ))
  }
\end{code}

\index{divAllProd@{\texttt{divAllProd}}}%
\begin{code}
divAllProd :: DivAll obj1 mor1 -> DivAll obj2 mor2 ->
              DivAll (obj1,obj2) (mor1,mor2)
divAllProd c1 c2 = DivAll
  {divAll_distrAll = distrAllProd (divAll_distrAll c1) (divAll_distrAll c2)
  ,divAll_rres     = prodFF (divAll_rres c1) (divAll_rres c2)
  ,divAll_lres     = prodFF (divAll_lres c1) (divAll_lres c2)
  ,divAll_syq      = prodFF (divAll_syq  c1) (divAll_syq  c2)
  }
\end{code}

\index{dedProd@{\texttt{dedProd}}}%
\begin{code}
dedProd :: Ded obj1 mor1 -> Ded obj2 mor2 -> Ded (obj1,obj2) (mor1,mor2)
dedProd c1 c2 = Ded
  {ded_divAll = divAllProd (ded_divAll c1) (ded_divAll c2)
  ,ded_top    = prodFF (ded_top c1) (ded_top c2)
  }
\end{code}

\index{raProd@{\texttt{raProd}}}%
\begin{code}
raProd :: RA obj1 mor1 -> RA obj2 mor2 -> RA (obj1,obj2) (mor1,mor2)
raProd c1 c2 = RA
  {ra_ded   = dedProd (ra_ded c1) (ra_ded c2)
  ,ra_compl = prodF (ra_compl c1) (ra_compl c2)
  }
\end{code}


%% Local variables:
%% folded-file: t
%% fold-internal-margins: 0
%% eval: (fold-set-marks "%{{{ " "%}}}")
%% eval: (fold-whole-buffer)
%% end: 


