Compiler Toolkit: Sets

Author : Manuel M. T. Chakravarty
Created: 2 February 99

Version $Revision: 1.3 $ from $Date: 2000/03/20 16:51:35 $

Copyright (c) 1999 Manuel M. T. Chakravarty

This file is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This file is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

DESCRIPTION ---------------------------------------------------------------

This module provides sets as an abstract data type.

DOCU ----------------------------------------------------------------------

language: Haskell 1.4

* This implementation currently just instantiates `FiniteMaps'.

TODO ----------------------------------------------------------------------

> module Sets (Set, zeroSet, unitSet, listToSet, joinSet, sizeSet, isZeroSet,
>              addToSet,
>              delFromSet, diffSet, intersectSet, mapSet, foldSet, filterSet,
>              elemSet, toListSet,
>              domFM, ranFM, readsSet)
> where

> import FiniteMaps (FiniteMap, zeroFM, unitFM, listToFM, joinFM,
>                    joinCombFM, sizeFM, isZeroFM, addToFM, delFromFM, diffFM,
>                    intersectFM, foldFM, filterFM, lookupFM, lookupDftFM,
>                    toListFM, mapFM)

a set is a finite map with a trivial image (EXPORTED ABSTRACT)

> newtype (Ord a) =>
>           Set a = Set (FiniteMap a ())

> domFM :: Ord a => FiniteMap a b -> Set a
> domFM fm = Set (mapFM (\ k e -> ()) fm)

> ranFM :: (Ord a, Ord b) => FiniteMap a b -> Set b
> ranFM = foldFM (const addToSet) zeroSet

> instance (Show a, Ord a) => Show (Set a) where
>   showsPrec = toShowS                -- defined below

> instance (Read a, Ord a) => Read (Set a) where
>   readsPrec _ = readsSet reads               -- defined below

> zeroSet :: Ord a => Set a
> zeroSet  = Set zeroFM

> unitSet   :: Ord a => a -> Set a
> unitSet x  = Set $ unitFM x ()

> listToSet :: Ord a => [a] -> Set a
> listToSet  = Set . listToFM . (map (\x -> (x, ())))

> sizeSet         :: Ord a => Set a -> Int
> sizeSet (Set s)  = sizeFM s

> isZeroSet         :: Ord a => Set a -> Bool
> isZeroSet (Set s)  = isZeroFM s

> addToSet           :: Ord a => a -> Set a -> Set a
> addToSet x (Set s)  = Set $ addToFM x () s

> delFromSet           :: Ord a => a -> Set a -> Set a
> delFromSet x (Set s)  = Set $ delFromFM x s

> joinSet                 :: Ord a => Set a -> Set a -> Set a
> joinSet (Set s) (Set t)  = Set $ joinFM s t

> joinSets                :: Ord a => [Set a] -> Set a
> joinSets [] = zeroSet
> joinSets l = foldr1 joinSet l

> diffSet                        :: Ord a => Set a -> Set a -> Set a
> diffSet (Set s) (Set t)  = Set $ diffFM s t

> intersectSet                 :: Ord a => Set a -> Set a -> Set a
> intersectSet (Set s) (Set t)  = Set $ intersectFM s t

> mapSet           :: (Ord a, Ord b) => (a -> b) -> Set a -> Set b
> mapSet f (Set s)  = Set $
>                     (listToFM . map (\(x, _) -> (f x, ())) . toListFM) s

> foldSet             :: Ord a => (a -> b -> b) -> b -> Set a -> b
> foldSet f z (Set s)  = foldFM (\x _ y -> f x y) z s

> filterSet           :: Ord a => (a -> Bool) -> Set a -> Set a
> filterSet p (Set s)  = Set $ filterFM (\x _ -> p x) s

> elemSet           :: Ord a => a -> Set a -> Bool
> elemSet x (Set s)  = case lookupFM s x of
>                          Nothing -> False
>                          Just _  -> True

> toListSet         :: Ord a => Set a -> [a]
> toListSet (Set s)  = (map fst . toListFM) s

pretty print routine (used as a method in the `Set' instance of `Show')

> toShowS           :: (Show a, Ord a) => Int -> Set a -> ShowS
> toShowS _ (Set s)  = showString "{" . format (toListFM s) . showString "}"
>                      where
>                        format []     = showString ""
>                        format [(x,_)]    = shows x
>                        format ((x,_):xs) = shows x . showString ", " . format xs

> readsSet :: (Ord a) => ReadS a -> ReadS (Set a)
> readsSet reads =  map (\(l,rest) -> (listToSet l, rest)) . readSetList
>  where readSetList = readParen False (\r -> [pr | ("{",s) <- lex r,
>                                                   pr      <- readl s ])
>                      where readl  s = [([],t)   | ("]",t) <- lex s] ++
>                      			[(x:xs,u) | (x,t)   <- reads s,
>                      				    (xs,u)  <- readl' t]
>                      	     readl' s = [([],t)   | ("}",t) <- lex s] ++
>                      			[(x:xs,v) | (",",t) <- lex s,
>                      				    (x,u)   <- reads t,
>                      				    (xs,v)  <- readl' u]
