\ignore{
\begin{code}
{-# LANGUAGE PolyKinds, DataKinds, TypeOperators #-}

module TypeComputation.TypeLits (
  module TypeComputation.TypeLits,
  Nat, KnownNat, Symbol, KnownSymbol, natVal, symbolVal
  ) where 

import GHC.TypeLits (Nat, KnownNat, Symbol, KnownSymbol, 
                     natVal, symbolVal)

\end{code}
}

\subsection{Type literals}\label{sec:TypeLits}

The purpose of this module is to overload the operators defined in \cod{GHC.TypeLits}.
Since arithmetic with naturals is compiler magic, it isn't possible to import \cod{GHC.TypeLits}
while hiding the type operators - the compiler will complain the module doesn't export them.

We later define more general arithmetic operators with the same names, and have an instance for \cod{Nat}. 

\begin{code}

import qualified GHC.TypeLits as TL 

type NatLTEQ  a b = a TL.<=? b
type NatPlus  a b = a TL.+ b
type NatMinus a b = a TL.- b
type NatTimes a b = a TL.* b
type NatPow   a b = a TL.^ b

\end{code}
