\include{preamble}
\begin{document}

This module contains randomly generated tests for arithmetic of nats, floats, and ints. 
\begin{code}
{-# LANGUAGE TemplateHaskell, CPP, DataKinds #-}
{-# OPTIONS_GHC -fno-warn-unused-imports -ftype-function-depth=500 #-}
module Test where 

import TypeComputation.TH.Random
import Text.Printf
import TypeComputation.Numeric.Integer 
import TypeComputation.Numeric.Natural 
import TypeComputation.Numeric.FloatingPoint
import TypeComputation.Class 


sat :: (Show a, Eq a) => String -> [(String, String, a, a)] -> IO ()
sat st xs = case filter (\(_, _, a, b) -> a /= b) xs of 
              [] -> printf "%s (%d tests): Success\n" st (length xs)
              fs -> printf "%s (%d tests): Failure -\n%s\n" st (length xs) (unlines $ map s fs)
  where s (s0, s1, a, b) = concat ["    ", s0, ";", s1, " - Expecting ", show b, ", got ", show a]

\end{code}
We have to use CPP because template haskell doesn't allow local declarations in splices, so `let num_tests = 7 in ...' doesn't work.
The typechecker will consume a lot of memory, especially for floating point stuff, and sometimes it just crashes with
  ghc.exe: internal error: scavenge_one: strange object 510051
      (GHC version 7.8.20140130 for x86_64_unknown_mingw32)
So compiling these tests is pretty much up to chance. But it seems that when the test fails, it isn't due to 
our code failing. 
\begin{code}
#define NUM_TESTS_F 50
#define NUM_TESTS_N 200
#define NUM_TESTS_I 200


main :: IO ()
main = do 
  sat "Nat/addition"       $(testRandomNats addTest     NUM_TESTS_N 0 100000 []) 
  sat "Nat/multiplication" $(testRandomNats multTest    NUM_TESTS_N 0 100000 [])
  sat "Nat/mult-nz"        $(testRandomNats multNZTest  NUM_TESTS_N 1 100000 [])
  sat "Nat/comparison"     $(testRandomNats compareTest NUM_TESTS_N 0 100000 [])  

  sat "Int/addition"       $(testRandomInts addTest     NUM_TESTS_I (-100000) 100000 []) 
  sat "Int/subtraction"    $(testRandomInts subTest     NUM_TESTS_I (-100000) 100000 []) 
  sat "Int/multiplication" $(testRandomInts multTest    NUM_TESTS_I (-100000) 100000 [])
  sat "Int/mult-nz"        $(testRandomInts multNZTest  NUM_TESTS_I (-100000) 100000 [0])
  sat "Int/comparison"     $(testRandomInts compareTest NUM_TESTS_I (-100000) 100000 [])  

  sat "Float/addition"       $(testRandomFloats addTest     NUM_TESTS_F (-1000) 1000 []) 
  sat "Float/subtraction"    $(testRandomFloats subTest     NUM_TESTS_F (-1000) 1000 [])  
  sat "Float/multiplication" $(testRandomFloats multTest    NUM_TESTS_F (-1000) 1000 []) 
  sat "Float/comparison"     $(testRandomFloats compareTest NUM_TESTS_F (-1000) 1000 [])

  -- mult-nz almost always fails due to repeating fractions
  -- sat "Float/mult-nz"        $(testRandomFloatsList multNZTest NUM_TESTS_F $ [(n,0) | n <- [-1000 .. -1] ++ [1 .. 1000]]  )


\end{code}
\end{document}
