
\ignore{
\begin{code}
{-# LANGUAGE 
    MultiParamTypeClasses
  , NullaryTypeClasses
  , TypeFamilies 
  , ConstraintKinds
  , UndecidableInstances
  , EmptyDataDecls
  , PolyKinds
  #-}

module TypeComputation.Error 
  ( Always, Never', Never, never, always, 
    Less_Than, Greater_Than, Equal_To, Less_Than_Or_Equal, 
    Greater_Than_Or_Equal, Not_Equal_To, Not_Equal_To_Zero, Equal_To_Zero,
    DualUnits, AtomicSubframe
   ) where 
         
\end{code}
}    

\section{Generating good errors}\label{sec:Error}

Types used to generate human readable errors. These are written in such a way that
a user cannot define erroneous instances in other places.


The class \cod{Always} is a constraint which is always satisfied.

The class \cod{Never} is a constraint which is never satisfied.
\cod{Never} cannot have a valid instance since the instance which is already written
will never be valid, and another instance cannot be defined.
\begin{code}

data T

class Always 
instance Always 

type family Never' t where 
  Never' T = Always 

class Never
instance Never' () => Never 

never :: Never => a -> ()
never = const ()

always :: Always => a -> ()
always = const ()

\end{code}
Instead of producing an error like \cod{Couldn't match True with False}
the user sees \cod{No instance for Less_Than x y}.

\cod{Less_Than} behaves as a type class but is written as a closed type family
so that no valid instance can ever be defined. \cod{Less_Than a b} is a constraint which always fails.
\begin{code}

type family Less_Than (a :: k0) (b :: k1)             where Less_Than             T T = Never 
type family Greater_Than (a :: k0) (b :: k1)          where Greater_Than          T T = Never
type family Equal_To (a :: k0) (b :: k1)              where Equal_To              T T = Never  
type family Less_Than_Or_Equal (a :: k0) (b :: k1)    where Less_Than_Or_Equal    T T = Never  
type family Greater_Than_Or_Equal (a :: k0) (b :: k1) where Greater_Than_Or_Equal T T = Never  
type family Not_Equal_To (a :: k0) (b :: k1)          where Not_Equal_To          T T = Never  

type family Not_Equal_To_Zero (a :: k0)       where Not_Equal_To_Zero       T = Never  
type family Equal_To_Zero (a :: k0)           where Equal_To_Zero           T = Never  



\end{code}
Miscellaneous error classes used in other modules. 
\begin{code}

type family AtomicSubframe (x :: k) (xs :: k0) where 
  AtomicSubframe T T = Never 

type family DualUnits (a :: k0) (b :: k1) where 
  DualUnits T T = Never 

\end{code}
