
\ignore{
\begin{code}
{-# LANGUAGE 
    FunctionalDependencies
  , FlexibleInstances
  , ScopedTypeVariables
  , UndecidableInstances
  , TypeFamilies 
  , FlexibleContexts
  , ConstraintKinds
  , GADTs
  , RankNTypes
  , TypeOperators
  , ConstraintKinds
  , PolyKinds
  , DataKinds
  #-}

module TypeComputation.List where

import GHC.TypeLits 

\end{code}
}

\subsection{Type level lists}\label{sec:TypeList}

Basic operations type level lists.

\begin{code}

type family Fst a where 
  Fst (a,b) = a
type family Snd a where 
  Snd (a,b) = b

infixr 5 :&
data List xs where 
  Nil  :: List '[]
  (:&) :: x -> List xs -> List (x ': xs)

type family Reverse (xs :: [k]) :: [k] where 
  Reverse '[] = '[]
  Reverse (x ': xs) = Reverse xs ++ '[x]

type family Length (xs :: [k]) :: Nat where 
  Length '[] = 0
  Length (x ': xs) = 1 + Length xs

type family (++) (a :: [k]) (b :: [k]) :: [k] where 
  '[] ++ x = x
  (x ': xs) ++ y = x ': (xs ++ y)

type family Elem (a :: k) (xs :: [k]) where 
  Elem x '[]       = False
  Elem x (x ': xs) = True
  Elem y (x ': xs) = Elem y xs 

\end{code}
