\ignore{
\begin{code}
{-# LANGUAGE 
    FunctionalDependencies,
    FlexibleInstances,
    ScopedTypeVariables,
    UndecidableInstances,
    TypeFamilies ,
    FlexibleContexts,
    ConstraintKinds,
    GADTs,
    RankNTypes,
    ImpredicativeTypes,
    IncoherentInstances,
    TypeOperators,
    ConstraintKinds,
    DeriveDataTypeable,
    InstanceSigs
    #-}
    
module TypeLevelList where
import GHC.Prim (Constraint)
import Data.Typeable

\end{code}
}

\section{Type level lists}\label{sec:TLL}
We define type level lists and operations on type lists that are commonly used on data level lists. 
\begin{code}
class TList a
instance (TList b) => TList (a :$ b)
instance TList T

infixr :$
data (:$) a b = (:$) a b deriving Typeable
data T = T deriving Typeable

class TBool a
instance TBool TTrue
instance TBool TFalse
data TFalse 
data TTrue

instance Show TFalse where show _ = "TFalse"
instance Show TTrue where show _ = "TTrue"

\end{code}
And some test lists and their data equivalents.
\begin{code}
u = undefined
tlist2 = u :: ( (A :$ B :$ C :$ T) :$ (D :$ E :$ F :$ T) :$ T )

\end{code}
And some dummy types for testing and such.
\begin{code}
data A = A; data B = B; data C = C; data D = D; data E = E; data F = F; data G = G; data H = H; data I = I; data J = J; data K = K; data L = L; data M = M; 
data N = N; data O = O; data P = P; data Q = Q; data R = R; data S = S; {- data T = T; -} data U = U; data V = V; data W = W; data X = X; data Y = Y; data Z = Z;



\end{code}
``Function application'' -- unfortunately can't be used infix in a readable way.
What we are saying is that the constraint h is the same as applying g then f in sequence.
It also isn't very useful, at least not yet.
\begin{code}
class (:.) (f :: * -> * -> Constraint) (g :: * -> * -> Constraint) (h :: * -> * -> Constraint) | f g -> h
instance (g inp gout, f gout out, h inp out) => (:.) f g h

\end{code}
\hask{TMap} takes a type level list and a constraint \hask{f} and can infer the types of resulting type level list.
f must be a class constraint of the form \hask{class C a b } a -> b|. The universe being mapped over
is all types which appear as the left arguement of \hask{C} in all instances of \hask{C}.
\begin{code}
class TMap (f :: * -> * -> Constraint) xs r | f xs -> r
instance TMap f T T
instance (TMap f xs fxs, f x fx) => TMap f (x :$ xs) (fx :$ fxs)
\end{code}

\hask{TFold} folds a type level list to a single value. The constraint, \hask{f},
must be of the form \hask{class C a b c | a b -> c}. We have 
\hask{instance Sum a b c | a b -> c} from SizeTypes. I have no idea if this is a left fold or 
a right fold or if that sort of designation even matters in this case.
\begin{code}
class TFold (f :: * -> * -> * -> Constraint) z xs r | f z xs -> r
instance TFold f z T z
instance (TFold f z xs xr, f x xr r) => TFold f z (x :$ xs) r

class TAppend a b c | a b -> c 
instance TAppend T x x
instance (TAppend xs ys i0) => TAppend (x :$ xs) ys (x :$ i0)
tAppend :: (TAppend a b c) => a -> b -> c
tAppend = undefined

\end{code}
Note that unlike \hask{Prelude.zip} this won't typecheck for lists of different length.
\begin{code}
class TZipWith (f :: * -> * -> * -> Constraint) xs ys rs | f xs ys -> rs
instance TZipWith f T T T 
instance (f x y r, TZipWith f xs ys rs) => TZipWith f (x :$ xs) (y :$ ys) (r :$ rs)

class TZipWith3 (f :: * -> * -> * -> * -> Constraint) xs ys zs rs | f xs ys zs -> rs
instance TZipWith3 f T T T T
instance (f x y z r, TZipWith3 f xs ys zs rs) => TZipWith3 f (x :$ xs) (y :$ ys) (z :$ zs) (r :$ rs)


\end{code}
This one will work with different sized lists.
\begin{code}
class TZipWithD (f :: * -> * -> * -> Constraint) xs ys rs | f xs ys -> rs
instance TZipWithD f x T T 
instance TZipWithD f T x T 
instance (f x y r, TZipWithD f xs ys rs) => TZipWithD f (x :$ xs) (y :$ ys) (r :$ rs)

\end{code}
Like \hask{Prelude.head} this gives an error (ie, type check failure) for empty lists.
\begin{code}
class THead a b | a -> b
instance THead (a :$ b) a
tHead :: (THead a b) => a -> b
tHead = undefined

class TLast a b | a -> b
instance TLast (a :$ T) a
instance (TLast b c) => TLast (a :$ b) c
tLast :: TLast a b => a -> b
tLast = undefined

class TTail a b | a -> b
instance TTail (a :$ b) b
tTail :: TTail a b => a -> b
tTail = undefined

class TInit a b | a -> b
instance TInit (b :$ T) T
instance (TInit (xs :$ xss) z) => TInit (x :$ xs :$ xss) (x :$ z)
tInit :: TInit a b => a -> b
tInit = undefined

class TElem i l r | i l -> r
instance TElem i (i :$ a) TTrue
instance (TElem i b r) => TElem i (a :$ b) r
instance TElem a T TFalse
tElem :: TElem i l r => i -> l -> r
tElem = undefined

class TNull a b | a -> b
instance TNull T TTrue
instance TNull (a :$ b) TFalse
tNull :: TNull a b => a -> b
tNull = undefined


class TReverse a b | a -> b
instance (TReverseH a T b) => TReverse a b
class TReverseH a b c | a b -> c
instance TReverseH T a a
instance (TReverseH xs (x :$ a) out) => TReverseH (x :$ xs) a out 
tReverse :: TReverse a b => a -> b 
tReverse = undefined

class TPrependToAll sep xs r | sep xs -> r
instance TPrependToAll sep T T
instance (TPrependToAll sep xs rs) => TPrependToAll sep (x :$ xs) (sep :$ x :$ rs)
tPrependToAll :: TPrependToAll sep xs r => sep -> xs -> r
tPrependToAll = undefined

class TIntersperse a la r | a la -> r
instance TIntersperse a T a
instance (TPrependToAll a xs r) => TIntersperse a (x :$ xs) (x :$ r)
tIntersperse :: TIntersperse a b c => a -> b -> c
tIntersperse = undefined

class TConcat xss xs | xss -> xs
instance (TFold TAppend T xss xs) => TConcat xss xs
tConcat :: TConcat xss xs => xss -> xs
tConcat = undefined

class TTranspose x r | x -> r
instance TTranspose T T
instance TTranspose (T :$ a) T
instance (TTranspose (xs :$ tails) ttails, TMap THead xss heads, TMap TTail xss tails) =>
    TTranspose ((x :$ xs) :$ xss) ((x :$ heads) :$ ttails)
tTranspose :: TTranspose x r => x -> r
tTranspose = undefined

class TssHelper x ys r f | x ys r -> f
instance TssHelper x ys r (ys :$ (x :$ ys) :$ r)
class TNonEmptySubsequences xs xss | xs -> xss
instance TNonEmptySubsequences T T
instance (TFold (TssHelper x) T rec r, TNonEmptySubsequences xs rec) => TNonEmptySubsequences (x :$ xs) ((x :$ T) :$ r)
tNonEmptySubsequences :: TNonEmptySubsequences a b => a -> b
tNonEmptySubsequences = undefined

class TSubsequences xs xss | xs -> xss
instance TNonEmptySubsequences xs xss => TSubsequences xs (T :$ xss)
tSubsequences :: TSubsequences a b => a -> b
tSubsequences = undefined

class TConcatMap (f :: * -> * -> Constraint) xs rs | f xs -> rs
instance (TMap f xs r, TConcat r rs) => TConcatMap f xs rs

\end{code}
\hask{and}, among others requires defintion of boolean operators. They aren't very interesting by themselves but
if there were instances that mapped to \hask{TBool} or such then they would be relevant.
\begin{code}
class (:&&) a b c | a b -> c
instance (:&&) TTrue TTrue TTrue
instance (:&&) TTrue TFalse TFalse
instance (:&&) TFalse TTrue TFalse
instance (:&&) TFalse TFalse TFalse

class (:||) a b c | a b -> c
instance (:||) TTrue TTrue TTrue
instance (:||) TTrue TFalse TTrue
instance (:||) TFalse TTrue TTrue
instance (:||) TFalse TFalse TFalse

class TAnd xs r | xs -> r
instance (TFold (:&&) TTrue xs r) => TAnd xs r
class TOr xs r | xs -> r
instance (TFold (:||) TFalse xs r) => TOr xs r

tAnd :: TAnd xs r => xs -> r
tAnd = undefined
tOr :: TOr xs r => xs -> r
tOr = undefined

data TJust a
data TNothing
class TMaybe a
instance (TMaybe (TJust a))
instance (TMaybe TNothing)

class (TList tl, TMaybe r) => TFind e tl r | e tl -> r
instance TFind e T TNothing
instance (TList xs) => TFind e (e :$ xs) (TJust e)
instance (TList xs , TFind e xs d) => TFind e (x :$ xs) d

tFind :: (TFind a tl r) => a -> tl -> r
tFind = undefined
\end{code}

Find an element in a list of associations. 
\begin{code}
class (TList tl, TMaybe r) => TLookup e tl r | e tl -> r
instance TLookup e T TNothing
instance (TList xs) => TLookup key ((key, val) :$ xs) (TJust val)
instance (TList xs , TFind e xs d) => TLookup key ((notkey, val) :$ xs) d

tLookup :: (TLookup a tl r) => a -> tl -> r
tLookup = undefined

\end{code}

\hask{snd} and \hask{fst}.
\begin{code}
class TFst a b | a -> b
instance TFst (a,b) a

class TSnd a b | a -> b
instance TSnd (a,b) b

\end{code}















