\ignore{
\begin{code}
{-# LANGUAGE EmptyDataDecls, MultiParamTypeClasses, FunctionalDependencies, FlexibleInstances, RankNTypes #-}
module UnitDefinitions where
\end{code}
}

\section{Unit definitions}\label{sec:UnitDefs}

In this module we define a type-level number for the power of units.
The units include six of the SI base units: meter, second, kilogram, Ampere, mole, and Kelvin. 

Class which indicates valid unit additions. Instances are written out explicitly in terms of the unit 
constructors. Since this is very long and straightforward, it is not included here. 
\begin{code}
class AddUnit a b c | a b -> c, a c -> b, b c -> a where 
\end{code}

Classes of unit types (one class for each SI base unit being used) which include the unit type and exponent, and a function which gives the numerical value of the exponent of the unit.
\begin{code}
class UnitM a where
  toIntM :: a -> Int

class UnitS a where
  toIntS :: a -> Int

class UnitKg a where
  toIntKg :: a -> Int

class UnitA a where
  toIntA :: a -> Int

class UnitMol a where
  toIntMol :: a -> Int
  
class UnitK a where
  toIntK :: a -> Int
\end{code}


Data constuctors for each unit and its exponent.
The format of naming datatypes is the accepted unit symbol followed by the exponent, replacing negative signs with underscores.
We have 6 basic units: Amperes, Moles, meters, seconds, kilograms, and Kelvin.

\begin{fakecode}
data M0; data M1; data M2; ...
data M_1; data M_2; ...
...
data Kg0;
...
data S0;
...
data A0;
...
data Mol0;
...
data K0;
\end{fakecode}
\ignore{
\begin{code}
data M0
data M1 
data M2
data M3
data M4
data M5
data M_1 
data M_2
data M_3
data M_4
data M_5
data Kg0
data Kg1 
data Kg2 
data Kg3
data Kg4
data Kg5
data Kg_1  
data Kg_2
data Kg_3
data Kg_4
data Kg_5
data S0
data S1 
data S2 
data S3
data S4
data S5
data S_1 
data S_2
data S_3
data S_4
data S_5
data A0
data A1 
data A2 
data A3
data A4
data A5
data A_1 
data A_2
data A_3
data A_4
data A_5
data Mol0
data Mol1
data Mol2
data Mol3
data Mol4
data Mol5
data Mol_1 
data Mol_2
data Mol_3
data Mol_4
data Mol_5
data K0
data K1
data K2
data K3
data K4
data K5
data K_1 
data K_2
data K_3
data K_4
data K_5
\end{code}
}

Instances of unit classes.
\begin{code}
instance UnitM M0  where toIntM _ = 0
instance UnitM M1  where toIntM _ = 1
instance UnitM M2  where toIntM _ = 2
instance UnitM M3  where toIntM _ = 3
instance UnitM M4  where toIntM _ = 4
instance UnitM M5  where toIntM _ = 5
instance UnitM M_1 where toIntM _ = -1
instance UnitM M_2 where toIntM _ = -2
instance UnitM M_3 where toIntM _ = -3
instance UnitM M_4 where toIntM _ = -4
instance UnitM M_5 where toIntM _ = -5

instance UnitKg Kg0  where toIntKg _ = 0
instance UnitKg Kg1  where toIntKg _ = 1
instance UnitKg Kg2  where toIntKg _ = 2
instance UnitKg Kg3  where toIntKg _ = 3
instance UnitKg Kg4  where toIntKg _ = 4
instance UnitKg Kg5  where toIntKg _ = 5
instance UnitKg Kg_1 where toIntKg _ = -1
instance UnitKg Kg_2 where toIntKg _ = -2
instance UnitKg Kg_3 where toIntKg _ = -3
instance UnitKg Kg_4 where toIntKg _ = -4
instance UnitKg Kg_5 where toIntKg _ = -5  

instance UnitS S0  where toIntS _ = 0
instance UnitS S1  where toIntS _ = 1
instance UnitS S2  where toIntS _ = 2
instance UnitS S3  where toIntS _ = 3
instance UnitS S4  where toIntS _ = 4
instance UnitS S5  where toIntS _ = 5
instance UnitS S_1 where toIntS _ = -1
instance UnitS S_2 where toIntS _ = -2
instance UnitS S_3 where toIntS _ = -3
instance UnitS S_4 where toIntS _ = -4
instance UnitS S_5 where toIntS _ = -5  
  
instance UnitA A0  where toIntA _ = 0
instance UnitA A1  where toIntA _ = 1
instance UnitA A2  where toIntA _ = 2
instance UnitA A3  where toIntA _ = 3
instance UnitA A4  where toIntA _ = 4
instance UnitA A5  where toIntA _ = 5
instance UnitA A_1 where toIntA _ = -1
instance UnitA A_2 where toIntA _ = -2
instance UnitA A_3 where toIntA _ = -3
instance UnitA A_4 where toIntA _ = -4
instance UnitA A_5 where toIntA _ = -5  
  
instance UnitMol Mol0  where toIntMol _ = 0
instance UnitMol Mol1  where toIntMol _ = 1
instance UnitMol Mol2  where toIntMol _ = 2
instance UnitMol Mol3  where toIntMol _ = 3
instance UnitMol Mol4  where toIntMol _ = 4
instance UnitMol Mol5  where toIntMol _ = 5
instance UnitMol Mol_1 where toIntMol _ = -1
instance UnitMol Mol_2 where toIntMol _ = -2
instance UnitMol Mol_3 where toIntMol _ = -3
instance UnitMol Mol_4 where toIntMol _ = -4
instance UnitMol Mol_5 where toIntMol _ = -5
  
instance UnitK K0  where toIntK _ = 0
instance UnitK K1  where toIntK _ = 1
instance UnitK K2  where toIntK _ = 2
instance UnitK K3  where toIntK _ = 3
instance UnitK K4  where toIntK _ = 4
instance UnitK K5  where toIntK _ = 5
instance UnitK K_1 where toIntK _ = -1
instance UnitK K_2 where toIntK _ = -2
instance UnitK K_3 where toIntK _ = -3
instance UnitK K_4 where toIntK _ = -4
instance UnitK K_5 where toIntK _ = -5
  
\end{code}
\ignore{
\begin{code}
instance AddUnit M_5 M0 M_5 where
instance AddUnit M_5 M1 M_4 where
instance AddUnit M_5 M2 M_3 where
instance AddUnit M_5 M3 M_2 where
instance AddUnit M_5 M4 M_1 where
instance AddUnit M_5 M5 M0 where
instance AddUnit M_4 M_1 M_5 where
instance AddUnit M_4 M0 M_4 where
instance AddUnit M_4 M1 M_3 where
instance AddUnit M_4 M2 M_2 where
instance AddUnit M_4 M3 M_1 where
instance AddUnit M_4 M4 M0 where
instance AddUnit M_4 M5 M1 where
instance AddUnit M_3 M_2 M_5 where
instance AddUnit M_3 M_1 M_4 where
instance AddUnit M_3 M0 M_3 where
instance AddUnit M_3 M1 M_2 where
instance AddUnit M_3 M2 M_1 where
instance AddUnit M_3 M3 M0 where
instance AddUnit M_3 M4 M1 where
instance AddUnit M_3 M5 M2 where
instance AddUnit M_2 M_3 M_5 where
instance AddUnit M_2 M_2 M_4 where
instance AddUnit M_2 M_1 M_3 where
instance AddUnit M_2 M0 M_2 where
instance AddUnit M_2 M1 M_1 where
instance AddUnit M_2 M2 M0 where
instance AddUnit M_2 M3 M1 where
instance AddUnit M_2 M4 M2 where
instance AddUnit M_2 M5 M3 where
instance AddUnit M_1 M_4 M_5 where
instance AddUnit M_1 M_3 M_4 where
instance AddUnit M_1 M_2 M_3 where
instance AddUnit M_1 M_1 M_2 where
instance AddUnit M_1 M0 M_1 where
instance AddUnit M_1 M1 M0 where
instance AddUnit M_1 M2 M1 where
instance AddUnit M_1 M3 M2 where
instance AddUnit M_1 M4 M3 where
instance AddUnit M_1 M5 M4 where
instance AddUnit M0 M_5 M_5 where
instance AddUnit M0 M_4 M_4 where
instance AddUnit M0 M_3 M_3 where
instance AddUnit M0 M_2 M_2 where
instance AddUnit M0 M_1 M_1 where
instance AddUnit M0 M0 M0 where
instance AddUnit M0 M1 M1 where
instance AddUnit M0 M2 M2 where
instance AddUnit M0 M3 M3 where
instance AddUnit M0 M4 M4 where
instance AddUnit M0 M5 M5 where
instance AddUnit M1 M_5 M_4 where
instance AddUnit M1 M_4 M_3 where
instance AddUnit M1 M_3 M_2 where
instance AddUnit M1 M_2 M_1 where
instance AddUnit M1 M_1 M0 where
instance AddUnit M1 M0 M1 where
instance AddUnit M1 M1 M2 where
instance AddUnit M1 M2 M3 where
instance AddUnit M1 M3 M4 where
instance AddUnit M1 M4 M5 where
instance AddUnit M2 M_5 M_3 where
instance AddUnit M2 M_4 M_2 where
instance AddUnit M2 M_3 M_1 where
instance AddUnit M2 M_2 M0 where
instance AddUnit M2 M_1 M1 where
instance AddUnit M2 M0 M2 where
instance AddUnit M2 M1 M3 where
instance AddUnit M2 M2 M4 where
instance AddUnit M2 M3 M5 where
instance AddUnit M3 M_5 M_2 where
instance AddUnit M3 M_4 M_1 where
instance AddUnit M3 M_3 M0 where
instance AddUnit M3 M_2 M1 where
instance AddUnit M3 M_1 M2 where
instance AddUnit M3 M0 M3 where
instance AddUnit M3 M1 M4 where
instance AddUnit M3 M2 M5 where
instance AddUnit M4 M_5 M_1 where
instance AddUnit M4 M_4 M0 where
instance AddUnit M4 M_3 M1 where
instance AddUnit M4 M_2 M2 where
instance AddUnit M4 M_1 M3 where
instance AddUnit M4 M0 M4 where
instance AddUnit M4 M1 M5 where
instance AddUnit M5 M_5 M0 where
instance AddUnit M5 M_4 M1 where
instance AddUnit M5 M_3 M2 where
instance AddUnit M5 M_2 M3 where
instance AddUnit M5 M_1 M4 where
instance AddUnit M5 M0 M5 where

instance AddUnit Kg_5 Kg0 Kg_5 where
instance AddUnit Kg_5 Kg1 Kg_4 where
instance AddUnit Kg_5 Kg2 Kg_3 where
instance AddUnit Kg_5 Kg3 Kg_2 where
instance AddUnit Kg_5 Kg4 Kg_1 where
instance AddUnit Kg_5 Kg5 Kg0 where
instance AddUnit Kg_4 Kg_1 Kg_5 where
instance AddUnit Kg_4 Kg0 Kg_4 where
instance AddUnit Kg_4 Kg1 Kg_3 where
instance AddUnit Kg_4 Kg2 Kg_2 where
instance AddUnit Kg_4 Kg3 Kg_1 where
instance AddUnit Kg_4 Kg4 Kg0 where
instance AddUnit Kg_4 Kg5 Kg1 where
instance AddUnit Kg_3 Kg_2 Kg_5 where
instance AddUnit Kg_3 Kg_1 Kg_4 where
instance AddUnit Kg_3 Kg0 Kg_3 where
instance AddUnit Kg_3 Kg1 Kg_2 where
instance AddUnit Kg_3 Kg2 Kg_1 where
instance AddUnit Kg_3 Kg3 Kg0 where
instance AddUnit Kg_3 Kg4 Kg1 where
instance AddUnit Kg_3 Kg5 Kg2 where
instance AddUnit Kg_2 Kg_3 Kg_5 where
instance AddUnit Kg_2 Kg_2 Kg_4 where
instance AddUnit Kg_2 Kg_1 Kg_3 where
instance AddUnit Kg_2 Kg0 Kg_2 where
instance AddUnit Kg_2 Kg1 Kg_1 where
instance AddUnit Kg_2 Kg2 Kg0 where
instance AddUnit Kg_2 Kg3 Kg1 where
instance AddUnit Kg_2 Kg4 Kg2 where
instance AddUnit Kg_2 Kg5 Kg3 where
instance AddUnit Kg_1 Kg_4 Kg_5 where
instance AddUnit Kg_1 Kg_3 Kg_4 where
instance AddUnit Kg_1 Kg_2 Kg_3 where
instance AddUnit Kg_1 Kg_1 Kg_2 where
instance AddUnit Kg_1 Kg0 Kg_1 where
instance AddUnit Kg_1 Kg1 Kg0 where
instance AddUnit Kg_1 Kg2 Kg1 where
instance AddUnit Kg_1 Kg3 Kg2 where
instance AddUnit Kg_1 Kg4 Kg3 where
instance AddUnit Kg_1 Kg5 Kg4 where
instance AddUnit Kg0 Kg_5 Kg_5 where
instance AddUnit Kg0 Kg_4 Kg_4 where
instance AddUnit Kg0 Kg_3 Kg_3 where
instance AddUnit Kg0 Kg_2 Kg_2 where
instance AddUnit Kg0 Kg_1 Kg_1 where
instance AddUnit Kg0 Kg0 Kg0 where
instance AddUnit Kg0 Kg1 Kg1 where
instance AddUnit Kg0 Kg2 Kg2 where
instance AddUnit Kg0 Kg3 Kg3 where
instance AddUnit Kg0 Kg4 Kg4 where
instance AddUnit Kg0 Kg5 Kg5 where
instance AddUnit Kg1 Kg_5 Kg_4 where
instance AddUnit Kg1 Kg_4 Kg_3 where
instance AddUnit Kg1 Kg_3 Kg_2 where
instance AddUnit Kg1 Kg_2 Kg_1 where
instance AddUnit Kg1 Kg_1 Kg0 where
instance AddUnit Kg1 Kg0 Kg1 where
instance AddUnit Kg1 Kg1 Kg2 where
instance AddUnit Kg1 Kg2 Kg3 where
instance AddUnit Kg1 Kg3 Kg4 where
instance AddUnit Kg1 Kg4 Kg5 where
instance AddUnit Kg2 Kg_5 Kg_3 where
instance AddUnit Kg2 Kg_4 Kg_2 where
instance AddUnit Kg2 Kg_3 Kg_1 where
instance AddUnit Kg2 Kg_2 Kg0 where
instance AddUnit Kg2 Kg_1 Kg1 where
instance AddUnit Kg2 Kg0 Kg2 where
instance AddUnit Kg2 Kg1 Kg3 where
instance AddUnit Kg2 Kg2 Kg4 where
instance AddUnit Kg2 Kg3 Kg5 where
instance AddUnit Kg3 Kg_5 Kg_2 where
instance AddUnit Kg3 Kg_4 Kg_1 where
instance AddUnit Kg3 Kg_3 Kg0 where
instance AddUnit Kg3 Kg_2 Kg1 where
instance AddUnit Kg3 Kg_1 Kg2 where
instance AddUnit Kg3 Kg0 Kg3 where
instance AddUnit Kg3 Kg1 Kg4 where
instance AddUnit Kg3 Kg2 Kg5 where
instance AddUnit Kg4 Kg_5 Kg_1 where
instance AddUnit Kg4 Kg_4 Kg0 where
instance AddUnit Kg4 Kg_3 Kg1 where
instance AddUnit Kg4 Kg_2 Kg2 where
instance AddUnit Kg4 Kg_1 Kg3 where
instance AddUnit Kg4 Kg0 Kg4 where
instance AddUnit Kg4 Kg1 Kg5 where
instance AddUnit Kg5 Kg_5 Kg0 where
instance AddUnit Kg5 Kg_4 Kg1 where
instance AddUnit Kg5 Kg_3 Kg2 where
instance AddUnit Kg5 Kg_2 Kg3 where
instance AddUnit Kg5 Kg_1 Kg4 where
instance AddUnit Kg5 Kg0 Kg5 where

instance AddUnit S_5 S0 S_5 where
instance AddUnit S_5 S1 S_4 where
instance AddUnit S_5 S2 S_3 where
instance AddUnit S_5 S3 S_2 where
instance AddUnit S_5 S4 S_1 where
instance AddUnit S_5 S5 S0 where
instance AddUnit S_4 S_1 S_5 where
instance AddUnit S_4 S0 S_4 where
instance AddUnit S_4 S1 S_3 where
instance AddUnit S_4 S2 S_2 where
instance AddUnit S_4 S3 S_1 where
instance AddUnit S_4 S4 S0 where
instance AddUnit S_4 S5 S1 where
instance AddUnit S_3 S_2 S_5 where
instance AddUnit S_3 S_1 S_4 where
instance AddUnit S_3 S0 S_3 where
instance AddUnit S_3 S1 S_2 where
instance AddUnit S_3 S2 S_1 where
instance AddUnit S_3 S3 S0 where
instance AddUnit S_3 S4 S1 where
instance AddUnit S_3 S5 S2 where
instance AddUnit S_2 S_3 S_5 where
instance AddUnit S_2 S_2 S_4 where
instance AddUnit S_2 S_1 S_3 where
instance AddUnit S_2 S0 S_2 where
instance AddUnit S_2 S1 S_1 where
instance AddUnit S_2 S2 S0 where
instance AddUnit S_2 S3 S1 where
instance AddUnit S_2 S4 S2 where
instance AddUnit S_2 S5 S3 where
instance AddUnit S_1 S_4 S_5 where
instance AddUnit S_1 S_3 S_4 where
instance AddUnit S_1 S_2 S_3 where
instance AddUnit S_1 S_1 S_2 where
instance AddUnit S_1 S0 S_1 where
instance AddUnit S_1 S1 S0 where
instance AddUnit S_1 S2 S1 where
instance AddUnit S_1 S3 S2 where
instance AddUnit S_1 S4 S3 where
instance AddUnit S_1 S5 S4 where
instance AddUnit S0 S_5 S_5 where
instance AddUnit S0 S_4 S_4 where
instance AddUnit S0 S_3 S_3 where
instance AddUnit S0 S_2 S_2 where
instance AddUnit S0 S_1 S_1 where
instance AddUnit S0 S0 S0 where
instance AddUnit S0 S1 S1 where
instance AddUnit S0 S2 S2 where
instance AddUnit S0 S3 S3 where
instance AddUnit S0 S4 S4 where
instance AddUnit S0 S5 S5 where
instance AddUnit S1 S_5 S_4 where
instance AddUnit S1 S_4 S_3 where
instance AddUnit S1 S_3 S_2 where
instance AddUnit S1 S_2 S_1 where
instance AddUnit S1 S_1 S0 where
instance AddUnit S1 S0 S1 where
instance AddUnit S1 S1 S2 where
instance AddUnit S1 S2 S3 where
instance AddUnit S1 S3 S4 where
instance AddUnit S1 S4 S5 where
instance AddUnit S2 S_5 S_3 where
instance AddUnit S2 S_4 S_2 where
instance AddUnit S2 S_3 S_1 where
instance AddUnit S2 S_2 S0 where
instance AddUnit S2 S_1 S1 where
instance AddUnit S2 S0 S2 where
instance AddUnit S2 S1 S3 where
instance AddUnit S2 S2 S4 where
instance AddUnit S2 S3 S5 where
instance AddUnit S3 S_5 S_2 where
instance AddUnit S3 S_4 S_1 where
instance AddUnit S3 S_3 S0 where
instance AddUnit S3 S_2 S1 where
instance AddUnit S3 S_1 S2 where
instance AddUnit S3 S0 S3 where
instance AddUnit S3 S1 S4 where
instance AddUnit S3 S2 S5 where
instance AddUnit S4 S_5 S_1 where
instance AddUnit S4 S_4 S0 where
instance AddUnit S4 S_3 S1 where
instance AddUnit S4 S_2 S2 where
instance AddUnit S4 S_1 S3 where
instance AddUnit S4 S0 S4 where
instance AddUnit S4 S1 S5 where
instance AddUnit S5 S_5 S0 where
instance AddUnit S5 S_4 S1 where
instance AddUnit S5 S_3 S2 where
instance AddUnit S5 S_2 S3 where
instance AddUnit S5 S_1 S4 where
instance AddUnit S5 S0 S5 where

instance AddUnit A_5 A0 A_5 where
instance AddUnit A_5 A1 A_4 where
instance AddUnit A_5 A2 A_3 where
instance AddUnit A_5 A3 A_2 where
instance AddUnit A_5 A4 A_1 where
instance AddUnit A_5 A5 A0 where
instance AddUnit A_4 A_1 A_5 where
instance AddUnit A_4 A0 A_4 where
instance AddUnit A_4 A1 A_3 where
instance AddUnit A_4 A2 A_2 where
instance AddUnit A_4 A3 A_1 where
instance AddUnit A_4 A4 A0 where
instance AddUnit A_4 A5 A1 where
instance AddUnit A_3 A_2 A_5 where
instance AddUnit A_3 A_1 A_4 where
instance AddUnit A_3 A0 A_3 where
instance AddUnit A_3 A1 A_2 where
instance AddUnit A_3 A2 A_1 where
instance AddUnit A_3 A3 A0 where
instance AddUnit A_3 A4 A1 where
instance AddUnit A_3 A5 A2 where
instance AddUnit A_2 A_3 A_5 where
instance AddUnit A_2 A_2 A_4 where
instance AddUnit A_2 A_1 A_3 where
instance AddUnit A_2 A0 A_2 where
instance AddUnit A_2 A1 A_1 where
instance AddUnit A_2 A2 A0 where
instance AddUnit A_2 A3 A1 where
instance AddUnit A_2 A4 A2 where
instance AddUnit A_2 A5 A3 where
instance AddUnit A_1 A_4 A_5 where
instance AddUnit A_1 A_3 A_4 where
instance AddUnit A_1 A_2 A_3 where
instance AddUnit A_1 A_1 A_2 where
instance AddUnit A_1 A0 A_1 where
instance AddUnit A_1 A1 A0 where
instance AddUnit A_1 A2 A1 where
instance AddUnit A_1 A3 A2 where
instance AddUnit A_1 A4 A3 where
instance AddUnit A_1 A5 A4 where
instance AddUnit A0 A_5 A_5 where
instance AddUnit A0 A_4 A_4 where
instance AddUnit A0 A_3 A_3 where
instance AddUnit A0 A_2 A_2 where
instance AddUnit A0 A_1 A_1 where
instance AddUnit A0 A0 A0 where
instance AddUnit A0 A1 A1 where
instance AddUnit A0 A2 A2 where
instance AddUnit A0 A3 A3 where
instance AddUnit A0 A4 A4 where
instance AddUnit A0 A5 A5 where
instance AddUnit A1 A_5 A_4 where
instance AddUnit A1 A_4 A_3 where
instance AddUnit A1 A_3 A_2 where
instance AddUnit A1 A_2 A_1 where
instance AddUnit A1 A_1 A0 where
instance AddUnit A1 A0 A1 where
instance AddUnit A1 A1 A2 where
instance AddUnit A1 A2 A3 where
instance AddUnit A1 A3 A4 where
instance AddUnit A1 A4 A5 where
instance AddUnit A2 A_5 A_3 where
instance AddUnit A2 A_4 A_2 where
instance AddUnit A2 A_3 A_1 where
instance AddUnit A2 A_2 A0 where
instance AddUnit A2 A_1 A1 where
instance AddUnit A2 A0 A2 where
instance AddUnit A2 A1 A3 where
instance AddUnit A2 A2 A4 where
instance AddUnit A2 A3 A5 where
instance AddUnit A3 A_5 A_2 where
instance AddUnit A3 A_4 A_1 where
instance AddUnit A3 A_3 A0 where
instance AddUnit A3 A_2 A1 where
instance AddUnit A3 A_1 A2 where
instance AddUnit A3 A0 A3 where
instance AddUnit A3 A1 A4 where
instance AddUnit A3 A2 A5 where
instance AddUnit A4 A_5 A_1 where
instance AddUnit A4 A_4 A0 where
instance AddUnit A4 A_3 A1 where
instance AddUnit A4 A_2 A2 where
instance AddUnit A4 A_1 A3 where
instance AddUnit A4 A0 A4 where
instance AddUnit A4 A1 A5 where
instance AddUnit A5 A_5 A0 where
instance AddUnit A5 A_4 A1 where
instance AddUnit A5 A_3 A2 where
instance AddUnit A5 A_2 A3 where
instance AddUnit A5 A_1 A4 where
instance AddUnit A5 A0 A5 where

instance AddUnit Mol_5 Mol0 Mol_5 where
instance AddUnit Mol_5 Mol1 Mol_4 where
instance AddUnit Mol_5 Mol2 Mol_3 where
instance AddUnit Mol_5 Mol3 Mol_2 where
instance AddUnit Mol_5 Mol4 Mol_1 where
instance AddUnit Mol_5 Mol5 Mol0 where
instance AddUnit Mol_4 Mol_1 Mol_5 where
instance AddUnit Mol_4 Mol0 Mol_4 where
instance AddUnit Mol_4 Mol1 Mol_3 where
instance AddUnit Mol_4 Mol2 Mol_2 where
instance AddUnit Mol_4 Mol3 Mol_1 where
instance AddUnit Mol_4 Mol4 Mol0 where
instance AddUnit Mol_4 Mol5 Mol1 where
instance AddUnit Mol_3 Mol_2 Mol_5 where
instance AddUnit Mol_3 Mol_1 Mol_4 where
instance AddUnit Mol_3 Mol0 Mol_3 where
instance AddUnit Mol_3 Mol1 Mol_2 where
instance AddUnit Mol_3 Mol2 Mol_1 where
instance AddUnit Mol_3 Mol3 Mol0 where
instance AddUnit Mol_3 Mol4 Mol1 where
instance AddUnit Mol_3 Mol5 Mol2 where
instance AddUnit Mol_2 Mol_3 Mol_5 where
instance AddUnit Mol_2 Mol_2 Mol_4 where
instance AddUnit Mol_2 Mol_1 Mol_3 where
instance AddUnit Mol_2 Mol0 Mol_2 where
instance AddUnit Mol_2 Mol1 Mol_1 where
instance AddUnit Mol_2 Mol2 Mol0 where
instance AddUnit Mol_2 Mol3 Mol1 where
instance AddUnit Mol_2 Mol4 Mol2 where
instance AddUnit Mol_2 Mol5 Mol3 where
instance AddUnit Mol_1 Mol_4 Mol_5 where
instance AddUnit Mol_1 Mol_3 Mol_4 where
instance AddUnit Mol_1 Mol_2 Mol_3 where
instance AddUnit Mol_1 Mol_1 Mol_2 where
instance AddUnit Mol_1 Mol0 Mol_1 where
instance AddUnit Mol_1 Mol1 Mol0 where
instance AddUnit Mol_1 Mol2 Mol1 where
instance AddUnit Mol_1 Mol3 Mol2 where
instance AddUnit Mol_1 Mol4 Mol3 where
instance AddUnit Mol_1 Mol5 Mol4 where
instance AddUnit Mol0 Mol_5 Mol_5 where
instance AddUnit Mol0 Mol_4 Mol_4 where
instance AddUnit Mol0 Mol_3 Mol_3 where
instance AddUnit Mol0 Mol_2 Mol_2 where
instance AddUnit Mol0 Mol_1 Mol_1 where
instance AddUnit Mol0 Mol0 Mol0 where
instance AddUnit Mol0 Mol1 Mol1 where
instance AddUnit Mol0 Mol2 Mol2 where
instance AddUnit Mol0 Mol3 Mol3 where
instance AddUnit Mol0 Mol4 Mol4 where
instance AddUnit Mol0 Mol5 Mol5 where
instance AddUnit Mol1 Mol_5 Mol_4 where
instance AddUnit Mol1 Mol_4 Mol_3 where
instance AddUnit Mol1 Mol_3 Mol_2 where
instance AddUnit Mol1 Mol_2 Mol_1 where
instance AddUnit Mol1 Mol_1 Mol0 where
instance AddUnit Mol1 Mol0 Mol1 where
instance AddUnit Mol1 Mol1 Mol2 where
instance AddUnit Mol1 Mol2 Mol3 where
instance AddUnit Mol1 Mol3 Mol4 where
instance AddUnit Mol1 Mol4 Mol5 where
instance AddUnit Mol2 Mol_5 Mol_3 where
instance AddUnit Mol2 Mol_4 Mol_2 where
instance AddUnit Mol2 Mol_3 Mol_1 where
instance AddUnit Mol2 Mol_2 Mol0 where
instance AddUnit Mol2 Mol_1 Mol1 where
instance AddUnit Mol2 Mol0 Mol2 where
instance AddUnit Mol2 Mol1 Mol3 where
instance AddUnit Mol2 Mol2 Mol4 where
instance AddUnit Mol2 Mol3 Mol5 where
instance AddUnit Mol3 Mol_5 Mol_2 where
instance AddUnit Mol3 Mol_4 Mol_1 where
instance AddUnit Mol3 Mol_3 Mol0 where
instance AddUnit Mol3 Mol_2 Mol1 where
instance AddUnit Mol3 Mol_1 Mol2 where
instance AddUnit Mol3 Mol0 Mol3 where
instance AddUnit Mol3 Mol1 Mol4 where
instance AddUnit Mol3 Mol2 Mol5 where
instance AddUnit Mol4 Mol_5 Mol_1 where
instance AddUnit Mol4 Mol_4 Mol0 where
instance AddUnit Mol4 Mol_3 Mol1 where
instance AddUnit Mol4 Mol_2 Mol2 where
instance AddUnit Mol4 Mol_1 Mol3 where
instance AddUnit Mol4 Mol0 Mol4 where
instance AddUnit Mol4 Mol1 Mol5 where
instance AddUnit Mol5 Mol_5 Mol0 where
instance AddUnit Mol5 Mol_4 Mol1 where
instance AddUnit Mol5 Mol_3 Mol2 where
instance AddUnit Mol5 Mol_2 Mol3 where
instance AddUnit Mol5 Mol_1 Mol4 where
instance AddUnit Mol5 Mol0 Mol5 where

instance AddUnit K_5 K0 K_5 where
instance AddUnit K_5 K1 K_4 where
instance AddUnit K_5 K2 K_3 where
instance AddUnit K_5 K3 K_2 where
instance AddUnit K_5 K4 K_1 where
instance AddUnit K_5 K5 K0 where
instance AddUnit K_4 K_1 K_5 where
instance AddUnit K_4 K0 K_4 where
instance AddUnit K_4 K1 K_3 where
instance AddUnit K_4 K2 K_2 where
instance AddUnit K_4 K3 K_1 where
instance AddUnit K_4 K4 K0 where
instance AddUnit K_4 K5 K1 where
instance AddUnit K_3 K_2 K_5 where
instance AddUnit K_3 K_1 K_4 where
instance AddUnit K_3 K0 K_3 where
instance AddUnit K_3 K1 K_2 where
instance AddUnit K_3 K2 K_1 where
instance AddUnit K_3 K3 K0 where
instance AddUnit K_3 K4 K1 where
instance AddUnit K_3 K5 K2 where
instance AddUnit K_2 K_3 K_5 where
instance AddUnit K_2 K_2 K_4 where
instance AddUnit K_2 K_1 K_3 where
instance AddUnit K_2 K0 K_2 where
instance AddUnit K_2 K1 K_1 where
instance AddUnit K_2 K2 K0 where
instance AddUnit K_2 K3 K1 where
instance AddUnit K_2 K4 K2 where
instance AddUnit K_2 K5 K3 where
instance AddUnit K_1 K_4 K_5 where
instance AddUnit K_1 K_3 K_4 where
instance AddUnit K_1 K_2 K_3 where
instance AddUnit K_1 K_1 K_2 where
instance AddUnit K_1 K0 K_1 where
instance AddUnit K_1 K1 K0 where
instance AddUnit K_1 K2 K1 where
instance AddUnit K_1 K3 K2 where
instance AddUnit K_1 K4 K3 where
instance AddUnit K_1 K5 K4 where
instance AddUnit K0 K_5 K_5 where
instance AddUnit K0 K_4 K_4 where
instance AddUnit K0 K_3 K_3 where
instance AddUnit K0 K_2 K_2 where
instance AddUnit K0 K_1 K_1 where
instance AddUnit K0 K0 K0 where
instance AddUnit K0 K1 K1 where
instance AddUnit K0 K2 K2 where
instance AddUnit K0 K3 K3 where
instance AddUnit K0 K4 K4 where
instance AddUnit K0 K5 K5 where
instance AddUnit K1 K_5 K_4 where
instance AddUnit K1 K_4 K_3 where
instance AddUnit K1 K_3 K_2 where
instance AddUnit K1 K_2 K_1 where
instance AddUnit K1 K_1 K0 where
instance AddUnit K1 K0 K1 where
instance AddUnit K1 K1 K2 where
instance AddUnit K1 K2 K3 where
instance AddUnit K1 K3 K4 where
instance AddUnit K1 K4 K5 where
instance AddUnit K2 K_5 K_3 where
instance AddUnit K2 K_4 K_2 where
instance AddUnit K2 K_3 K_1 where
instance AddUnit K2 K_2 K0 where
instance AddUnit K2 K_1 K1 where
instance AddUnit K2 K0 K2 where
instance AddUnit K2 K1 K3 where
instance AddUnit K2 K2 K4 where
instance AddUnit K2 K3 K5 where
instance AddUnit K3 K_5 K_2 where
instance AddUnit K3 K_4 K_1 where
instance AddUnit K3 K_3 K0 where
instance AddUnit K3 K_2 K1 where
instance AddUnit K3 K_1 K2 where
instance AddUnit K3 K0 K3 where
instance AddUnit K3 K1 K4 where
instance AddUnit K3 K2 K5 where
instance AddUnit K4 K_5 K_1 where
instance AddUnit K4 K_4 K0 where
instance AddUnit K4 K_3 K1 where
instance AddUnit K4 K_2 K2 where
instance AddUnit K4 K_1 K3 where
instance AddUnit K4 K0 K4 where
instance AddUnit K4 K1 K5 where
instance AddUnit K5 K_5 K0 where
instance AddUnit K5 K_4 K1 where
instance AddUnit K5 K_3 K2 where
instance AddUnit K5 K_2 K3 where
instance AddUnit K5 K_1 K4 where
instance AddUnit K5 K0 K5 where

\end{code}
}
