\begin{code}
{-# LANGUAGE 
    FunctionalDependencies,
    FlexibleInstances,
    ScopedTypeVariables,
    UndecidableInstances,
--    TypeFamilies ,
    FlexibleContexts,
    ConstraintKinds,
    GADTs,
    RankNTypes,
    ImpredicativeTypes,
    IncoherentInstances,
    ConstraintKinds,
    TypeOperators,
    MultiParamTypeClasses,
    InstanceSigs,
    KindSignatures,
    TypeFamilies,
    ParallelListComp,
    QuasiQuotes,
    TemplateHaskell
    #-}
module PlaneFrameData where 

import NumericTypes
import FloatingPoint
import SIUnits hiding  ((*),(+),(-),(/),negate)
import qualified SIUnits as S ((*),(-),(+),(/),negate)
import UnitDefinitions
import TypeLevelList 
import TypeGen

import Control.Monad.ST
import Data.List
import Data.Array.Unboxed
import Data.Array.MArray
import Data.Array.IO
import Data.Array.ST
import Data.Maybe
import Data.Function (on)
import qualified Data.IntMap as I 
import Control.Monad
import System.Random
import System.Environment
import GHC.Real (Ratio(..))
import GHC.Prim
import GHC.Types

import System.IO.Unsafe



\end{code}
e, a, i can be any fractional values.
e is Young's Modulus. i is 2nd moment of area. a is cross sectional area.
(j1,j2) must both exist in the list of joints.
Also j1 /= j2 since that doesnt make any sense.
\begin{code}
data MemberG j1j2 e a i where
    MemberG :: (Nat j1, Nat j2, FloatT e, Positive e, FloatT a, Positive a, FloatT i, Positive i, TypeEq j1 j2 TFalse
       ) => (j1,j2) -> e -> a -> i -> MemberG (j1,j2) e a i


\end{code}
e, a, i can be any fractional values.
e is Young's Modulus. i is 2nd moment of area. a is cross sectional area.
j must exist in the list of joints.
The length,l, and slope,m, must place the other end of the member at a(ny) joint. 
\begin{code}


data MemberL j l m e a i where
    MemberL :: (Nat j, FloatT e, Positive e, FloatT a, Positive a, FloatT i, Positive i, FloatT l, Positive l,
                FloatT m
      ) => j -> l -> m -> e -> a -> i -> MemberL j l m e a i 


\end{code}
n : joint label
(x,y) : position in global coordinates
(f,th) : initial force in polar relative to +x
m : initial moment 
t : type of joint
\begin{code}
data DOF = Fixed | Free 
    deriving (Show, Eq)
type JType = (DOF, DOF, DOF)

data Joint n xy where
    Joint :: (FloatT x, FloatT y, Nat n) 
        => n -> (x,y) -> JType -> (Float, Float) -> Float -> Joint n (x,y)
        
\end{code}

We have a class which defines a function that will give the representation of the member on the data level.
We also have a function that will do the same for a joint. 
\begin{code}
data MemberD = MemberD { joints :: (Int, Int) , e :: Float, a :: Float, i :: Float } deriving (Show, Eq)
data JointD = JointD { jNum :: Int, pos :: (Float, Float), jType :: JType, force :: (Float, Float), moment :: Float } deriving (Show, Eq)

class DataRepMember a where
    toDataM :: a -> [MemberD]
class DataRepJoint a where
    toDataJ :: a -> [JointD]

instance (Nat j1, Nat j2, FloatT e, Positive e, FloatT a, Positive a, FloatT i, Positive i) => DataRepMember (MemberG (j1,j2) e a i) where
    toDataM _ = [MemberD ((intValue j1), (intValue j2)) (numToFloating e) (numToFloating a) (numToFloating i)]
        where j1 = u :: j1; j2 = u :: j2; e = u :: e; a = u :: a; i = u :: i;
              u = undefined
instance (Nat j, FloatT e, Positive e, FloatT a, Positive a, FloatT i, Positive i, FloatT m ) => DataRepMember (MemberL j l m e a i) where
    toDataM _ = [MemberD ((intValue j1), j2) (numToFloating e) (numToFloating a) (numToFloating i)]
        where j1 = u :: j; l = u :: l; m = u :: m; e = u :: e; a = u :: a; i = u :: i;
              u = undefined
              j2 = undefined --todo

instance (DataRepMember x, DataRepMember xs) => DataRepMember (x :$ xs) where
    toDataM (x :$ xs) = (toDataM x) ++ (toDataM xs)
instance DataRepMember T where
    toDataM _ = []
    
    
instance (Nat n, FloatT x, FloatT y) => DataRepJoint (Joint n (x,y)) where
    toDataJ (Joint q (r,s) type' force moment) = [JointD (intValue q) (numToFloating r, numToFloating s) type' force moment]
instance (DataRepJoint x, DataRepJoint xs) => DataRepJoint (x :$ xs) where
    toDataJ (x :$ xs) = (toDataJ x) ++ (toDataJ xs)
instance DataRepJoint T where
    toDataJ _ = []
    
--toDataMembers :: (DataRepMember a, DataRepMember b) => (a :$ b) -> [MemberD]
--toDataMembers (a :$ b) = (toDataM a) ++ (toDataM b)

\end{code}( 9, 40, 41)
Some data for this sort of shape: 
        (40,9)
          ^
         /|\
        / | \
       /  |  \
(0,0) /___|___\ (80,0)
        (40,0)   
\begin{code}
__ = error "undefined"

dataj = 
 let j0 = [nat| 1 |]
     j1 = [nat| 2 |]
     j2 = [nat| 3 |]
     j3 = [nat| 4 |]
     i1 = [float| 0 |]
     i2 = [float| 40 |]
     i3 = [float| 80 |]
     i4 = [float| 9 |]
     in
    (Joint j0 (i1, i1) (Fixed, Free , Free ) (0,0) 0 :$
     Joint j1 (i2, i1) (Fixed, Fixed, Fixed) (0,0) 0 :$
     Joint j2 (i3, i1) (Fixed, Free , Free ) (0,0) 0 :$
     Joint j3 (i2, i4) (Fixed, Free , Free ) (-10,0) 0 :$ T)
     
datam   =  
 let e = [float| 10000 |]
     a = [float| 0.98 |]
     i = [float| 9 |]
     one   = [nat| 1 |]
     two   = [nat| 2 |]
     three = [nat| 3 |]
     four  = [nat| 4 |]
     in
    (MemberG (one,four)   e a i :$
     MemberG (two,four)   e a i :$
     MemberG (three,four) e a i :$
     MemberG (one,two)    e a i :$
     MemberG (two,three)  e a i :$ T)
     
data0 = MemberG [num| (1 , 2) |] [float| 10000 |] [float| 0.98 |] [float| 9 |]

--data1_1 = MemberL (undefined :: (SIZE2 D0 D1))  -- joint#
--                  (undefined :: (SIZE D0 D0 D0 D0 D0 D0 D0 D0 D0 D1, SIZE D0 D0 D0 D0 D0 D0 D0 D0 D0 D1)) -- length
--                  (undefined :: (SIZE D0 D0 D0 D0 D0 D0 D0 D0 D0 D1, SIZE D0 D0 D0 D0 D0 D0 D0 D0 D0 D1)) -- slope
--                  
--                  (undefined :: (SIZE D0 D0 D0 D0 D0 D0 D0 D0 D0 D1, SIZE D0 D0 D0 D0 D0 D0 D0 D0 D0 D1)) 
--                  (undefined :: (SIZE D0 D0 D0 D0 D0 D0 D0 D0 D0 D1, SIZE D0 D0 D0 D0 D0 D0 D0 D0 D0 D1)) 
--                  (undefined :: (SIZE D0 D0 D0 D0 D0 D0 D0 D0 D0 D1, SIZE D0 D0 D0 D0 D0 D0 D0 D0 D0 D1))

-- MemberL j l m e a i 
data1 = MemberL [num| 1 |] [num| 41. |] [num| 0.225 |] [num| 1.0 |] [num| 1.0 |] [num| 1.0 |]

data2 = Joint j0 (zero , zero) (Fixed, Free, Free) (0,0) 0
 where j0 = [nat| 1 |]
       zero = [float| 0 |]

\end{code}
|JointNum| extracts the index of the joint from the joint datatype. 
For global members, |ValidMember| gets all the joint numbers, and checks both items of the pair of the points in the member are in the list of joint numbers.
For local members, |ValidMember| first calculates the position of the second joint, then performs the checks above. 
\begin{code}
class JointNum js n | js -> n
instance JointNum (Joint j xy) j
class JointPt js n | js -> n
instance JointPt (Joint j xy) xy
class JointPair js n | js -> n
instance JointPair (Joint j xy) (j,xy)

--class Augment2 a b | a -> b
--instance (Augment a a_, Augment b b_, Augment c c_, Augment d d_) => Augment2 ((a,b),(c,d)) ((a_,b_),(c_,d_))

class ValidMember js m r | m js -> r
instance (Nat j1, FloatT e, Positive e, FloatT a, Positive a, FloatT i, Positive i,
          TypeEq j1 j2 TFalse ,
          TMap JointNum js jns, (j1 `TElem` jns) j1e, (j2 `TElem` jns) j2e, (j1e :&& j2e) r)
    => ValidMember js (MemberG (j1,j2) e a i) r






class Distance2 l m xy wz r | l m xy wz -> r
instance (Subtract y1 y0 dy , Subtract x1 x0 dx, MultD dx dx dx2, MultD dy dy dy2 , Sum dy2 dx2 r0, 
--          MultD l l l2, 
          Subtract r0 l2 r1, IsZero r1 r1z, --the difference is zero - therefore the lengths correspond
          -- we have dy/dx = m, or dy = m dx
          MultD m dx dy_, Subtract dy dy_ r2, IsZero r2 r2z,
          (r1z :&& r2z) r
    ) => Distance2 l2 m (x0,y0) (Joint jn (x1,y1)) r

instance (Nat j1, FloatT l, Positive l, FloatT m, FloatT e, Positive e, FloatT a, Positive a, FloatT i, Positive i,
          TMap JointNum js jns, -- get the joint numbers
          (j1 `TElem` jns) j1e , (j2 `TElem` jns) j2e , (j1e :|| j2e) TTrue, -- the known joint is in the joint list
          TMap JointPair js jps, -- convert Joints to tuples
          TLookup j1 jps (TJust (x1,y1)), -- find position of first joint. 
          MultD l l l2,
          TMap (Distance2 l2 m (x1,y1)) js br,
          TOr br r --really we want to check that exactly one of the booleans is true.
    ) => ValidMember js (MemberL j1 l m e a i ) r

mkClassFunc ''ValidMember
mkClassFunc ''Distance2


\end{code}
|ValidParameterSet| will map over the members and check that each ones joint indices are members of the joint list. 
\begin{code}
class ValidParameterSet j m r | j m -> r
instance (TList joints, TList members, TMap (ValidMember joints) members r0, TAnd r0 TTrue) => ValidParameterSet joints members TTrue

tvp :: ValidParameterSet j m r => j -> m -> r
tvp = undefined


--class Distance xy wv d | xy wv -> d
--instance (MultD x y x_y, MultD w v w_v, MultD x_y x_y x_y2, MultD w_v w_v w_v2, Sum x_y2 w_v2 d2, 
--    => Distance (x,y) (w,v) d



type MeterSquared v = SIUnitVal M2 Kg0 S0 A0 Mol0 K0 v
type Pascal v       = SIUnitVal M_1 Kg1 S_2 A0 Mol0 K0 v
type AreaMoment   v = SIUnitVal M4 Kg0 S0 A0 Mol0 K0 v







--data MemberD = MemberD { joints :: (Int, Int) , e :: Float, a :: Float, i :: Float } deriving (Show, Eq)
--data JointD = JointD { jNum :: Int, pos :: (Float, Float), jType :: JType, force :: (Float, Float), moment :: Float } deriving (Show, Eq)


-- getGlobalMatrix  (toDataM data1 , toDataJ data0)
-- getGlobalMatrix  (toDataM dataj) (toDataJ datam)
getGlobalMatrix :: ([MemberD], [JointD]) -> UArray (Int, Int) Float
getGlobalMatrix (members, joints) = 
  listArray ((min, min), (max + 1 - nb, max - nb)) $
     map snd (filter    ((\(x,y) -> not (x `elem` boundC || y `elem` boundC)) . fst) (assocs globalMatrix))
    
        where boundC = map fst $ filter ((==Fixed) . snd) $ zip [1..] $ concatMap ((\(x,y,z) -> [x,y,z]) . jType) (sortBy (compare `on` jNum) joints)
              nb = length boundC
              globalMatrix = accumArray (+) 0 ((min, min), (max + 1, max)) matricesProp :: UArray (Int, Int) Float
              (min,max) = (  (jNum (minimum joints)), ((jNum (maximum joints)))*3 )
              matrices = map matrix members -- sortBy (\x y -> compare (fst x) (fst y)) $
              matricesProp = (concatMap fst matrices) ++ (nub $ concatMap snd matrices)
              matrix (MemberD (j1,j2) e a i) = (mat, initVals)
                  where len = distance p1 p2
                        (p1,fx1,fy1,m1,jt1,p2,fx2,fy2,m2,jt2) = case (findIn j1 joints, findIn j2 joints) 
                            of ((JointD _ p1 jt1 (fx1,fy1) m1), (JointD _ p2 jt2 (fx2,fy2) m2)) -> (p1,fx1,fy1,m1,jt1,p2,fx2,fy2,m2,jt2)
                        angle = (\((x0,y0),(x1,y1)) -> atan2 (y1 - y0) (x1 - x0) ) (p1,p2)
                        findIn n (j@(JointD m (x0,y0) jtype fr mm):js) 
                            | n == m = j
                            | otherwise = findIn n js
                        distance (x0,y0) (x1,y1) = (**) ( (x0-x1)**2 + (y0-y1)**2 ) 0.5
                        mat = localToGlobal e a len angle j1 j2
                        initVals = [ ((x,y),v) | y <- ((enumCol j1) ++ (enumCol j2)) | x <- repeat (max + 1) | v <- [m1,fx1,fy1,m2,fx2,fy2] ]
                        enumCol j = [(j-1)*3 + 1.. ((j - 1)*3) + 3]

sprint x = unsafePerformIO $ print x >> return x

instance Ord JointD where
    compare j1 j2 = compare (jNum j1) (jNum j2)
{-
m(1,4), m(2,4), m(3,4), m(1,2), m(2,3)

1  1  1  1  1  1                  
1  1  1  1  1  1                  
1  1  1  1  1  1                  
2  2  2  22 22 22 2  2  2         
2  2  2  22 22 22 2  2  2         
2  2  2  22 22 22 2  2  2         
         3  3  3  33 33 33 3  3  3
         3  3  3  33 33 33 3  3  3
         3  3  3  33 33 33 3  3  3
                  4  4  4  4  4  4
                  4  4  4  4  4  4
                  4  4  4  4  4  4
-}

squish [] = []
squish i@((x,xs) : []) = i
squish ((x,xs) : (y,ys) : zs) = (x,xs) : (squish ((x+1,ys) : zs))
    
z = [(1,3), (3,5), (6,8), (6,9), (7,9), (8,10)]

splitInto n []  = []
splitInto n arr = f:(splitInto n r)
    where (f,r) = splitAt n arr 

-- order of dof's : m1, ux1, uy1, m2, ux2, uy2
localStiffnessMatrix a e l = m ++ p1 ++ (map negate m) ++ p2
        where t0 = a*e/l
              t1 = a*e/l 
              t2 = t1/l 
              t3 = t2/l
              p1 = [0 ,6*t2 ,t1*4 ,0 ,(-6)*t2 ,2*t1]
              p2 = [0 ,6*t2 ,t1*2 ,0 ,(-6)*t2 ,4*t1]
              m = 
                [t0    ,0    ,0    ,t0    ,0     ,0     ,
                 0     ,12*t3,6*t2 ,0     ,(-12)*t3,6*t2 ] 
              {- can't have units on each value - the list would be heterogenous
              (*) = (S.*)
              (/) = (S./) -}

transformMatrix th = 
  let m = sin th
      l = cos th in 
    [ l , m , 0 , 0 , 0 , 0 ,
     -m , l , 0 , 0 , 0 , 0 ,
      0 , 0 , 1 , 0 , 0 , 0 ,
      0 , 0 , 0 , l , m , 0 ,
      0 , 0 , 0 ,-m , l , 0 ,
      0 , 0 , 0 , 0 , 0 , 1 ]
      

localToGlobal a e l th j1 j2 = zip ind gkmvals
        where localkm = listArray ((1,1),(3*2,3*2)) (localStiffnessMatrix a e l) :: UArray (Int,Int) Float
              tm = listArray ((1,1),(3*2,3*2)) (transformMatrix th) :: UArray (Int,Int) Float
              tmt = array ((1,1),(3*2,3*2)) $ map swap (assocs tm) :: UArray (Int,Int) Float
              swap ((a,b),v) = ((b,a),v)
              globalkm = (tmt `mmult` localkm) `mmult` tm
              gkmvals = map snd $ assocs globalkm
              ind = getIndices j1 j2 

getIndices i j = sortBy sorter $ (qf i i) ++ (qf i j) ++ (qf j i) ++ (qf j j) 
    where qf = \z w -> [(3*w-q,3*z-r) | q <- (reverse [0..2]), r <- (reverse [0..2])]
          sorter (x0,y0) (x1,y1) 
            | x0 == x1 = compare y0 y1
            | otherwise = compare x0 x1

mmult :: (Num e, IArray UArray e, Show e) => UArray (Int, Int) e -> UArray (Int, Int) e -> UArray (Int, Int) e
mmult m0 m1 
  | (y2 - y1) /= (x2' - x1') = error "bad matrix dims"
  | otherwise = (array newBounds $ map f newRange)
    where 
          ((x1, y1) , (x2, y2)) = bounds m0
          ((x1', y1') , (x2', y2')) = bounds m1
          newBounds = ((1,1),(1 + x2 - x1, 1 + y2' - y1'))
          newRange = range newBounds
          f p@(x,y) = (p, sum $ zipWith (*) (m0r I.! x) (m1c I.! y))
          m0r = I.fromList $ (\l -> zip l (map (getRow' m0) l)) [y1 .. y2]
          m1c = I.fromList $ (\l -> zip l (map (getCol' m1) l)) [x1' .. x2']
          getCol' m c = map snd $ filter (\((_,x),_) -> x == c) (assocs m)
          getRow' m r = map snd $ filter (\((y,_),_) -> y == r) (assocs m)

-- ghc -prof -auto-all -O -o planef2 -main-is PlaneFrameData.testMain PlaneFrameData.lhs -fforce-recomp
-- ghc -rtsopts -threaded -O -o planef2 -main-is PlaneFrameData.testMain PlaneFrameData.lhs -fforce-recomp    -sstderr
testMain = do
--    [n:_] <- getArgs >>= mapM (return . read)
    n <- getArgs >>= return . read . head
    a <- randSqMatrix (-10,10) n :: IO (UArray (Int, Int) Float)
    b <- randSqMatrix (-10,10) n :: IO (UArray (Int, Int) Float)
    let c = mmult a b
        c' = array ((1,1),(n, n-1 )) $ filter (\((x,y),v) -> y /= n ) (assocs c)
    print c
    gaussElimination c' >>= print

randList :: (Num a , Random a) => (a,a) -> IO [a]
randList p = randomIO >>= return . mkStdGen >>= return . randomRs p
randSqMatrix p n = randList p >>= return . listArray ((1,1),(n,n)) 

t0 = listArray ((1,1),(2,2)) [1,0,3,0] :: UArray (Int, Int) Int
t1 = listArray ((1,1),(2,2)) [3,2,0,1] :: UArray (Int, Int) Int


gaussElimination :: (Floating e, Eq e, MArray IOUArray e IO, IArray UArray e) =>
    UArray (Int, Int) e -> IO (UArray (Int, Int) e)
gaussElimination matrix' = do
  matrix <- thaw matrix' 
  ((x1, y1) , (x2, y2)) <- getBounds matrix
  when ( not ((x2 - x1) - 1 == (y2 - y1)) ) ( error "bad dimensions" )
  mapM (\a -> (readArray matrix (a,a) >>= return . (==0.0))) [y1 .. y2] >>= \xs -> when (or xs) (error "zero on principle diagonal")
    
  do
    mapM_
        (\c -> let elimRow c rs = 
                         mapM_ (\d -> do
                                   headVal <- readArray matrix (c,d)
                                   curRow <- getRow d matrix
                                   addRowConst d (zipWith (+) curRow (map (*(-headVal)) rs) ) matrix
                                   ) [c+1 .. y2] in do       
            pivotVal <- readArray matrix (c,c)
            case pivotVal of
                0.0 -> error "pivot is 0"
                1.0 -> getRow c matrix >>= elimRow c
                v   -> (divRow c v matrix) >> getRow c matrix >>= elimRow c
        ) [y1..y2]
    
    mapM_ (\d -> do {- the row and column of the leading one -}
        {- we know right away the values of interest and we avoid adding zeroes -}
        pivRow <- mapM (\c -> readArray matrix (c,d) -- get the non zero values in the pivot row
                         ) [d..x2] 
        mapM_
            (\c -> do {- all the numbers above it -}
                aboveP <- readArray matrix (d,c) {- the # above the pivot ; add its negative to create a zero -}
                mapM_ (\(e,v) -> do {- e, the column to add to currently (row is c); v, the value of pivot row in this column -}
                        cur <- readArray matrix (e,c) 
                        writeArray matrix (e,c) (cur - aboveP*v)
                      ) (zip [d .. x2] pivRow)
               
            ) [y1 .. d - 1]
           ) [y1 + 1 .. y2]
           
    freeze matrix 
                -- returns a list corresponding to the row
          where getRow :: (Floating e, MArray IOUArray e IO) => Int -> (IOUArray (Int, Int) e) -> IO [e]
                getRow r m = do
                    ((x1, y1) , (x2, y2)) <- getBounds m
                    mapM (\c -> readArray m (c,r)) [x1..x2]
                         
                -- performs r1(i) = vals(i) forall i
                addRowConst :: (Floating e, MArray IOUArray e IO) => Int -> [e] -> (IOUArray (Int, Int) e) -> IO ()
                addRowConst r1 vals m = do
                    mapM_ (\(c,v) ->  writeArray m (c,r1) v) (zip [1..] vals)
                        
                -- perform r1 = r1 / n
                divRow :: (Floating e, MArray IOUArray e IO) => Int -> e -> (IOUArray (Int, Int) e) -> IO ()
                divRow r1 n m = do
                    ((x1, y1) , (x2, y2)) <- getBounds m
                    mapM_ (\c -> do
                        val <- readArray m (c,r1) 
                        writeArray m (c,r1) (val/n)
                            ) [x1 .. x2]    

--gaussElimination' :: (Floating e, Eq e, MArray (STUArray s) e (ST s), IArray UArray e) =>
--    UArray (Int, Int) e -> UArray (Int, Int) e -- -> (STUArray s (Int, Int) e)
--gaussElimination' matrix' = do
--  matrix <- thaw matrix' 
--  ((x1, y1) , (x2, y2)) <- getBounds matrix
--  when ( not ((x2 - x1) - 1 == (y2 - y1)) ) ( error "bad dimensions" )
--  mapM (\a -> (readArray matrix (a,a) >>= return . (==0.0))) [y1 .. y2] >>= \xs -> when (or xs) (error "zero on principle diagonal")
--    
--  do
--    mapM_
--        (\c -> let elimRow c rs = 
--                         mapM_ (\d -> do
--                                   headVal <- readArray matrix (c,d)
--                                   curRow <- getRow d matrix
--                                   addRowConst d (zipWith (+) curRow (map (*(-headVal)) rs) ) matrix
--                                   ) [c+1 .. y2] in do       
--            pivotVal <- readArray matrix (c,c)
--            case pivotVal of
--                0.0 -> error "pivot is 0"
--                1.0 -> getRow c matrix >>= elimRow c
--                v   -> (divRow c v matrix) >> getRow c matrix >>= elimRow c
--        ) [y1..y2]
--    
--    mapM_ (\d -> do {- the row and column of the leading one -}
--        {- we know right away the values of interest and we avoid adding zeroes -}
--        pivRow <- mapM (\c -> readArray matrix (c,d) -- get the non zero values in the pivot row
--                         ) [d..x2] 
--        mapM_
--            (\c -> do {- all the numbers above it -}
--                aboveP <- readArray matrix (d,c) {- the # above the pivot ; add its negative to create a zero -}
--                mapM_ (\(e,v) -> do {- e, the column to add to currently (row is c); v, the value of pivot row in this column -}
--                        cur <- readArray matrix (e,c) 
--                        writeArray matrix (e,c) (cur - aboveP*v)
--                      ) (zip [d .. x2] pivRow)
--               
--            ) [y1 .. d - 1]
--           ) [y1 + 1 .. y2]
--           
--    freeze matrix :: (Floating e, Eq e, MArray (STUArray s) e (ST s), IArray UArray e) => (STUArray s) (Int, Int) e -> (ST s) (UArray (Int, Int) e)
--    
--                -- returns a list corresponding to the row
--          where getRow r m = do
--                    ((x1, y1) , (x2, y2)) <- getBounds m
--                    mapM (\c -> readArray m (c,r)) [x1..x2]
--                         
--                -- performs r1(i) = vals(i) forall i
--                addRowConst r1 vals m = do
--                    mapM_ (\(c,v) ->  writeArray m (c,r1) v) (zip [1..] vals)
--                        
--                -- perform r1 = r1 / n
--                divRow r1 n m = do
--                    ((x1, y1) , (x2, y2)) <- getBounds m
--                    mapM_ (\c -> do
--                        val <- readArray m (c,r1) 
--                        writeArray m (c,r1) (val/n)
--                            ) [x1 .. x2]    

arrToList arr = [[arr!(a,b)|a<-[xMin..xMax]]|b<-[yMin..yMax]]
    where dom = bounds arr
          xMin = (fst . fst) dom
          yMin = (snd . fst) dom
          xMax = (fst . snd) dom
          yMax = (snd . snd) dom

af i j = Mat $ accumArray (+) 0 ((1,1),(12,12)) (zip (getIndices i j) (repeat 1))

data Matrix = Mat (UArray (Int, Int) Float)
instance Show Matrix where 
    show = show . Mesh . arrToList . (\(Mat m) -> m)

data Mesh a = Mesh [[a]]
instance Show a => Show (Mesh a) where 
    show (Mesh a) =  (intercalate "\n" ((map (intercalateV " " . (map show)) a)))
        where showF (Just n) = show n
              showF Nothing = "*"
intercalateV :: String -> [String] -> String
intercalateV i (a:[]) = if (length a <= ni) then a else take ni a
intercalateV i (a:xs) = check ++ concat (replicate (ni-(length (check))) i) ++ (intercalateV i xs)
    where check = if (length a < ni) then a else take (ni-1) a
ni = 5
          
\end{code}