#include "canon_libcanon.h"
#include "canon_libtree.h"

void tree_insert(Matentry *a, struct Tree *f) {
  f->left = NULL;
  f->right = NULL;  
  f->data = a;
}

int tree_find_insert(Matentry *a, 
		     struct Tree *f,  /* free store */
		     const int npairs, /* item size */
		     struct Tree *tree /* root */) { 
  struct Tree* r; 
  r = tree;
  while (1) {
    int j;
    Matentry res;
    for (res = 0, j = 0; j < npairs && !res; j++)
      res = a[j] - r->data[j];
    if (!res) return 0; /* found a copy */
    if (res < 0) { /* current is bigger */
      if (r->left) r = r->left;
      else {
	r->left = f;
	tree_insert(a, f);
	return 1;
      }
    }
    else { /* current is smaller */
      if (r->right) r = r->right;
      else {
	r->right = f;
	tree_insert(a, f);
	return 1;
      }
    }
  }
}
