/* each switching is represented as an array of integers 
   of length n of 0 and 1. There are no more than n/2 1's.
   in total there must be 2^{n-1} switchings (including the trivial one).

   applying all the switching to a matrix and finding the images that
   correspond to the lex. minimal multisets of entries
*/

#include <stdio.h>
#include <string.h>
#include "canon_libcanon.h"

static int *sw; /* switchings */
static int n=0;
static int mlen;
static Matentry *images;
static Matentry *multisets;
static int nsw;

static  int intcompare(const Matentry *i, const Matentry *j)  {
  if (*i > *j) return 1;
  if (*i < *j) return -1;
  return 0;
}

/* call this first, and only once! */
void init_minswsets(const int n0) {
  if (n) exit(7); /* 2nd call ! */
  n = n0;
  sw = allsw(n);
  mlen = (n-1)*n/2;
  nsw = e2(n-1);
  images = (Matentry*)calloc(mlen*nsw, sizeof(Matentry));
  multisets = (Matentry*)calloc(mlen*nsw, sizeof(Matentry));
}

/* return the number of candidates */
int minswsets(const Matentry M,       /* common denominator */
	      const Matentry a[],     /* the nxn-matrix */
	      Matentry *candidates[]) /* the switching images that give 
					the lex-min multisets of entries */
{
  /* compute all the images and the corresponding multisets of entries*/
  int ncand, i, *psw;
  Matentry *pimages, *pmsets, *mset;
  psw = sw;
  pimages = images;
  pmsets = multisets;
  for (i = 0; i < nsw; i++, psw += n, pimages += mlen, pmsets += mlen) {
    sw_act(psw, M, a, pimages, n);
    memmove((void*)pmsets, (const void*)pimages, mlen*sizeof(Matentry));
    qsort(pmsets, mlen, sizeof(Matentry),
	(int (*)(const void*, const void*))intcompare);
  }


  /* select the images that have lexmin msets of entries and
     store pointers to them in candidates */
  ncand = 1;
  candidates[0] = images;
  mset =  multisets;
  pimages = images + mlen;
  pmsets = multisets + mlen;
  
  for (i = 1; i < nsw; i++, pimages += mlen, pmsets += mlen) {
    Matentry res;
    int j;
    for (j = 0, res = 0; j < mlen && !res; j++)
      res = mset[j] - pmsets[j]; 
    if (!res) candidates[ncand++] = pimages;
    else if (res > 0) {
      ncand = 1;
      candidates[0] = pimages;
      mset = pmsets;
    }
  }
  return ncand;
}


