/* computing the orbit length */
#include <stdio.h>
#include <string.h>
#include "canon_libcanon.h"
#include "canon_libtree.h"

static int *perms; 
static int nperm = 0;
static int nsw;

static Matentry *images;
static struct Tree* tree;
static int maxlen;
static int npairs;
static int n;
static int *sw; /* switchings */

void init_orblen(const int n0) {
  if (nperm) exit(8); /* calling 2nd time ! */
  n = n0;
  perms = sym_n_pairs(n);
  nperm = 2;
  sw = allsw(n);
  nsw = e2(n-1);
  maxlen = nfac(n);
  npairs = n*(n-1)/2;
  SAFE_calloc(images,Matentry,(nsw*maxlen+1)*npairs)
  SAFE_calloc(tree, struct Tree, maxlen*nsw)
}

int orblen(const Matentry M, Matentry a[]) {
  struct Tree *f;
  Matentry *q0, *q1;
  f = tree;
  q0 = images;
  q1 = q0;
  memmove((void *)q0, (const void*)a, npairs*sizeof(Matentry));
  tree_insert(q1, f++);
  q1 += npairs;
  /* applying all the switchings */
  {        
  int igen, *csw;
  for (igen = 0, csw = sw; igen < nsw; igen++, csw+=n) {
    int res;
    sw_act(csw, M, q0, q1, n);
    res = tree_find_insert(q1, f, npairs, tree); 
    if (res) {
      q1 += npairs;
      f++;
    }
  }
  }
  /* computing the orbit */
  while(q0 < q1) {
    int igen, *p;
    p = perms;
    for (igen = 0; igen < nperm; igen++, p += npairs) {
      int res;
      perm_act(p, q0, q1, npairs);
      res = tree_find_insert(q1, f, npairs, tree); 
      if (res) {
	q1 += npairs;
	f++;
      }
    }
    q0 += npairs;
  }
  return f - tree;
}
  
