/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																			       *
 *									Orbit										   *
 *																				   *
 *								 Header file									   *
 *																				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* data type used for coordinate items (and denominator) */
typedef unsigned int coordinate_item;

/* array (pointer) to a set of coordinate items. Denominator value is stored right after the coordinate
in the same array */
typedef coordinate_item *coordinate;

/* components of an orbit */
typedef struct {
	coordinate canonical_representative;	/* dinamically allocated array of coordinate elements,
									containing first the vertex coordinate and inmediately
									followed by the orbit denominator */
	unsigned long incidence;		/* incidence of the orbit. */
	unsigned char pre_computed;
	unsigned char skipped;
} orbit_structure, *orbit_ptr;



/* Function prototypes. */
	/* Orbit creation. */
	orbit_ptr orbit_create_orbit(coordinate vertex_coordinate);

	/* Orbit deletion. */
	void orbit_delete_orbit(orbit_ptr orbit);

	/* Input-output operations. */
		/* Print all information of an orbit. */
		orbit_ptr orbit_print_orbit(orbit_ptr orbit);


