/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																			       *
 *								Orbit DataBank									   *
 *																				   *
 *								 Header file									   *
 *																				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* Function Prototypes. */
	/* Initialization. */
	void orbit_databank_initialize(long unsigned int heap_size);

	/* Finalization. */
	void orbit_databank_finalize(void);
	
	/* Orbit operations */
	unsigned char orbit_databank_insert_orbit(coordinate canonical_representative, unsigned long int orbit_incidence, unsigned char orbit_precomputed);
	orbit_ptr orbit_databank_get_next_orbit_to_compute(void);
	unsigned long int orbit_databank_get_number_of_orbits_known(void);
	unsigned long int orbit_databank_get_number_of_orbits_to_compute(void);
	unsigned long int orbit_databank_get_orbit_queue_size(void);
	unsigned long int orbit_databank_get_precomputed_orbit_count(void);
	unsigned long int orbit_databank_get_smallest_incidence_outside_range(void);

	/* Input-output functions. */
	void orbit_databank_print_orbits(void);

	/* Internal functions. */
	long unsigned int orbit_databank_calculate_orbit_incidence(orbit_ptr orbit);


