/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																						 *
 *	Orbitwise adjacency tree (binary red-black tree implementation) Abstract Data Type.  *
 *																						 *
 *									Header file											 *
 *																						 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef enum { orbitwise_adjacency_tree_BLACK, orbitwise_adjacency_tree_RED } orbitwise_adjacency_tree_node_color; /* node color */

typedef struct orbitwise_adjacency_tree_node_structure {
    struct orbitwise_adjacency_tree_node_structure *left;       /* left child */
    struct orbitwise_adjacency_tree_node_structure *right;      /* right child */
    struct orbitwise_adjacency_tree_node_structure *parent;     /* parent */
    orbitwise_adjacency_tree_node_color color;					/* node color (BLACK, RED) */
	
	coordinate orbit_canonical_representative;
	
	unsigned long count;										/* orbit adjacency count */
} orbitwise_adjacency_tree_node, *orbitwise_adjacency_tree_node_ptr;

typedef struct orbitwise_adjacency_tree_structure {
	orbitwise_adjacency_tree_node *root;
	unsigned long int size;
} orbitwise_adjacency_tree, *orbitwise_adjacency_tree_ptr;


#define orbitwise_adjacency_tree_compLT(a,b) memcmp(a,b,sizeof(coordinate_item)*(owe_setting.metric_polytope.dimension+1))<0		/* "Less than" coordinate comparator. For basic types this would be: compLT(a,b) (a < b) */

#define orbitwise_adjacency_tree_compEQ(a,b) memcmp(a,b,sizeof(coordinate_item)*(owe_setting.metric_polytope.dimension+1))==0	/* "Equal" coordinate comparator; for basic types this would be: compEQ(a,b) (a == b) */

#define orbitwise_adjacency_tree_NIL &orbitwise_adjacency_tree_sentinel	/* all leafs are sentinels */

/* Function prototypes */
	/* Access functions */
		/* Constructor */
		void orbitwise_adjacency_tree_initialize(orbitwise_adjacency_tree_ptr tree);

		/* Destructor */
		void orbitwise_adjacency_tree_delete(orbitwise_adjacency_tree_ptr tree);

		/* Insert orbit */
		coordinate orbitwise_adjacency_tree_insert(orbitwise_adjacency_tree_ptr tree, coordinate canonical_representative, slave_process_orbit_tree_ptr slave_process_slave_process_tree_ptr);

		/* Find an orbit */
		coordinate orbitwise_adjacency_tree_find(orbitwise_adjacency_tree_ptr tree, coordinate canonical_representative);

		/* In order tree parsing (debugging purposes) */
		void orbitwise_adjacency_tree_print_tree(orbitwise_adjacency_tree *tree);

		/* In order tree parsing (debugging purposes) */
		void orbitwise_adjacency_tree_inorder(orbitwise_adjacency_tree_node *node);

	/* Internal functions */
		/* tree rotation (left) function. */
		static void orbitwise_adjacency_tree_rotateLeft(orbitwise_adjacency_tree_node_ptr *tree, orbitwise_adjacency_tree_node *x);

		/* tree rotation (right) function. */
		static void orbitwise_adjacency_tree_rotateRight(orbitwise_adjacency_tree_node_ptr *tree, orbitwise_adjacency_tree_node *x);

		/* Fixup function. */
		static void orbitwise_adjacency_tree_insertFixup(orbitwise_adjacency_tree_node_ptr *tree, orbitwise_adjacency_tree_node *x);

		/* Tree elimination. */
		void orbitwise_adjacency_tree_delete_tree_structure(orbitwise_adjacency_tree_ptr tree);


