#include "canon_libcanon.h"

/* computing the powers of 2 */
int e2(int n) {
  int p;
  for (p = 1; n > 0; --n) p *= 2;
  return p;
}


int nfac(const int k) {
  if (k < 2) return k;
  return k*nfac(k-1);
}
		   
void perm_act(const int g[], const Matentry a[], Matentry im[], 
		     const int npairs) {
  int i;
  for (i = 0; i < npairs; i++) 
    im[i] = a[g[i]]; 
}

void sw_act(const int s[], const Matentry M, const Matentry a[],
		   Matentry im[], const int n) {
  int i, k;
  for (i = 0, k = 0; i < n - 1; i++) {
    int j;
    for (j = i+1; j < n; j++, k++) {
      if (s[i] + s[j] == 1) im[k] = M - a[k];
      else im[k] = a[k];
    }
  }
}
