/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																			   *
 *	  Minimum priority queue (binary heap implementation) Abstract Data Type.  *
 *																			   *
 *								  Header file								   *
 *																			   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* macros */

#define incidence_sorted_orbit_priority_queue_LEFT(x)  (2*x)            /* left child of a node */
#define incidence_sorted_orbit_priority_queue_RIGHT(x) ((2*x)+1)        /* right child of a node */
#define incidence_sorted_orbit_priority_queue_PARENT(x) (x/2)           /* parent of a node */

typedef unsigned long incidence_sorted_orbit_priority_queue_priority;	/* priority value of each element */

/* priority queue structure */
typedef struct incidence_sorted_orbit_priority_queue {
  unsigned long int size;
  unsigned long int max_elems;
  orbit_ptr *elements;
} incidence_sorted_orbit_priority_queue, *incidence_sorted_orbit_priority_queue_ptr; 


/* Function prototypes */
	/* Access functions */
		/* Constructor */
		extern unsigned char incidence_sorted_orbit_priority_queue_initalize (incidence_sorted_orbit_priority_queue_ptr queue, unsigned long int max_size);

		/* Destructor */
		void incidence_sorted_orbit_priority_queue_finalize(incidence_sorted_orbit_priority_queue_ptr queue);

		/* Insert orbit */
		orbit_ptr incidence_sorted_orbit_priority_queue_insert (incidence_sorted_orbit_priority_queue_ptr queue, orbit_ptr orbit);

		/* Extract orbit with smallest incidence */
		orbit_ptr incidence_sorted_orbit_priority_queue_extract_min (incidence_sorted_orbit_priority_queue_ptr queue);

		/* Heap on screen print (debugging purposes) */
		void incidence_sorted_orbit_priority_queue_print_heap(incidence_sorted_orbit_priority_queue_ptr queue);

	/* Internal functions */
	static void incidence_sorted_orbit_priority_queue_heapify(incidence_sorted_orbit_priority_queue_ptr queue);
