function test_gencore(ds, name_gencore)

% cont struct tells which solver is tested and which is not
cont.core_bo1 = 1;
cont.core_bo2 = 1;
cont.core_multiupdate = 1;
cont.core_maxvolume = 1;
cont.randompick = 1;
cont.enumstretch = 1;

timeLimit = 900;

for d = ds

    if ((d>=24)&&isequal(name_gencore,'cfp_gencore_random'))
        % time too long
        cont.randompick = 0;
    end
    if ((d>=40)&&isequal(name_gencore,'cfp_gencore_random'))
        % time too long
        cont.enumstretch = 0;
    end
    if ((d>=300)&&isequal(name_gencore,'cfp_gencore_random'))
        % time too long
        cont.core_maxvolume = 0;
    end
    if ((d>=22)&&isequal(name_gencore,'cfp_gencore_tube_balanced'))
        % time too long
        cont.randompick = 0;
        cont.enumstretch = 0;
    end
    if ((d>=192)&&isequal(name_gencore,'cfp_gencore_tube_balanced'))
        % numerical error
        cont.core_multiupdate = 0;
    end
    if ((d>=300)&&isequal(name_gencore,'cfp_gencore_tube_balanced'))
        % numerical error
        cont.core_maxvolume = 0;
    end
    if ((d>=22)&&isequal(name_gencore,'cfp_gencore_tube_unbalanced'))
        % time too long
        cont.randompick = 0;
        cont.enumstretch = 0;
    end
    if ((d>=300)&&isequal(name_gencore,'cfp_gencore_tube_unbalanced'))
        % numerical error
        cont.core_maxvolume = 0;
        cont.core_multiupdate = 0;
    end
    if ((d>=12)&&isequal(name_gencore,'cfp_gencore_lowdensity'))
        % time too long
        cont.randompick = 0;
    end
    if ((d>=24)&&isequal(name_gencore,'cfp_gencore_lowdensity'))
        % time too long
        cont.enumstretch = 0;
    end
    if ((d>=192)&&isequal(name_gencore,'cfp_gencore_lowdensity'))
        % numerical error
        cont.core_maxvolume = 0;
    end
    if ((d>=24)&&isequal(name_gencore,'cfp_gencore_middensity'))
        % time too long
        cont.randompick = 0;
    end
    if ((d>=300)&&isequal(name_gencore,'cfp_gencore_middensity'))
        % time too long
        % numerical error
        cont.core_maxvolume = 0;
    end
    
    time_summary = [];
    iter_summary = [];
    
    record.core_bo1 = {};
    record.core_bo2 = {};
    record.core_multiupdate = {};
    record.core_maxvolume = {};
    record.randompick = {};
    record.enumstretch = {};
 
    NumCase = 1000;
    if (d>=48)
        NumCase = 50;
    end
    
    fprintf(['d = ' num2str(d) '   ']);
    NumBack=0;
    
    for i = 1:NumCase

        for c=1:NumBack
            fprintf('\b');
        end
        NumBack = fprintf('i = %d', i);
        
        [Pts,ColorPartition,b]=feval(name_gencore,d);

        if cont.core_bo1
            [x,info]=cfp_solver_bo1(Pts,b,ColorPartition);
            record.core_bo1{i}=info;
        end
        
        if cont.core_bo2
            [x,info]=cfp_solver_bo2(Pts,b,ColorPartition);
            record.core_bo2{i}=info;
        end
        
        if cont.core_multiupdate
            [x,info]=cfp_solver_multiupdate(Pts,b,ColorPartition);
            record.core_multiupdate{i}=info;
        end
        
        if cont.core_maxvolume
            [x,info]=cfp_solver_maxvolume(Pts,b,ColorPartition);
            record.core_maxvolume{i}=info;
        end
        
        if cont.randompick
            [x,info]=cfp_solver_randompick(Pts,b,ColorPartition);
            record.randompick{i}=info;
        end
        
        if cont.enumstretch
            [x,info]=cfp_solver_enumstretch(Pts,b,ColorPartition);
            record.enumstretch{i}=info;
        end

    end
    
    if cont.core_bo1
        iter_summary.core_bo1 = get_iter_summary(record, 'core_bo1');
        time_summary.core_bo1 = get_time_summary(record, 'core_bo1');
        cont.core_bo1 = ...
            ((time_summary.core_bo1.total...
            /time_summary.core_bo1.validcases)<timeLimit);
    end

    if cont.core_bo2
        iter_summary.core_bo2 = get_iter_summary(record, 'core_bo2');
        time_summary.core_bo2 = get_time_summary(record, 'core_bo2');
        cont.core_bo2 = ...
            ((time_summary.core_bo2.total...
            /time_summary.core_bo2.validcases)<timeLimit);
    end

    if cont.core_multiupdate
        iter_summary.core_multiupdate=...
            get_iter_summary(record,'core_multiupdate');
        time_summary.core_multiupdate=...
            get_time_summary(record,'core_multiupdate');
        cont.core_multiupdate = ...
            ((time_summary.core_multiupdate.total...
            /time_summary.core_multiupdate.validcases)<timeLimit);
    end

    if cont.core_maxvolume
        iter_summary.core_maxvolume=...
            get_iter_summary(record,'core_maxvolume');
        time_summary.core_maxvolume=...
            get_time_summary(record,'core_maxvolume');
        cont.core_maxvolume = ...
            ((time_summary.core_maxvolume.total...
            /time_summary.core_maxvolume.validcases)<timeLimit);
    end

    if cont.randompick
        iter_summary.randompick = get_iter_summary(record, 'randompick');
        time_summary.randompick = get_time_summary(record, 'randompick');
        cont.randompick = ...
            ((time_summary.randompick.total...
            /time_summary.randompick.validcases)<timeLimit);
    end

    if cont.enumstretch
        iter_summary.enumstretch = get_iter_summary(record, 'enumstretch');
        time_summary.enumstretch = get_time_summary(record, 'enumstretch');
        cont.enumstretch = ...
            ((time_summary.enumstretch.total...
            /time_summary.enumstretch.validcases)<timeLimit);
    end
    
    save(['results/' name_gencore num2str(d) 'd.mat'], ...
        'record', 'iter_summary', 'time_summary');
    
    fprintf('\n');

end
    
end



function summary = get_iter_summary(record, name_solver)

infoarray = getfield(record, name_solver);
summary.totalcases = length(infoarray);
summary.total = 0;
summary.validcases = 0;
summary.max = 0;
summary.min = Inf;
for i = 1:(summary.totalcases)
    info = infoarray{i};
    if (info.feasible == 1)
        summary.validcases = summary.validcases + 1;
        summary.total = summary.total + info.iter;
        if (info.iter>summary.max)
            summary.max = info.iter;
        end
        if info.iter<summary.min
            summary.min = info.iter;
        end
    end
end

end


function summary = get_time_summary(record, name_solver)

infoarray = getfield(record, name_solver);
summary.totalcases = length(infoarray);
summary.total = 0;
summary.validcases = 0;
summary.max = 0;
summary.min = Inf;
for i = 1:(summary.totalcases)
    info = infoarray{i};
    if (info.feasible == 1)
        summary.validcases = summary.validcases + 1;
        summary.total = summary.total + info.time;
        if (info.time>summary.max)
            summary.max = info.time;
        end
        if info.time<summary.min
            summary.min = info.time;
        end
    end
end

end

function [Pts,Partition,b]=cfp_gencore_tube_balanced(d)
[Pts,Partition,b]=cfp_gencore_tube(d,pi/6,0);
end

function [Pts,Partition,b]=cfp_gencore_tube_unbalanced(d)
[Pts,Partition,b]=cfp_gencore_tube(d,pi/6,1);
end