function l = accnorm(v)
% Accurate 2-norm calculation reducing numerical error.
% Input      : v is a vector.
% Output     : l is the 2-norm of v.
% Description:
%   For example, let x=[x1 x2 x3 ...] and x1 is much larger than other
%   |xi| but not too much larger than sum of other |xi|. A simple
%   implementation of 2-norm may let norm(x) return |x1|. This routine
%   can reduce the error caused by these kind of cases.
%     The draw back is that it increase the complexity from O(n) to
%   O(nlgn).
v = sort(abs(v),'ascend');
l = norm(v,2);
return