function extract_summary(filename)

load(filename);
solvernames = fieldnames(iter_summary);

disp('****** iter summary ******');
for i = 1:length(solvernames)
    sname = solvernames{i};
    sdata = getfield(iter_summary, sname);
    if (sdata.totalcases==sdata.validcases)
        disp([sname ': ' num2str(sdata.total/sdata.validcases) ...
             ' (' num2str(sdata.max) ')']);
    else
        disp([sname ': ' 'partially invalid']);
    end
end

disp('****** time summary ******');
for i = 1:length(solvernames)
    sname = solvernames{i};
    sdata = getfield(time_summary, sname);
    if (sdata.totalcases==sdata.validcases)
        disp([sname ': ' num2str(sdata.total/sdata.validcases) ...
             ' (' num2str(sdata.max) ')']);
    else
    disp([sname ': ' 'partially invalid']);
    end
end


end

