/*
 * Decompiled with CFR 0.152.
 */
package adjusting.availability_adjusting;

import java.io.Serializable;
import java.util.GregorianCalendar;

public class FailurePeriod
implements Serializable {
    private static final long serialVersionUID = 1529667125846716840L;
    GregorianCalendar beginningTime;
    GregorianCalendar endTime;

    public FailurePeriod(GregorianCalendar beginningTime, GregorianCalendar endTime) {
        this.setBeginningTime(beginningTime);
        this.setEndTime(endTime);
        if (beginningTime.after(endTime)) {
            endTime = (GregorianCalendar)beginningTime.clone();
            this.setEndTime(endTime);
            System.err.print("FailingPeriod.FailingPeriod(): beggining time is after end time.");
        }
    }

    public GregorianCalendar getBeginningTime() {
        return this.beginningTime;
    }

    private void setBeginningTime(GregorianCalendar beginningTime) {
        this.beginningTime = beginningTime;
    }

    public GregorianCalendar getEndTime() {
        return this.endTime;
    }

    private void setEndTime(GregorianCalendar endTime) {
        this.endTime = endTime;
    }

    protected boolean isTimeInPeriod(GregorianCalendar time) {
        return time.after(this.getBeginningTime()) && time.before(this.getEndTime());
    }

    protected boolean isOverLapped(FailurePeriod period) {
        return this.isTimeInPeriod(period.getBeginningTime()) || this.isTimeInPeriod(period.getEndTime()) || period.getBeginningTime().before(this.beginningTime) && period.getEndTime().after(this.endTime);
    }

    public double getLengthInMinutes() {
        return (double)(this.getEndTime().getTimeInMillis() - this.getBeginningTime().getTimeInMillis()) / 60000.0;
    }

    public double getLengthInMillis() {
        return this.getEndTime().getTimeInMillis() - this.getBeginningTime().getTimeInMillis();
    }

    public String toString() {
        return String.valueOf(this.getBeginningTime().getTime().toString()) + " - " + this.getEndTime().getTime().toString() + "(" + this.getLengthInMinutes() + " minutes )";
    }

    public void print() {
        System.out.println(this.toString());
    }
}

